/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.form;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.method.MethodExpander;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.expander.StrutsImplementor;
import blanco.web.struts.expander.TypeFactory;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateMethod extends MethodExpander {

    private Form _definition = null;

    private TypeFactory _typeFactory = null;

    private Value _mappintArgument = null;

    private Value _requestArgument = null;

    public ValidateMethod(Form definition, TypeFactory typeFactory) {
        super("validate");
        _definition = definition;
        _typeFactory = typeFactory;
    }

    public void setupSignature() {
        _mappintArgument = new Value(ActionMapping.class, "mapping");
        _requestArgument = new Value(HttpServletRequest.class, "request");

        addArgument(_mappintArgument);
        addArgument(_requestArgument);

        setReturnType(new Type(ActionErrors.class));

        String doc = "";

        doc = "validate\bhB";
        getJavaDoc().addLine(doc);

        doc = "̃\bhStrutsɂĂ΂܂B";
        getJavaDoc().addLine(doc);

        String name = "";
        name = _mappintArgument.getName();
        getJavaDoc().addParameter(name, name + " p[^B");

        name = _requestArgument.getName();
        getJavaDoc().addParameter(name, name + " p[^B");

        doc = "G[ȂꍇAActionErrosԂ܂B";
        getJavaDoc().addReturn(doc);
    }

    public void implement() {
        StrutsImplementor si = new StrutsImplementor(getData());
        Value errors = new Value(ActionErrors.class, "errors");
        si.declare(errors, new Call(ActionErrors.class));

        if (_definition.isAutoValidation()) {
            Call c = new Call("validateRequired");
            c.addArgument(_mappintArgument);
            c.addArgument(_requestArgument);

            si.assign(errors, c);

            Receiver r = new Receiver(errors, "isEmpty");
            r.setNagation(true);
            si.openIf(r);
            si.addReturn(errors);
            si.closeIf();

            c = new Call(ValidateFormatMethod.createName());
            c.addArgument(_mappintArgument);
            c.addArgument(_requestArgument);
            si.assign(errors, c);

            r = new Receiver(errors, "isEmpty");
            r.setNagation(true);
            si.openIf(r);
            si.addReturn(errors);
            si.closeIf();

            c = new Call(ValidateRangeMethod.createName());
            c.addArgument(_mappintArgument);
            c.addArgument(_requestArgument);
            si.assign(errors, c);
        }
        si.addReturn(errors);
    }

}
