/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.form;

import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.expander.TypeFactory;
import blanco.web.struts.expander.form.base.BaseValidationMethod;
import blanco.web.struts.runtime.validator.message.ErrorMessageKey;

/**
 * @author Yasuo Nakanishi
 */
public class ValidateFormatMethod extends BaseValidationMethod {

    private Value _mappintArgument = null;

    private Value _requestArgument = null;

    public ValidateFormatMethod(Form form, TypeFactory typeFactory) {
        super(createName(), form, typeFactory);
    }

    public static String createName() {
        return "validateFormat";
    }

    public void setupSignature() {
        super.setupSignature();

        String doc = "";

        doc = "tH[}bg؃\bhB";
        getJavaDoc().addLine(doc);

        doc = "validate()\bhɂĂ΂܂B";
        getJavaDoc().addLine(doc);

    }

    protected void implementFiledValidation(FormField field, Value errors) {
        Value fieldValue = getField(field.getValue().getName());

        FieldValidation validation = field.getValidation();

        Type keyType = getRuntimeType(ErrorMessageKey.class);

        boolean formatCheck = validation.isCheckFormat();
        if (formatCheck) {
            getImplementor().checkFormat(field, fieldValue, errors, keyType);
        }

        boolean sizeCheck = field.getValidation().isCheckSize();
        if (sizeCheck) {
            getImplementor().checkSize(field, fieldValue, errors, keyType);
        }

        boolean regexCheck = field.getValidation().isCheckRegex();
        if (regexCheck) {
            getImplementor().checkRegex(field, fieldValue, errors, keyType);
        }

        if (formatCheck || sizeCheck || regexCheck) {
            getImplementor().emptyLine();
        }
    }

    protected boolean existTableValidation(FormTable table) {
        return table.existFormValidationField();
    }

    protected void implementTableValidation(Value item, FormField field,
            Value errors) {
        FieldValidation validation = field.getValidation();
        boolean formatCheck = validation.isCheckFormat();

        Type keyType = getRuntimeType(ErrorMessageKey.class);

        if (formatCheck) {
            getImplementor().checkTableFormat(item, field, errors, keyType);
        }

        boolean sizeCheck = validation.isCheckSize();
        if (sizeCheck) {
            getImplementor().checkTableSize(item, field, errors, keyType);
        }

        boolean regexCheck = field.getValidation().isCheckRegex();
        if (regexCheck) {
            getImplementor().checkTableRegex(item, field, errors, keyType);
        }

        if (formatCheck || sizeCheck || regexCheck) {
            getImplementor().emptyLine();
        }
    }
}
