/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.action;

import java.lang.reflect.Method;

import org.apache.struts.action.ActionForward;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.method.AbstractMethod;
import blanco.web.struts.definition.form.FormEvent;

/**
 * @author Yasuo Nakanishi
 */
public class EventMethod extends AbstractMethod {
    private Type _formType = null;

    private Method _method = null;

    private FormEvent _event = null;

    public EventMethod(FormEvent event, Type formType, Method method) {
        super(createEventName(event.getName()));
        _event = event;
        _formType = formType;
        _method = method;
    }

    public static String createEventName(String event) {
        String result = "";
        if (event.equals("init")) {
            result = event;
        } else if (event.equals("load")) {
            result = "onLoad";
        } else {
            result = "onClick" + getNameAdjuster().toTitleCase(event);
        }
        return result;
    }

    public void setupSignature() {

        setScope(Scope.PROTECTED);

        if (getName().equals("init")) {
            setReturnType(new Type(void.class));
        } else {
            setReturnType(new Type(ActionForward.class));
        }

        Class[] parameters = _method.getParameterTypes();
        Value parameter = null;
        Type type = null;
        String name = "";
        for (int i = 0; i < parameters.length; i++) {
            type = new Type(parameters[i]);
            name = getParameterName(parameters[i]);
            if (name.equals("form")) {
                parameter = new Value(_formType, name);
            } else {
                parameter = new Value(type, name);
            }
            addArgument(parameter);
        }

        addException(Exception.class);

        String doc = "";
        if (!_event.getDescription().equals("")) {
            doc = _event.getDescription() + "Cxg\bhB";
        } else {
            doc = getName() + " Cxg\bhB";
        }
        getJavaDoc().addLine(doc);

        doc = "TuNXŎB";
        getJavaDoc().addLine(doc);

        for (int i = 0; i < parameters.length; i++) {
            type = new Type(parameters[i]);
            name = EventMethod.getParameterName(parameters[i]);
            getJavaDoc().addParameter(name, name + " p[^B");
        }
    }

    public static String getParameterName(Class parameter) {
        String className = new Type(parameter).getName();
        String[] names = className.replaceAll("[A-Z]", " $0").split("\\s");
        return names[names.length - 1].toLowerCase();
    }

}
