/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.action;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForward;

import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Cast;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.ig.expander.method.MethodExpander;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormEvent;
import blanco.web.struts.expander.StrutsImplementor;

/**
 * @author Yasuo Nakanishi
 */
public class DispatchMethod extends MethodExpander {
    private String _eventParameterName = null;

    private Method _method = null;

    private Iterator _eventIterator = null;

    private Form _form = null;

    private List _parameterList = new ArrayList();

    private Map _parameterMap = new Hashtable();

    public DispatchMethod(Method method, String eventParameterName, Form form) {
        super(method.getName());
        _eventParameterName = eventParameterName;
        _method = method;
        _form = form;
    }

    public void setupSignature() {

        // TODO SuperNXɋ@\ڂȂB
        int m = _method.getModifiers();
        if (Modifier.isPublic(m)) {
            setScope(Scope.PUBLIC);
        } else if (Modifier.isProtected(m)) {
            setScope(Scope.PROTECTED);
        } else if (Modifier.isPrivate(m)) {
            setScope(Scope.PRIVATE);
        }

        Class[] exceptions = _method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; i++) {
            addException(new Type(exceptions[i]));
        }

        Class[] parameters = _method.getParameterTypes();
        Value parameter = null;
        Type type = null;
        String name = "";
        for (int i = 0; i < parameters.length; i++) {
            type = new Type(parameters[i]);
            name = EventMethod.getParameterName(parameters[i]);
            parameter = new Value(type, name);
            addArgument(parameter);
            _parameterList.add(name);
            _parameterMap.put(name, parameter);
        }

        setScope(Scope.PUBLIC);
        setFinal(true);
        setReturnType(new Type(_method.getReturnType()));

        String doc = "";
        doc = _method.getName() + " \bhB";
        getJavaDoc().addLine(doc);

        doc = "Cxg̐U蕪sB";
        getJavaDoc().addLine(doc);

        for (int i = 0; i < parameters.length; i++) {
            type = new Type(parameters[i]);
            name = EventMethod.getParameterName(parameters[i]);
            getJavaDoc().addParameter(name, name + " p[^B");
        }
    }

    public void implement() {
        StrutsImplementor si = new StrutsImplementor(getData());

        Receiver r = null;
        Call c = null;
        Statement s = null;

        Value mappingArgument = (Value) _parameterMap.get("mapping");
        Value formArgument = (Value) _parameterMap.get("form");
        Value requestArgument = (Value) _parameterMap.get("request");
        Value responseArguemnt = (Value) _parameterMap.get("response");
        Value connectionArguemnt = null;

        if (_form.isUsingDb()) {
            connectionArguemnt = (Value) _parameterMap.get("connection");
        }

        Value result = new Value(ActionForward.class, "result");
        si.declareByDefault(result);

        Value actionForm = new Value(_form.getType(), "actionForm");
        Cast cast = new Cast(_form.getType());
        cast.value(formArgument);
        si.declare(actionForm, cast);

        si.emptyLine();

        Value event = new Value(String.class, "event");
        r = new Receiver(requestArgument);
        c = r.call("getParameter");
        c.addArgument(new StringLiteral(_eventParameterName));
        si.declare(event, r);

        si.openIf(getIsEmptyStatement(event));
        cast = new Cast(String.class);
        r = cast.value(requestArgument);
        c = r.call("getAttribute");
        c.addArgument(new StringLiteral(_eventParameterName));
        si.assign(event, cast);
        si.closeIf();

        si.openIf(getIsEmptyStatement(event));

        Value message = new Value(String.class, "message");
        si.declare(message, new StringLiteral("CxgIDUIn܂łB"));

        c = new Call(Exception.class);
        c.addArgument(message);
        si.addThrow(c);
        si.closeIf();

        si.emptyLine();

        c = new Call("init");
        Value[] parameters = null;
        if (_form.isUsingDb()) {
            parameters = new Value[] { mappingArgument, actionForm,
                    requestArgument, responseArguemnt, connectionArguemnt };
        } else {
            parameters = new Value[] { mappingArgument, actionForm,
                    requestArgument, responseArguemnt, };
        }

        si.addStatement(getEventCallStatement("init", parameters));

        si.emptyLine();

        FormEvent formEvent = null;
        String eventMethod = "";

        Iterator eventIterator = _form.getEventIterator();
        formEvent = new FormEvent("load");
        formEvent.setDescription("[h");

        si.openIf(si.getCheckEventStatement(event, formEvent.getName()));

        eventMethod = "onLoad";
        si.assign(result, getEventCallStatement(eventMethod, parameters));

        while (eventIterator.hasNext()) {
            formEvent = (FormEvent) eventIterator.next();

            si.addElseIf(si.getCheckEventStatement(event, formEvent.getName()));

            eventMethod = EventMethod.createEventName(formEvent.getName());
            si.assign(result, getEventCallStatement(eventMethod, parameters));
        }
        si.addElse();

        message = new Value(String.class, "message");
        si.declare(message, new StringLiteral("sȃCxgIDUIn܂BCxgID:"));
        r = new Receiver(message);
        r.join("+=", new Statement(event));
        si.addStatement(r);
        c = new Call(Exception.class);
        c.addArgument(message);
        si.addThrow(c);
        si.closeIf();

        si.addReturn(result);

    }

    private Statement getIsEmptyStatement(Value event) {
        Receiver left = new Receiver(event);
        Statement s = new Statement(Value.NULL);
        left.join("==", s);
        Receiver right = new Receiver(event);
        Call c = right.call("equals");
        c.addArgument(new StringLiteral(""));
        s.join("||", right);
        return left;
    }

    public Statement getEventCallStatement(String eventName, Value[] parameters) {
        Call c = new Call(eventName);
        for (int i = 0; i < parameters.length; i++) {
            c.addArgument(parameters[i]);
        }
        return c;
    }
}
