/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander.action;

import java.lang.reflect.Method;
import java.util.Iterator;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormEvent;
import blanco.web.struts.metadata.StrutsMetadata;

/**
 * @author Yasuo Nakanishi
 */
public class AbstractActionClass extends ClassExpander {
    private Method _dispatchMethod = null;

    private String _eventParameterName = "";

    private Form _form = null;

    private boolean _usingDb = false;

    public AbstractActionClass(Type type, StrutsMetadata metadata, Form form) {
        super(type);
        _eventParameterName = metadata.getEventParameterName();
        _form = form;
        if (!_form.isUsingDb()) {
            _dispatchMethod = metadata.getDispatchMethod();
        } else {
            _dispatchMethod = metadata.getDispatchDbMethod();
        }
    }

    protected void expandClassStruct() {

        Type formType = _form.getType();
        setSuperClass(new Type(_dispatchMethod.getDeclaringClass()));
        FormEvent event = null;

        addMethod(new DispatchMethod(_dispatchMethod, _eventParameterName,
                _form));

        event = new FormEvent("init", "");
        addMethod(new EventMethod(event, formType, _dispatchMethod));

        event = new FormEvent("load", "[h");
        addMethod(new EventMethod(event, formType, _dispatchMethod));

        Iterator i = _form.getEventIterator();
        while (i.hasNext()) {
            event = (FormEvent) i.next();
            addMethod(new EventMethod(event, formType, _dispatchMethod));
        }

        String doc = "";
        doc = _form.getActionClassName() + "B";
        getJavaDoc().addLine(doc);

        doc = _form.getActionClassOutLine();
        getJavaDoc().addLine(doc);
    }

    protected final boolean isAbstract() {
        return true;
    }

}
