/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander;

import blanco.ig.expander.Type;
import blanco.web.struts.generator.StrutsSetting;

/**
 * @author Yasuo Nakanishi
 */
public class TypeFactory {
    private StrutsSetting _setting = null;

    public TypeFactory(StrutsSetting setting) {
        _setting = setting;
    }

    public Type createRuntime(Class type) {
        String typeName = type.getName().replaceAll(
                "blanco.web.struts.runtime", getRuntiemPackage());
        return new Type(typeName);
    }

    private String getRuntiemPackage() {
        return _setting.getRootNameSpace() + ".runtime";
    }
}
