/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.expander;

import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;

import blanco.core.datastruct.ReadAccessor;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Array;
import blanco.ig.expander.implementor.Call;
import blanco.ig.expander.implementor.Cast;
import blanco.ig.expander.implementor.ImplementData;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.implementor.Receiver;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.implementor.StringLiteral;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.SizeValidationType;
import blanco.web.struts.runtime.validator.FormatValidation;
import blanco.web.struts.runtime.validator.Validator;

/**
 * @author Yasuo Nakanishi
 */
public class StrutsImplementor extends Implementor {

    public StrutsImplementor(ImplementData data) {
        super(data);
    }

    public void checkRequire(Value result, Value fieldValue, FormField field,
            Type keyType) {
        Call c = new Call(Validator.class, "validateRequired");
        c.addArgument(getFormField(fieldValue));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "REQUIRED"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getRequireErrorArgument(field, getFieldObject(field,
                fieldValue)));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkTableRequire(Value tableItem, FormField field,
            Value result, Type keyType) {

        Call c = new Call(Validator.class, "validateRequired");
        c.addArgument(getTableField(tableItem, field.getValue()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "REQUIRED"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getRequireErrorArgument(field, getTableFieldObject(
                tableItem, field.getValue())));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    private Statement getFormField(Value value) {
        Statement result = null;
        Type type = value.getType();
        if (type.isPrimitive() && type.equals(int.class)) {
            Call c = new Call(Integer.class, "toString");
            c.addArgument(value);
            result = c;
        } else if (type.isPrimitive() && type.equals(boolean.class)) {
            Call c = new Call(Boolean.class, "toString");
            c.addArgument(value);
            result = c;
        } else {
            result = new Statement(value);
        }
        return result;
    }

    public Statement getCheckEventStatement(Value event, String eventName) {
        Receiver r = new Receiver(event);
        Call c = r.call("equals");
        c.addArgument(new StringLiteral(eventName));
        return r;
    }

    public void checkFormat(FormField field, Value fieldValue, Value result,
            Type keyType) {

        String format = field.getValidation().getFormat();
        String methodName = FormatValidation.nameToMethodName(format);
        Call c = new Call(Validator.class, methodName);
        c.addArgument(getFormField(fieldValue));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, FormatValidation
                .nameToFieldName(format)));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getFormatErrorArgument(field, getFieldObject(field,
                fieldValue)));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkRegex(FormField field, Value fieldValue, Value result,
            Type keyType) {

        Call c = new Call(Validator.class, "validateRegex");
        c.addArgument(getFormField(fieldValue));
        c.addArgument(new StringLiteral(field.getValidation().getRegex()));
        c.addArgument(new StringLiteral(field.getValidation()
                .getRegexMessageKey()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "REGEX"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getRegexErrorArgument(field, getFieldObject(field,
                fieldValue)));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkSize(FormField field, Value fieldValue, Value result,
            Type keyType) {

        Call c = createValidateSizeCall(field);
        c.addArgument(fieldValue);
        c.addArgument(new StringLiteral(field.getValidation().getMinSize()));
        c.addArgument(new StringLiteral(field.getValidation().getMaxSize()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType,
                getSizeErrorMessageField(field)));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getSizeErrorArgument(field, getFieldObject(field,
                fieldValue)));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    private Call createValidateSizeCall(FormField field) {
        Call result = null;
        SizeValidationType type = field.getValidation().getSizeValidationType();
        if (type.equals(SizeValidationType.BYTES)) {
            result = new Call(Validator.class, "validateStringSizeByBytes");
        } else if (type.equals(SizeValidationType.LENGTH)) {
            result = new Call(Validator.class, "validateStringSizeByLength");
        }
        return result;
    }

    private String getSizeErrorMessageField(FormField field) {
        String result = null;
        SizeValidationType type = field.getValidation().getSizeValidationType();
        if (type.equals(SizeValidationType.BYTES)) {
            result = "BYTE_SIZE";
        } else if (type.equals(SizeValidationType.LENGTH)) {
            result = "LENGTH_SIZE";
        }
        return result;
    }

    public void checkIntRange(FormField field, Value fieldValue, Value result,
            Type keyType) {

        Call c = new Call(Validator.class, "validateIntRange");
        c.addArgument(fieldValue);
        c.addArgument(new StringLiteral(field.getValidation().getMinRange()));
        c.addArgument(new StringLiteral(field.getValidation().getMaxRange()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "RANGE"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getIntRangeErrorArgument(field, getFieldObject(
                field, fieldValue)));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkTableFormat(Value tableItem, FormField field,
            Value result, Type keyType) {

        String format = field.getValidation().getFormat();
        String methodName = FormatValidation.nameToMethodName(format);
        Call c = new Call(Validator.class, methodName);
        c.addArgument(getTableField(tableItem, field.getValue()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, FormatValidation
                .nameToFieldName(format)));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getFormatErrorArgument(field, getTableFieldObject(
                tableItem, field.getValue())));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkTableRegex(Value tableItem, FormField field, Value result,
            Type keyType) {

        Call c = new Call(Validator.class, "validateRegex");

        c.addArgument(getTableField(tableItem, field.getValue()));
        c.addArgument(new StringLiteral(field.getValidation().getRegex()));
        c.addArgument(new StringLiteral(field.getValidation()
                .getRegexMessageKey()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "REGEX"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getRegexErrorArgument(field, getTableFieldObject(
                tableItem, field.getValue())));

        Receiver r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    private Statement getTableField(Value item, Value value) {
        Statement result = null;
        Type type = value.getType();

        Receiver r = new Receiver(item, ReadAccessor.createName(value));

        if (type.isPrimitive() && type.equals(int.class)) {
            Call c = new Call(Integer.class, "toString");
            c.addArgument(r);
            result = c;
        } else if (type.isPrimitive() && type.equals(boolean.class)) {
            Call c = new Call(Boolean.class, "toString");
            c.addArgument(r);
            result = c;
        } else {
            result = r;
        }
        return result;
    }

    public void checkTableSize(Value tableItem, FormField field, Value result,
            Type keyType) {

        Call c = createValidateSizeCall(field);
        Receiver r = new Receiver(tableItem, ReadAccessor.createName(field
                .getValue()));
        c.addArgument(r);
        c.addArgument(new StringLiteral(field.getValidation().getMinSize()));
        c.addArgument(new StringLiteral(field.getValidation().getMaxSize()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType,
                getSizeErrorMessageField(field)));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getSizeErrorArgument(field, getTableFieldObject(
                tableItem, field.getValue())));

        r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public void checkTableIntRange(Value tableItem, FormField field,
            Value result, Type keyType) {

        Call c = new Call(Validator.class, "validateIntRange");
        Receiver r = new Receiver(tableItem, ReadAccessor.createName(field
                .getValue()));
        c.addArgument(r);
        c.addArgument(new StringLiteral(field.getValidation().getMinRange()));
        c.addArgument(new StringLiteral(field.getValidation().getMaxRange()));
        c.setNagation(true);
        openIf(c);

        Value messageKey = new Value(String.class, "messageKey");
        declare(messageKey, getErrorMessageKey(keyType, "RANGE"));

        Value arguments = new Value(Object[].class, "arguments");
        declare(arguments, getIntRangeErrorArgument(field, getTableFieldObject(
                tableItem, field.getValue())));

        r = new Receiver(result);
        c = r.call("add");
        c.addArgument(new Receiver(ActionErrors.class, "GLOBAL_ERROR"));
        c.addArgument(newActionError(messageKey, arguments));
        addStatement(r);

        closeIf();
    }

    public Statement getLoopEndStatement(Value tableField, Value counter) {
        Receiver r = new Receiver(counter);
        r.join("<", new Receiver(tableField, "size"));
        return r;
    }

    public void assignTableItem(Value tableItem, Type type, Value tableField,
            Value counter) {
        Cast cast = new Cast(type);
        Receiver r = cast.value(tableField);
        Call call = r.call("get");
        call.addArgument(counter);
        assign(tableItem, cast);
    }

    private Statement getFieldObject(FormField field, Value fieldValue) {
        Statement result = null;

        Value value = field.getValue();
        Type type = value.getType();
        String name = value.getName();
        if (type.equals(int.class)) {
            Call c = new Call(Integer.class);
            c.addArgument(fieldValue);
            result = c;
        } else if (type.equals(boolean.class)) {
            Call c = new Call(Boolean.class);
            c.addArgument(fieldValue);
            result = c;
        } else {
            result = new Statement(fieldValue);
        }
        return result;
    }

    private Statement getTableFieldObject(Value item, Value tableField) {
        Statement result = null;

        Type type = tableField.getType();
        Receiver r = new Receiver(item, ReadAccessor.createName(tableField));

        if (type.equals(int.class)) {
            Call c = new Call(Integer.class);
            c.addArgument(r);
            result = c;
        } else if (type.equals(boolean.class)) {
            Call c = new Call(Boolean.class);
            c.addArgument(r);
            result = c;
        } else {
            result = r;
        }
        return result;
    }

    private Receiver getErrorMessageKey(Type errorMessageKey, String fieldName) {
        Receiver r = new Receiver(errorMessageKey, fieldName);
        r.call("getKey");
        return r;
    }

    private Call newActionError(Value messageKey, Value messageArguments) {
        Call result = new Call(ActionError.class);
        result.addArgument(messageKey);
        result.addArgument(messageArguments);
        return result;
    }

    private Array getSizeErrorArgument(FormField field, Statement dataStatement) {
        Array result = new Array(Object.class);
        String name = field.getName();
        FieldValidation validatoin = field.getValidation();
        result.addArgument(dataStatement);
        result.addArgument(new StringLiteral(validatoin.getMinSize()));
        result.addArgument(new StringLiteral(validatoin.getMaxSize()));
        result.addArgument(new StringLiteral(name));
        return result;
    }

    private Array getIntRangeErrorArgument(FormField field,
            Statement dataStatement) {
        Array result = new Array(Object.class);
        String name = field.getName();
        FieldValidation validatoin = field.getValidation();
        result.addArgument(dataStatement);
        result.addArgument(new StringLiteral(validatoin.getMinRange()));
        result.addArgument(new StringLiteral(validatoin.getMaxRange()));
        result.addArgument(new StringLiteral(name));
        return result;
    }

    private Array getFormatErrorArgument(FormField field,
            Statement dataStatement) {
        Array result = new Array(Object.class);
        String name = field.getName();
        FieldValidation validatoin = field.getValidation();
        result.addArgument(dataStatement);
        result.addArgument(new StringLiteral(validatoin.getFormat()));
        result.addArgument(new StringLiteral(name));
        return result;
    }

    private Array getRegexErrorArgument(FormField field, Statement dataStatement) {
        Array result = new Array(Object.class);
        String name = field.getName();
        FieldValidation validatoin = field.getValidation();
        result.addArgument(dataStatement);
        result.addArgument(new StringLiteral(validatoin.getRegex()));
        result.addArgument(new StringLiteral(name));
        return result;
    }

    private Array getRequireErrorArgument(FormField field,
            Statement dataStatement) {
        Array result = new Array(Object.class);
        String name = field.getName();
        result.addArgument(dataStatement);
        result.addArgument(new StringLiteral(name));
        return result;
    }
}
