/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.collector;

import jxl.Sheet;
import jxl.Workbook;
import blanco.ig.expander.Type;
import blanco.web.struts.definition.form.FieldValidation;
import blanco.web.struts.definition.form.Form;
import blanco.web.struts.definition.form.FormEvent;
import blanco.web.struts.definition.form.FormField;
import blanco.web.struts.definition.form.FormTable;
import blanco.web.struts.definition.form.SizeValidationType;
import blanco.web.struts.generator.StrutsSetting;

/**
 * @author Yasuo Nakanishi
 */
public class ExcelSheetIterator {
    private Workbook _book = null;

    private StrutsSetting _setting = null;

    private int _tableClassNamePrefixSizeByGuiId = 0;

    private int _currentSheet = -1;

    public ExcelSheetIterator(Workbook book, StrutsSetting setting) {
        _book = book;
        _setting = setting;
    }

    private Sheet getSheet() {
        return _book.getSheet(_currentSheet);
    }

    public boolean isConfigurationFile() {
        return getSheet().getName().equals("blancoStrutsConfig");
    }

    private FieldValidation collectFieldValidation(int index) {
        FieldValidation result = new FieldValidation();
        boolean check = false;

        check = checkRequired(index);
        result.setCheckRequire(check);

        check = checkFormat(index);
        result.setCheckFormat(check);
        if (check) {
            result.setFormat(getValidationFormat(index));
        }

        check = checkRegex(index);
        result.setCheckRegex(check);
        if (check) {
            result.setRegex(getRegex(index));
            result.setRegexMessageKey(getRegexMessageKey(index));
        }

        check = checkSize(index);
        result.setCheckSize(check);
        if (check) {
            result.setSizeValidationType(getSizeValidationType(index));
            result.setMinSize(getMinSize(index));
            result.setMaxSize(getMaxSize(index));
        }

        check = checkRange(index);
        result.setCheckRange(check);
        if (check) {
            result.setMinRange(getMinRange(index));
            result.setMaxRange(getMaxRange(index));
        }
        return result;
    }

    private boolean checkRequired(int index) {
        return getFieldValue(12, index).equals("");
    }

    private boolean checkRegex(int index) {
        return !getRegex(index).equals("");
    }

    private boolean checkFormat(int index) {
        boolean result = !(getValidationFormat(index).equals("Ȃ") || getValidationFormat(
                index).equals(""));
        return result;
    }

    private boolean checkSize(int index) {
        String min = getMinSize(index);
        String max = getMaxSize(index);
        return !min.equals("") || !max.equals("");
    }

    private boolean checkRange(int index) {
        String min = getMinRange(index);
        String max = getMaxRange(index);
        return !min.equals("") || !max.equals("");
    }

    private String getValidationFormat(int index) {
        return getFieldValue(13, index);
    }

    private String getRegex(int index) {
        return getFieldValue(14, index);
    }

    private String getRegexMessageKey(int index) {
        return getFieldValue(15, index);
    }

    private SizeValidationType getSizeValidationType(int index) {
        SizeValidationType result = null;
        String value = getFieldValue(7, index);
        if (value == null || value.equals("") || value.equals("byte")) {
            result = SizeValidationType.BYTES;
        } else if (value.equals("")) {
            result = SizeValidationType.LENGTH;
        }

        assert result != null;
        return result;
    }

    private String getMaxSize(int index) {
        return getFieldValue(6, index);
    }

    private String getMinSize(int index) {
        return getFieldValue(5, index);
    }

    private String getMaxRange(int index) {
        return getFieldValue(17, index);
    }

    private String getMinRange(int index) {
        return getFieldValue(16, index);
    }

    public boolean next() {
        _currentSheet++;
        return _currentSheet < _book.getNumberOfSheets();
    }

    private String getFieldType(int index) {
        return getFieldValue(4, index);
    }

    private String getFieldName(int index) {
        return getFieldValue(1, index);
    }

    private FormField collectField(int index) {
        String name = getFieldName(index);
        String type = getFieldType(index);

        validateField(index);

        if (isDropdownList(index)) {
            type = new Type(String.class).getFullName();
        }

        FormField result = new FormField(new Type(type), name);
        String[] events = getFieldEvents(index);
        for (int i = 0; i < events.length; i++) {
            assert !events[i].equals("");
            result.addEvent(events[i]);
        }

        result.setName(getFieldDiscription(index));
        result.setDefault(getFieldDefaultValue(index));
        result.setUiType(getFieldUiType(index));
        result.setValidation(collectFieldValidation(index));
        return result;
    }

    private void validateField(int index) {
        String name = getFieldName(index);
        Type type = new Type(getFieldType(index));
        String uiType = getFieldUiType(index);

        if (checkSize(index)) {
            if (!type.equals(String.class)) {
                String message = "`FbNT|[gȂ^łB";
                message += " tB[h:" + name;
                message += " ^:" + type.getFullName();
                System.out.println(message);
            }
        }

        if (checkRange(index)) {
            if (!type.equals(int.class)) {
                String message = "͈̓`FbNT|[gȂ^łB";
                message += " tB[h:" + name;
                message += " ^:" + type.getFullName();
                System.out.println(message);
            }
        }
    }

    private String getFieldDefaultValue(int index) {
        return getFieldValue(9, index);
    }

    private boolean existField(int index) {
        boolean result = true;

        if (getFieldIndex(index) >= getSheet().getRows()) {
            result = false;
        } else {
            String name = getFieldName(index);
            String type = getFieldType(index);
            if (name.equals("") && type.equals("")) {
                result = false;
            }
        }
        return result;
    }

    private String getFormNameSpace() {
        return getCellValue(2, 6);
    }

    private String getActionNameSpace() {
        return getCellValue(2, 12);
    }

    private String getActionName() {
        String result = getCellValue(2, 13);
        if (result.equals("")) {
            result = "Abstract" + getGuiId() + "Action";
        }
        return result;
    }

    private String getFormName() {
        String result = getCellValue(2, 7);
        if (result.equals("")) {
            result = getGuiId() + "Form";
        }
        return result;
    }

    private boolean isUsingDb() {
        return getCellValue(2, 3).equals("DBڑ");
    }

    private String getGuiId() {
        return getCellValue(2, 1);
    }

    private String getFormClassName() {
        return getCellValue(2, 8);
    }

    private String getFormClassOutLine() {
        return getCellValue(2, 9);
    }

    private String getActionClassName() {
        return getCellValue(2, 14);
    }

    private String getActionClassOutLine() {
        return getCellValue(2, 15);
    }

    private boolean isAutoValidation() {
        return getCellValue(2, 2).equals("Ȃ");
    }

    public Form collectFrom() {
        String nameSpace = getFormNameSpace();
        String className = getFormName();
        Form form = new Form(nameSpace, className);

        form.setFormClassName(getFormClassName());
        form.setFormClassOutLine(getFormClassOutLine());
        form.setAutoValidation(isAutoValidation());
        form.setActionType(getActionNameSpace(), getActionName());
        form.setActionClassName(getActionClassName());
        form.setActionClassOutLine(getActionClassOutLine());
        form.setUsingDb(isUsingDb());

        for (int i = 0; existField(i); i++) {
            if (isEventField(i)) {
                FormEvent event = new FormEvent(getFieldName(i));
                event.setDescription(getFieldDiscription(i));
                form.addEvent(event);
            }
        }

        for (int i = 0; existField(i); i++) {
            if (isField(i) && isTableField(i)) {
                String groupName = getTableGroupe(i);
                if (!form.hasTalble(groupName)) {
                    int prefixSize = _setting
                            .getTableClassNamePrefixSizeByGuiId();
                    form.addTable(new FormTable(getGuiId(), nameSpace,
                            groupName, prefixSize));
                }
                FormTable table = form.getTable(groupName);
                table.addField(collectField(i));
            } else if (isField(i)) {
                form.addField(collectField(i));
            }
        }
        return form;
    }

    private boolean isEventField(int index) {
        return getFieldValue(10, index).equals("");
    }

    private int getFieldIndex(int index) {
        return 20 + index;
    }

    private String getCellValue(int column, int row) {
        return getSheet().getCell(column, _setting.getBaseRow() + row)
                .getContents();
    }

    private String getFieldValue(int column, int index) {
        return getCellValue(column, getFieldIndex(index));
    }

    private String getTableGroupe(int index) {
        return getFieldValue(8, index);
    }

    private boolean isTableField(int index) {
        return !getTableGroupe(index).equals("");
    }

    private String getFieldUiType(int index) {
        return getFieldValue(3, index);
    }

    private String getFieldDiscription(int index) {
        return getFieldValue(2, index);
    }

    private boolean isDropdownList(int index) {
        boolean result = false;
        String type = getFieldUiType(index);
        if (type.equals("DropdownList")) {
            result = true;
        }
        return result;
    }

    private String[] getFieldEvents(int index) {
        String events = getFieldValue(11, index).trim();
        if (events.equals("")) {
            return new String[0];
        }
        return events.replaceAll("[\\x20]", "").split("[ ,\\.]");
    }

    private boolean isField(int index) {
        return !getFieldName(index).equals("")
                && !getFieldType(index).equals("");
    }
}
