/*
 * blancoIg
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.web.struts.collector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jxl.Workbook;
import jxl.read.biff.BiffException;
import blanco.web.struts.definition.StrutsDefinition;
import blanco.web.struts.generator.StrutsSetting;

/**
 * @author Yasuo Nakanishi
 */
public class ExcelFormCollector {
    private String _fileDirectory = ".";

    private List _pathList = new ArrayList();

    private StrutsDefinition _result = null;

    private StrutsSetting _setting = null;

    public ExcelFormCollector(StrutsSetting setting) {
        _setting = setting;
    }

    public ExcelFormCollector(String fileDirectory) {
        _fileDirectory = fileDirectory;
    }

    public void addFormFile(String filePath) {
        _pathList.add(filePath);
    }

    public StrutsDefinition collect() throws Exception {
        _result = new StrutsDefinition();

        Iterator i = _pathList.iterator();
        while (i.hasNext()) {
            collectFromBook((String) i.next());
        }
        assert _result.getFormIterator() != null;
        return _result;
    }

    private void collectFromBook(String path) throws BiffException, IOException {
        Workbook w = Workbook.getWorkbook(new File(path));
        ExcelSheetIterator i = new ExcelSheetIterator(w, _setting);

        while (i.next()) {
            if (!i.isConfigurationFile()) {
                _result.addForm(i.collectFrom());
            }
        }
    }
}
