/*
 * This code is generated by blanco Framework.
 */
package blancostruts.runtime.validator;

import java.io.UnsupportedEncodingException;

import org.apache.struts.action.ActionError;

import blancostruts.runtime.validator.message.MessageKeyLoader;
import blancostruts.runtime.validator.message.MessageKeys;

/**
 * @author Yasuo Nakanishi
 */
public abstract class AbstractFormValidator implements FormValidator {
    private ActionError _error = null;
    private MessageKeys _messageKeys = null;

    protected MessageKeys getMessageKeys() {
        if(_messageKeys == null) {
            MessageKeyLoader _loader = new MessageKeyLoader(); 
            _messageKeys = _loader.load();
        }
        return _messageKeys;
    }
    
    public boolean isEmpty(Object value) {
        return value == null || value.equals("");
    }

    public boolean validateRequired(Object value, String name) {
        boolean result = !isEmpty(value);
        if(!result) {
            String key = getMessageKeys().getRequiredErrorKey();
            Object[] parameters = new Object[]{value, name};
            setError(key, parameters);
        }
        return result;
    }

    public boolean validateIntRange(int value, String min, String max, String name) {
        boolean result = false;
        
        int minRange = Integer.MIN_VALUE;
        int maxRange = Integer.MAX_VALUE;

        if(!min.equals("")) {
            minRange = Integer.parseInt(min);
        }
        if(!max.equals("")) {
            maxRange = Integer.parseInt(max);
        }

        if(value >= minRange && value <= maxRange) {
            result = true;
        } else {
            String key = getMessageKeys().getRangeErrorKey();
            Object[] parameters = new Object[]{new Integer(value), min, max, name};
            setError(key, parameters);
        }
        
        return result;
    }

    public boolean validateStringSizeByBytes(String value, String min, String max, String name) {
        boolean result = false;

        int minSize = Integer.MIN_VALUE;
        int maxSize = Integer.MAX_VALUE;
        
        if(!min.equals("")) {
            minSize = Integer.parseInt(min);
        }
        if(!max.equals("")) {
            maxSize = Integer.parseInt(max);
        }

        int size = 0;
        try {
            if(value != null) {
                size = value.getBytes("Windows-31J").length;
            }
        } catch (UnsupportedEncodingException e) {
            String message = "String̃fR[hɎsB";
            RuntimeException re = new RuntimeException(message, e);
            throw re;
        }

        if(isEmpty(value)) {
            result = true; 
        } else if(size >= minSize && size <= maxSize) {
            result = true;
        } else {
            String key = getMessageKeys().getSizeErrorKey();
            Object[] parameters = new Object[]{value, min, max, name};
            setError(key, parameters);
        }
        
        return result;
    }

    public boolean validateStringSizeByLength(String value, String min, String max, String name) {
        boolean result = false;

        int minSize = Integer.MIN_VALUE;
        int maxSize = Integer.MAX_VALUE;
        
        if(!min.equals("")) {
            minSize = Integer.parseInt(min);
        }
        if(!max.equals("")) {
            maxSize = Integer.parseInt(max);
        }

        int size = 0;
        if(value != null) {
            size = value.length();
        }

        if(isEmpty(value)) {
            result = true;
        } else if(size >= minSize && size <= maxSize) {
            result = true;
        } else {
            String key = getMessageKeys().getSizeErrorKey();
            Object[] parameters = new Object[]{value, min, max, name};
            setError(key, parameters);
        }
        
        return result;
    }
    protected void setError(String key, Object[] parameters) {
        _error = new ActionError(key, parameters);
    }
    
    public ActionError getError() {
        return _error;
    }

    public boolean validateRegex(String value, String regex, String key, String name) {
        boolean result = false;
        
        if(isEmpty(value)) {
            result = true; 
        } else if(value.matches(regex)) {
            result = true;
        } else {
            String messageKey = "";
            if(key.equals("")) {
                messageKey = getMessageKeys().getRegexErrorKey();
            } else {
                messageKey = key;
            }
            Object[] parameters = new Object[]{value, regex, name};
            setError(messageKey, parameters);
        }
        return result;
    }
}
