/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.write.biff.DataValidityListRecord;
import jxl.write.biff.DataValiditySettingsRecord;
import jxl.write.biff.File;
import jxl.write.biff.WritableWorkbookImpl;

public class DataValidation {
    private static final Logger logger = Logger.getLogger(DataValidation.class);
    private DataValidityListRecord validityList;
    private ArrayList validitySettings;
    private int pos;
    private WritableWorkbookImpl workbook;
    private WorkbookSettings workbookSettings;

    DataValidation(jxl.read.biff.DataValidation dv, WritableWorkbookImpl w, WorkbookSettings ws) {
        this.workbook = w;
        this.workbookSettings = ws;
        this.validityList = new DataValidityListRecord(dv.getDataValidityList());
        jxl.read.biff.DataValiditySettingsRecord[] settings = dv.getDataValiditySettings();
        this.validitySettings = new ArrayList(settings.length);
        for (int i = 0; i < settings.length; ++i) {
            this.validitySettings.add(new DataValiditySettingsRecord(settings[i], this.workbook, this.workbookSettings));
        }
    }

    DataValidation(DataValidation dv, WritableWorkbookImpl w, WorkbookSettings ws) {
        this.workbook = w;
        this.workbookSettings = ws;
        this.validityList = new DataValidityListRecord(dv.validityList);
        this.validitySettings = new ArrayList(dv.validitySettings.size());
        Iterator i = dv.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dvsr = (DataValiditySettingsRecord)i.next();
            this.validitySettings.add(new DataValiditySettingsRecord(dvsr, this.workbook, this.workbookSettings));
        }
    }

    public void write(File outputFile) throws IOException {
        if (!this.validityList.hasDVRecords()) {
            return;
        }
        outputFile.write(this.validityList);
        Iterator i = this.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i.next();
            outputFile.write(dv);
        }
    }

    public void insertRow(int row) {
        Iterator i = this.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i.next();
            dv.insertRow(row);
        }
    }

    public void removeRow(int row) {
        Iterator i = this.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i.next();
            if (dv.getFirstRow() == row && dv.getLastRow() == row) {
                i.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dv.removeRow(row);
        }
    }

    public void insertColumn(int col) {
        Iterator i = this.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i.next();
            dv.insertColumn(col);
        }
    }

    public void removeColumn(int col) {
        Iterator i = this.validitySettings.iterator();
        while (i.hasNext()) {
            DataValiditySettingsRecord dv = (DataValiditySettingsRecord)i.next();
            if (dv.getFirstColumn() == col && dv.getLastColumn() == col) {
                i.remove();
                this.validityList.dvRemoved();
                continue;
            }
            dv.removeColumn(col);
        }
    }
}

