/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.biff.drawing.Comment;
import jxl.write.biff.CellValue;

public class BaseCellFeatures {
    public static Logger logger = Logger.getLogger(BaseCellFeatures.class);
    private String comment;
    private double commentWidth;
    private double commentHeight;
    private Comment commentDrawing;
    private CellValue writableCell;
    private static final double defaultCommentWidth = 3.0;
    private static final double defaultCommentHeight = 4.0;

    protected BaseCellFeatures() {
    }

    public BaseCellFeatures(BaseCellFeatures cf) {
        this.comment = cf.comment;
        this.commentWidth = cf.commentWidth;
        this.commentHeight = cf.commentHeight;
    }

    protected String getComment() {
        return this.comment;
    }

    public double getCommentWidth() {
        return this.commentWidth;
    }

    public double getCommentHeight() {
        return this.commentHeight;
    }

    public final void setWritableCell(CellValue wc) {
        this.writableCell = wc;
    }

    public void setReadComment(String s, double w, double h) {
        this.comment = s;
        this.commentWidth = w;
        this.commentHeight = h;
    }

    public void setComment(String s) {
        this.setComment(s, 3.0, 4.0);
    }

    public void setComment(String s, double width, double height) {
        this.comment = s;
        this.commentWidth = width;
        this.commentHeight = height;
        if (this.commentDrawing != null) {
            this.commentDrawing.setCommentText(s);
            this.commentDrawing.setWidth(width);
            this.commentDrawing.setWidth(height);
        }
    }

    public final void setCommentDrawing(Comment c) {
        this.commentDrawing = c;
    }

    public final Comment getCommentDrawing() {
        return this.commentDrawing;
    }
}

