/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgSourceFile\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgSourceFileJsSourceExpander {
    /**
     * w肪ꍇ̃ftHg̃t@CRgB
     */
    private static final String DEFAULT_FILE_COMMENT = "̃\[XR[h blanco Frameworkɂ莩܂B";

    /**
     * ͂ƂȂ\[XR[h\B
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * ԓIɗp\[XR[h킷ListBjava.lang.StringXgɊi[܂B(BlancoCgLineł͂܂B
     * )
     * 
     * ł͐`O\[XR[hԓIɂ킦܂B
     */
    private List<java.lang.String> fSourceLines = null;

    /**
     * SourceFile琮`O\[XR[hXg𐶐܂B
     * 
     * @param argSourceFile
     *            \[XR[h킷o[IuWFNgB
     * @return \[XR[hɓWJ̃XgB
     */
    public List<java.lang.String> transformSourceFile(
            final BlancoCgSourceFile argSourceFile) {
        // mɃ\[Xs̃Xg܂B
        fSourceLines = new ArrayList<java.lang.String>();

        fCgSourceFile = argSourceFile;

        // \[Xt@C̃t@Cwb_[o͏܂B
        expandSourceFileHeader();

        // pbP[W̐B
        if (BlancoStringUtil.null2Blank(fCgSourceFile.getPackage()).length() > 0) {
            // fSourceLines.add("/* package " + fCgSourceFile.getPackage()
            // + "; */");
            // fSourceLines.add("");
        }

        if (fCgSourceFile.getImportList() == null) {
            throw new IllegalArgumentException("import̃Xgnull^܂B");
        }

        // ̌㔼ŃC|[gҐȂ܂A̍ۂɎQƂAJ[ǉĂ܂B
        BlancoCgImportJsSourceExpander.insertAnchorString(fSourceLines);

        // C^tF[X̓WJ JavaScriptɂ݂͑܂B
        if (fCgSourceFile.getInterfaceList().size() > 0) {
            throw new IllegalArgumentException("JavaScriptɂ̓C^tF[X݂͑܂B");
        }

        // NX̓WJ{܂B
        if (fCgSourceFile.getClassList() == null) {
            throw new IllegalArgumentException("NX̃Xgnull^܂B");
        }
        for (int index = 0; index < fCgSourceFile.getClassList().size(); index++) {
            final BlancoCgClass cgClass = fCgSourceFile.getClassList().get(
                    index);

            // t@CNXւƈڑ܂B
            String fileDescription = fCgSourceFile.getDescription();
            if (BlancoStringUtil.null2Blank(fileDescription).length() == 0) {
                fileDescription = DEFAULT_FILE_COMMENT;
            }
            cgClass.getLangDoc().getTagList().add(
                    BlancoCgObjectFactory.getInstance().createLangDocTag(
                            "fileoverview", null, fileDescription));
            // |CgFł̓t@Cwb_[݈̂ڑĂ܂BDescriptionȊO͈ڑ̕Kv͂܂B

            new BlancoCgClassJsSourceExpander().transformClass(cgClass,
                    fCgSourceFile, fSourceLines);
        }

        // import̓WJ܂B
        // ̏ANXWJɎ{Ă̂ɂ͈Ӗ܂B
        // NXWJȂǂoāA߂ăC|[g̈ꗗm肷邩łB
        new BlancoCgImportJsSourceExpander().transformImport(fCgSourceFile,
                fSourceLines);

        return fSourceLines;
    }

    /**
     * \[Xt@C̃t@Cwb_[o͏܂B
     */
    private void expandSourceFileHeader() {
        fSourceLines.add("/*");
        if (BlancoStringUtil.null2Blank(fCgSourceFile.getDescription())
                .length() > 0) {
            fSourceLines.add("* " + fCgSourceFile.getDescription());
        } else {
            // w肪ꍇɂ̓ftHg̃Rg𗘗p܂B
            fSourceLines.add("* " + DEFAULT_FILE_COMMENT);
        }

        // hLg̒ԕ𐶐܂B
        new BlancoCgLangDocJsSourceExpander().transformLangDocBody(
                fCgSourceFile.getLangDoc(), fSourceLines);

        fSourceLines.add("*/");
    }
}
