/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.cs;

import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgField\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgFieldCsSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.CS;

    /**
     * ŃtB[hWJ܂B
     * 
     * @param cgField
     *            ΏۂƂȂtB[hB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     * @param argIsInterface
     *            C^tF[XǂBNX̏ꍇɂfalseBC^tF[X̏ꍇɂtrueB
     */
    public void transformField(final BlancoCgField cgField,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines,
            final boolean argIsInterface) {
        if (BlancoStringUtil.null2Blank(cgField.getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (BlancoStringUtil.null2Blank(cgField.getType().getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h[" + cgField.getName()
                    + "]̌^K؂Ȓlݒ肳Ă܂B");
        }

        // L킳st^܂B
        argSourceLines.add("");

        // ŏɃtB[hLangDocɓWJB
        if (cgField.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgField.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgField.getLangDoc().getTitle() == null) {
            cgField.getLangDoc().setTitle(cgField.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocCsSourceExpander().transformLangDoc(cgField
                .getLangDoc(), argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgField.getAccess()).length() > 0) {
            if (argIsInterface && cgField.getAccess().equals("public")) {
                // C^tF[Xpublic̏ꍇɂ͏o͂}܂B
                // Checkstyle΍ƂȂ܂B
            } else {
                buf.append(cgField.getAccess() + " ");
            }
        }
        if (cgField.getStatic()) {
            buf.append("static ");
        }
        if (cgField.getFinal()) {
            // tB[hւfinalC readonly ƕ\悤ɋ@\B
            // constł͂ȂƂɃ}bsOB
            buf.append("readonly ");
        }

        // importɌ^ǉB
        argSourceFile.getImportList().add(cgField.getType().getName());

        // tB[h̖{̕WJ܂B
        buf.append(BlancoCgTypeCsSourceExpander.toTypeString(cgField.getType())
                + " ");
        buf.append(cgField.getName());

        // ftHgl̎w肪ꍇɂ͂WJ܂B
        if (BlancoStringUtil.null2Blank(cgField.getDefault()).length() > 0) {
            buf.append(" = " + cgField.getDefault());
        }
        buf.append(BlancoCgLineUtil.getTerminator(TARGET_LANG));
        argSourceLines.add(buf.toString());
    }
}
