/*
 * blancoCommons Copyright (C) 2005 Yoshinori WATANABE
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.sql.format;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B <br>
 * SQLƂĐƂOłB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html <br>
 * [eBeBł.
 * 
 * @author Yoshinori WATANABE (a-san) : original version at 2005.07.04.
 * @author Tosiki Iga : marge into blanc Framework at 2005.07.04
 */
public class BlancoSqlUtil {
    // /**
    // * 擪啶Bȍ~͏ɂ.
    // * "ABCdef" -> "Abcdef"
    // */
    // public static String toCapitalUpperCase(String str) {
    // return "" + Character.toUpperCase(str.charAt(0)) + str.substring(1);
    // }

    /**
     * u. ꕶɕ̕ϊΏۂĂ悢B
     * 
     * @param str
     *            ΏۂƂȂ镶
     * @param src
     *            ϊO(ex." <")
     * @param dst
     *            ϊ(ex."&lt;")
     * @return uꂽ
     */
    public static String replace(String str, String src, String dst) {
        String newStr = "";
        int lastpos = 0;
        for (;;) {
            int pos = str.indexOf(src, lastpos);
            if (pos == -1)
                break;
            newStr += str.substring(lastpos, pos);
            newStr += dst;
            lastpos = pos + src.length();
        }
        return newStr + str.substring(lastpos);
    }

}
