/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.xsd.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import blanco.commons.io.File2StreamWrapper;
import blanco.commons.util.BlancoNameUtil;
import blanco.xsd.BlancoXsdTypeMapping;
import blanco.xsd.concretesax.BlancoXsdHandler;

/**
 * blancoWsdl: XSDp[X邾̂̂łB<br>
 * ̃vO blancoWsdlxsdt@CǂݍނƂł܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdParser {
    private static final boolean IS_DEBUG = false;

    /**
     * ̉ߒŒm蓾SĂ̌^
     */
    private final LinkedHashMap fAllKnownTypesHashMap = new LinkedHashMap();

    public static void main(String[] args) {
        try {
            new BlancoXsdParser().process(new File(
                    "./tmp/telegram/wsdl/TAAA0001Input.xsd"), "TAAA0001Input");
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("SĂ̏");
    }

    /**
     * ̉ߒŒm蓾SĂ̌^߂܂B
     * 
     * @return
     */
    public LinkedHashMap getAllKnownTypes() {
        return fAllKnownTypesHashMap;
    }

    /**
     * XSDt@Cp[X܂B
     * 
     * @param rootNodeName
     * @param targetName
     * @param fileSource
     * @return
     * @throws Exception
     */
    public ComplexTypeStructure process(final File fileSource,
            final String targetName) throws Exception {
        final BlancoXsdParser parser = this;
        final ComplexTypeStructure[] result = new ComplexTypeStructure[1];
        new File2StreamWrapper(fileSource, null) {
            protected void process(InputStream inStream,
                    OutputStream outStreamIgnore) throws IOException,
                    TransformerException, SAXException {
                result[0] = parser.process(inStream, targetName);
            }
        }.run();
        return result[0];
    }

    /**
     * XSDt@C̃Xg[p[X܂B
     * 
     * @param rootNodeName
     * @param targetName
     * @param fileSource
     * @return
     * @throws IOException
     * @throws TransformerException
     * @throws SAXException
     */
    public ComplexTypeStructure process(final InputStream inStream,
            final String targetName) throws IOException, TransformerException,
            SAXException {
        if (targetName == null) {
            throw new IllegalArgumentException(
                    "xsdt@C̏ɂāA^[QbgƂȂ^null^܂B");
        }

        SAXResult result = new SAXResult();
        result.setHandler(new BlancoXsdHandler() {
            private boolean isInComplexType = false;

            private String targetNamespace = null;

            private SimpleTypeStructure simpleTypeStructure;

            private ComplexTypeStructure complexTypeStructure;

            public void startDocument() throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void startElementXsdSchema(String uri, String localName,
                    String qName, String attrXmlnsXsd, String attrXmlnsTns,
                    String attrTargetNamespace, String attrElementFormDefault)
                    throws SAXException {
                targetNamespace = attrTargetNamespace;

            }

            public void endElementXsdSchema(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSchema(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSchema(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSimpleType(String uri, String localName,
                    String qName, String attrName) throws SAXException {
                simpleTypeStructure = new SimpleTypeStructure();
                simpleTypeStructure.setName(attrName);
                simpleTypeStructure.setTargetNamespace(targetNamespace);
            }

            public void endElementXsdSimpleType(String uri, String localName,
                    String qName) throws SAXException {
                if (IS_DEBUG) {
                    System.out.println("Vv^[" + "tns:"
                            + simpleTypeStructure.getName() + "]o^");
                }
                fAllKnownTypesHashMap.put("tns:"
                        + simpleTypeStructure.getName(), simpleTypeStructure);
            }

            public void charactersXsdSimpleType(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSimpleType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdRestriction(String uri,
                    String localName, String qName, String attrBase)
                    throws SAXException {
                // restriction SimpleTypê݂ŗLƑz肵܂B
                simpleTypeStructure.setTypeOfNamespace(attrBase);

                final Object objFind = fAllKnownTypesHashMap.get(attrBase);
                if (objFind instanceof SimpleTypeStructure) {
                    SimpleTypeStructure look = (SimpleTypeStructure) objFind;
                    simpleTypeStructure.setBaseRestriction(look);
                    simpleTypeStructure.setTypeOfJava(look.getTypeOfJava());
                } else {
                    // łȂxsd̊{^ł͂łB
                    String typeFind = BlancoXsdTypeMapping.xsdType2JavaType(
                            attrBase, "1");
                    if (typeFind == null) {
                        throw new IllegalArgumentException("͂܂B");
                    }
                    simpleTypeStructure.setTypeOfJava(typeFind);
                }
            }

            public void endElementXsdRestriction(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdRestriction(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setMinLength(attrValue);
                }
            }

            public void endElementXsdMinLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMinLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMaxLength(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setMaxLength(attrValue);
                }
            }

            public void endElementXsdMaxLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdPattern(String uri, String localName,
                    String qName, String attrValue) throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setPattern(attrValue);
                }
            }

            public void endElementXsdPattern(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdPattern(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdPattern(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdMinInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setMinInclusive(attrValue);
                }
            }

            public void endElementXsdMinInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMinInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMinInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdMaxInclusive(String uri,
                    String localName, String qName, String attrValue)
                    throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setMaxInclusive(attrValue);
                }
            }

            public void endElementXsdMaxInclusive(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdMaxInclusive(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdMaxInclusive(char[] ch,
                    int start, int length) throws SAXException {
            }

            public void startElementXsdLength(String uri, String localName,
                    String qName, String attrValue, String attrFixed)
                    throws SAXException {
                if (isInComplexType) {
                } else {
                    simpleTypeStructure.setMinLength(attrValue);
                    simpleTypeStructure.setMaxLength(attrValue);
                }
            }

            public void endElementXsdLength(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdLength(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdLength(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdComplexType(String uri,
                    String localName, String qName, String attrName)
                    throws SAXException {
                isInComplexType = true;

                complexTypeStructure = new ComplexTypeStructure();
                complexTypeStructure.setName(attrName);
                complexTypeStructure.setTypeOfNamespace("tns:"
                        + complexTypeStructure.getName());
                complexTypeStructure.setTargetNamespace(targetNamespace);
                complexTypeStructure.setTypeOfJava(BlancoNameUtil
                        .uri2JavaPackage(targetNamespace)
                        + "." + attrName);
                complexTypeStructure.setPackageOfJava(BlancoNameUtil
                        .uri2JavaPackage(targetNamespace));
            }

            public void endElementXsdComplexType(String uri, String localName,
                    String qName) throws SAXException {
                isInComplexType = false;

                if (IS_DEBUG) {
                    System.out.println("RvbNX^[" + "tns:"
                            + complexTypeStructure.getName() + "]o^");
                }
                fAllKnownTypesHashMap.put("tns:"
                        + complexTypeStructure.getName(), complexTypeStructure);
            }

            public void charactersXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void ignorableWhitespaceXsdComplexType(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void endElementXsdSequence(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdSequence(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdSequence(char[] ch, int start,
                    int length) throws SAXException {
            }

            public void startElementXsdElement(String uri,
                    final String localName, String qName, String attrName,
                    String attrType, String attrMinOccurs, String attrMaxOccurs)
                    throws SAXException {
                String type = BlancoXsdTypeMapping.xsdType2JavaType(attrType,
                        attrMinOccurs);
                if (type != null) {
                    // PJavǎ^Ƀ}bsOł܂B
                    JavaTypeStructure javaTypeStructure = new JavaTypeStructure();
                    javaTypeStructure.setName(attrName);
                    javaTypeStructure.setTypeOfJava(type);
                    // OԂ̓Zbg܂B
                    javaTypeStructure.setTypeOfNamespace(attrType);
                    if (isInComplexType) {
                        complexTypeStructure.getListField().add(
                                new ComplexTypeFieldStructure(
                                        javaTypeStructure, attrName,
                                        attrMinOccurs, attrMaxOccurs));
                    } else {
                        throw new IllegalArgumentException(
                                "z肵ȂG[:xsd[tns:"
                                        + targetName
                                        + "]ɂĕ^ł͂ȂӏelementJn܂BsK؂ȌoHʉ߂܂B");
                    }
                } else {
                    Object objFind = fAllKnownTypesHashMap.get(attrType);
                    if (objFind == null) {
                        throw new IllegalArgumentException(
                                "֊֌WG[: xsd[tns:"
                                        + targetName
                                        + "]ɂČ^["
                                        + attrType
                                        + "]ł܂BuKw`vsĂuږvƁudKwvƂK؂Ɋ֘AtĂ邩ǂmFĂB");
                    }
                    // ComplexTypełB
                    if (isInComplexType) {
                        complexTypeStructure
                                .getListField()
                                .add(
                                        new ComplexTypeFieldStructure(
                                                (AbstractTypeStructure) objFind,
                                                attrName, attrMinOccurs,
                                                attrMaxOccurs));
                    } else {
                        if (IS_DEBUG) {
                            System.out
                                    .println("xsd[tns:"
                                            + targetName
                                            + "]ɂĕ^ł͂ȂӏelementJn܂B̐錾ƍl܂B̃Gg͖܂B");
                        }
                    }
                }
            }

            public void endElementXsdElement(String uri, String localName,
                    String qName) throws SAXException {
            }

            public void charactersXsdElement(char[] ch, int start, int length)
                    throws SAXException {
            }

            public void ignorableWhitespaceXsdElement(char[] ch, int start,
                    int length) throws SAXException {
            }
        });
        final TransformerFactory tf = TransformerFactory.newInstance();
        final Transformer transformer = tf.newTransformer();
        transformer.transform(new StreamSource(inStream), result);

        final Object objTarget = fAllKnownTypesHashMap.get("tns:" + targetName);
        if (objTarget == null) {
            throw new IllegalArgumentException("xsd[tns:" + targetName
                    + "]܂łB");
        }
        if (objTarget instanceof SimpleTypeStructure) {
            throw new IllegalArgumentException("xsd[tns:" + targetName
                    + "]̓Vv^ƂĒ`Ă܂B");
        }
        if (objTarget instanceof ComplexTypeStructure) {
            return (ComplexTypeStructure) objTarget;
        } else {
            throw new IllegalArgumentException("z肵ȂG[:xsd[tns:"
                    + targetName + "]sK؂Ȍ^(" + objTarget.getClass().getName()
                    + ")ƂĒ`Ă܂B");
        }
    }
}