package blanco.xsd;

import blanco.commons.util.BlancoNameAdjuster;

public class BlancoXsdUtil {
    public static final String MAX_OCCURS_UNBOUNDED = "unbounded";

    /**
     * ^ꂽminOccursl intɕϊ܂B
     * 
     * @param minOccurs
     * @return ͌̐l߂܂B
     * @throws NumberFormatException
     *             lŖl^ꂽꍇɔ܂B
     * @throws IllegalArgumentException
     *             0菬l^ꂽꍇɔ܂B
     */
    public static final int minOccurs2Int(final String minOccurs) {
        if (minOccurs == null) {
            return 1;
        }
        if (minOccurs.length() == 0) {
            return 1;
        }
        int retValue = Integer.parseInt(minOccurs);
        if (retValue < 0) {
            throw new IllegalArgumentException("minOccursɒl[" + minOccurs
                    + "]^܂AminOccurs0ȏ̒lłȂĂ͂Ȃ܂B");
        }
        return retValue;
    }

    /**
     * ^ꂽmaxOccursl intɕϊ܂B
     * 
     * @param maxOccurs
     * @return ͌̐l߂܂Bunboundedunbounded̏ꍇɂInteger.MAX_VALUE߂܂B
     * @throws NumberFormatException
     *             lłunboundedłl^ꂽꍇɔ܂B
     * @throws IllegalArgumentException
     *             0菬l^ꂽꍇɔ܂B
     */
    public static final int maxOccurs2Int(final String maxOccurs) {
        if (maxOccurs == null) {
            return 1;
        }
        if (maxOccurs.length() == 0) {
            return 1;
        }
        if (maxOccurs.equals(MAX_OCCURS_UNBOUNDED)) {
            // \݂̂ƂāAint̍ől߂܂B
            return Integer.MAX_VALUE;
        }
        final int retValue = Integer.parseInt(maxOccurs);
        if (retValue < 0) {
            throw new IllegalArgumentException("maxOccursɒl[" + maxOccurs
                    + "]^܂AmaxOccurs0ȏ̒lłȂĂ͂Ȃ܂B");
        }
        return retValue;
    }

    /**
     * ^ꂽminLengthłƂĐl܂Bnull""̏ꍇ 0 Ɣ肵܂B
     * 
     * @param minLength
     * @return
     * @throws NumberFormatException
     *             lŖl^ꂽꍇɔ܂B
     * @throws IllegalArgumentException
     *             0菬l^ꂽꍇɔ܂B
     */
    public static final int minLength2Int(final String minLength) {
        if (minLength == null) {
            return 0;
        }
        if (minLength.length() == 0) {
            return 0;
        }
        final int retValue = Integer.parseInt(minLength);
        if (retValue < 0) {
            throw new IllegalArgumentException("minLengthɒl[" + minLength
                    + "]^܂AminLength0ȏ̒lłȂĂ͂Ȃ܂B");
        }
        return retValue;
    }

    /**
     * ^ꂽmaxLengthłƂĐl܂Bnull""̏ꍇ Integer.MAX_VALUE Ɣ肵܂B
     * 
     * @param maxLength
     * @return
     * @throws NumberFormatException
     *             lŖl^ꂽꍇɔ܂B
     * @throws IllegalArgumentException
     *             0菬l^ꂽꍇɔ܂B
     */
    public static final int maxLength2Int(final String maxLength) {
        if (maxLength == null) {
            return Integer.MAX_VALUE;
        }
        if (maxLength.length() == 0) {
            return Integer.MAX_VALUE;
        }
        final int retValue = Integer.parseInt(maxLength);
        if (retValue < 0) {
            throw new IllegalArgumentException("maxLengthɒl[" + maxLength
                    + "]^܂AmaxLength0ȏ̒lłȂĂ͂Ȃ܂B");
        }
        return retValue;
    }

    /**
     * ͂ꂽl maxOccursłƔfAz\^ł邩ǂ`FbN܂B
     * 
     * @param maxOccurs
     * @return
     * @throws NumberFormatException
     *             lłunboundedłl^ꂽꍇɔ܂B
     * @throws IllegalArgumentException
     *             0菬l^ꂽꍇɔ܂B
     */
    public static final boolean isMaxOccursArray(final String maxOccurs) {
        if (maxOccurs2Int(maxOccurs) > 1) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * ^ꂽdIDƃpXƂɕ^̖̂擾܂B
     * 
     * @param telegramId
     * @param targetFieldPath
     * @return
     */
    public static final String getComplexTypeName(final String telegramId,
            final String fullPath) {
        return telegramId
                + (fullPath == null || fullPath.length() == 0 ? ""
                        : BlancoNameAdjuster.toClassName(fullPath));
    }
}