/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.concretesax.BlancoWsdlXml2WsdlOutputSerializer;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeStructure;

/**
 * blancoWsdl: XMLWSDL쐬܂B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Wsdl {
    private final ArrayList listWsdl = new ArrayList();

    public static void main(String[] args) {
        try {
            final BlancoWsdlXml2Wsdl xml2wsdl = new BlancoWsdlXml2Wsdl();
            xml2wsdl.parse(new File("./tmp/telegram/aaa.xml"), new File(
                    "tmp/telegram/wsdl"));
            xml2wsdl.generate(new File("tmp/telegram/wsdl"));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class WsdlStructure {
        public String webServiceId;// SampleWS

        public String location;// http://localhost:8080/axis/services/SampleWS

        public String telegramProcessNamespace;// http://noname.org/NoService

        /**
         * WsdlOperationStructure i[܂B
         */
        public final ArrayList listOperation = new ArrayList();
    }

    class WsdlOperationStructure {
        public String telegramProcessId;// TAAA0001

        public String telegramRequestId;// TAAA0001Input

        public String telegramResponseId;// TAAA0001Output

        public String xsdNamespace;
    }

    public void generate(final File targetDirectory) throws SAXException,
            TransformerConfigurationException, IOException {
        // WSDL̐ ۂWSDLt@C𐶐܂B
        for (int indexWsdl = 0; indexWsdl < listWsdl.size(); indexWsdl++) {
            final WsdlStructure wsdl = (WsdlStructure) listWsdl.get(indexWsdl);
            final OutputStream outStream = new BufferedOutputStream(
                    new FileOutputStream(targetDirectory.getAbsolutePath()
                            + "/" + wsdl.webServiceId + "WebService.wsdl"));
            try {
                BlancoWsdlXml2WsdlOutputSerializer serializer = new BlancoWsdlXml2WsdlOutputSerializer(
                        outStream);
                serializer.startDocument();
                {
                    // startElementWsdlDefinitions蓮ŏo͂܂B
                    final AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "tns", "xmlns:tns", "CDATA",
                            wsdl.telegramProcessNamespace);
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "wsdl", "xmlns:wsdl", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "xsd", "xmlns:xsd", "CDATA",
                            "http://www.w3.org/2001/XMLSchema");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "http", "xmlns:http", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/http/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "soap", "xmlns:soap", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/soap/");
                    attributes.addAttribute("http://www.w3.org/2000/xmlns/",
                            "mime", "xmlns:mime", "CDATA",
                            "http://schemas.xmlsoap.org/wsdl/mime/");

                    for (int indexOperation = 0; indexOperation < wsdl.listOperation
                            .size(); indexOperation++) {
                        final WsdlOperationStructure wsdlOperation = (WsdlOperationStructure) wsdl.listOperation
                                .get(indexOperation);
                        attributes.addAttribute(
                                "http://www.w3.org/2000/xmlns/", "impl"
                                        + indexOperation, "xmlns:impl"
                                        + indexOperation, "CDATA",
                                wsdlOperation.xsdNamespace);
                    }
                    attributes.addAttribute("", "targetNamespace",
                            "targetNamespace", "CDATA",
                            wsdl.telegramProcessNamespace);
                    serializer.getTransformerHandler().startElement(
                            "http://schemas.xmlsoap.org/wsdl/", "definitions",
                            "wsdl:definitions", attributes);
                }

                serializer.characters("\n  ");
                serializer.startElementWsdlTypes();
                serializer.characters("\n    ");
                serializer.startElementXsdSchema(wsdl.telegramProcessNamespace);

                for (int indexOperation = 0; indexOperation < wsdl.listOperation
                        .size(); indexOperation++) {
                    final WsdlOperationStructure wsdlOperation = (WsdlOperationStructure) wsdl.listOperation
                            .get(indexOperation);
                    serializer.characters("\n      ");
                    serializer
                            .startElementXsdInclude(wsdlOperation.telegramRequestId
                                    + ".xsd");
                    serializer.endElementXsdInclude();
                    serializer.characters("\n      ");
                    serializer
                            .startElementXsdInclude(wsdlOperation.telegramResponseId
                                    + ".xsd");
                    serializer.endElementXsdInclude();
                    serializer.characters("\n      ");
                    serializer.startElementXsdElement(
                            wsdlOperation.telegramRequestId, "impl"
                                    + indexOperation + ":"
                                    + wsdlOperation.telegramRequestId);
                    serializer.endElementXsdElement();
                    serializer.characters("\n      ");
                    serializer.startElementXsdElement(
                            wsdlOperation.telegramResponseId, "impl"
                                    + indexOperation + ":"
                                    + wsdlOperation.telegramResponseId);
                    serializer.endElementXsdElement();
                }

                serializer.characters("\n    ");
                serializer.endElementXsdSchema();
                serializer.characters("\n  ");
                serializer.endElementWsdlTypes();

                for (int indexOperation = 0; indexOperation < wsdl.listOperation
                        .size(); indexOperation++) {
                    final WsdlOperationStructure wsdlOperation = (WsdlOperationStructure) wsdl.listOperation
                            .get(indexOperation);
                    serializer.characters("\n  ");
                    serializer
                            .startElementWsdlMessage(wsdlOperation.telegramRequestId);
                    serializer.characters("\n    ");
                    serializer.startElementWsdlPart("input", "tns:"
                            + wsdlOperation.telegramRequestId);
                    serializer.endElementWsdlPart();
                    serializer.characters("\n  ");
                    serializer.endElementWsdlMessage();
                    serializer.characters("\n  ");
                    serializer
                            .startElementWsdlMessage(wsdlOperation.telegramResponseId);
                    serializer.characters("\n    ");
                    serializer.startElementWsdlPart("output", "tns:"
                            + wsdlOperation.telegramResponseId);
                    serializer.endElementWsdlPart();
                    serializer.characters("\n  ");
                    serializer.endElementWsdlMessage();
                }

                serializer.characters("\n  ");
                serializer.startElementWsdlPortType(wsdl.webServiceId);
                for (int indexOperation = 0; indexOperation < wsdl.listOperation
                        .size(); indexOperation++) {
                    final WsdlOperationStructure wsdlOperation = (WsdlOperationStructure) wsdl.listOperation
                            .get(indexOperation);
                    serializer.characters("\n    ");
                    serializer
                            .startElementWsdlOperation(wsdlOperation.telegramProcessId);
                    serializer.characters("\n      ");
                    serializer.startElementWsdlInput("tns:"
                            + wsdlOperation.telegramRequestId);
                    serializer.endElementWsdlInput();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlOutput("tns:"
                            + wsdlOperation.telegramResponseId);
                    serializer.endElementWsdlOutput();
                    serializer.characters("\n    ");
                    serializer.endElementWsdlOperation();
                }
                serializer.characters("\n  ");
                serializer.endElementWsdlPortType();

                serializer.characters("\n  ");
                serializer.startElementWsdlBinding(wsdl.webServiceId
                        + "Binding", "tns:" + wsdl.webServiceId);
                serializer.characters("\n    ");
                serializer.startElementSoapBinding("document",
                        "http://schemas.xmlsoap.org/soap/http");
                serializer.endElementSoapBinding();

                for (int indexOperation = 0; indexOperation < wsdl.listOperation
                        .size(); indexOperation++) {
                    final WsdlOperationStructure wsdlOperation = (WsdlOperationStructure) wsdl.listOperation
                            .get(indexOperation);
                    serializer.characters("\n    ");
                    serializer
                            .startElementWsdlOperation(wsdlOperation.telegramProcessId);
                    serializer.characters("\n      ");
                    serializer.startElementSoapOperation();
                    serializer.endElementSoapOperation();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlInput(null);
                    serializer.characters("\n        ");
                    serializer.startElementSoapBody("literal");
                    serializer.endElementSoapBody();
                    serializer.characters("\n      ");
                    serializer.endElementWsdlInput();
                    serializer.characters("\n      ");
                    serializer.startElementWsdlOutput(null);
                    serializer.characters("\n        ");
                    serializer.startElementSoapBody("literal");
                    serializer.endElementSoapBody();
                    serializer.characters("\n        ");
                    serializer.endElementWsdlOutput();
                    serializer.characters("\n      ");
                    serializer.endElementWsdlOperation();
                }

                serializer.characters("\n    ");
                serializer.endElementWsdlBinding();
                serializer.characters("\n  ");
                serializer.startElementWsdlService(wsdl.webServiceId
                        + "Service");
                serializer.characters("\n    ");
                serializer.startElementWsdlPort(wsdl.webServiceId, "tns:"
                        + wsdl.webServiceId + "Binding");
                serializer.characters("\n      ");
                serializer.startElementSoapAddress(wsdl.location);
                serializer.endElementSoapAddress();
                serializer.characters("\n    ");
                serializer.endElementWsdlPort();
                serializer.characters("\n  ");
                serializer.endElementWsdlService();
                serializer.characters("\n");
                serializer.endElementWsdlDefinitions();
                serializer.endDocument();
                outStream.flush();
            } finally {
                outStream.close();
            }
        }
    }

    public void parse(final File fileMetaFileXml, final File directoryXsd)
            throws IOException, TransformerException, SAXException {
        final DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileMetaFileXml);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            Document rootDocument = (Document) rootNode;
            NodeList listSheet = rootDocument.getElementsByTagName("sheet");
            int sizeListSheet = listSheet.getLength();

            // ܂uŏ́vd`A
            // EFuT[rXIDȂǂ擾B
            for (int index = 0; index < sizeListSheet; index++) {
                WsdlStructure wsdl = new WsdlStructure();
                final WsdlOperationStructure wsdlOperation = new WsdlOperationStructure();

                final Element elementSheet = (Element) listSheet.item(index);
                // System.out.println("V[g[" + elementSheet.getAttribute("name")
                // + "]");

                NodeList listTelegramProcess = elementSheet
                        .getElementsByTagName("blancotelegramprocess-common");
                if (listTelegramProcess.getLength() == 0) {
                    continue;
                }

                Element elementCommon = (Element) listTelegramProcess.item(0);

                wsdl.webServiceId = BlancoXmlUtil.getTextContent(elementCommon,
                        "webServiceId");
                if (wsdl.webServiceId == null) {
                    // EFuT[rXIDm肵Ȃꍇɂ͗E܂B
                    return;
                }

                wsdl.location = BlancoXmlUtil.getTextContent(elementCommon,
                        "location");
                if (wsdl.location == null) {
                    return;
                }

                wsdlOperation.telegramProcessId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessId");
                if (wsdlOperation.telegramProcessId == null) {
                    System.out.println("telegramProcessId܂B");
                    continue;
                }

                wsdlOperation.telegramRequestId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramRequestId");
                if (wsdlOperation.telegramRequestId == null) {
                    System.out.println("telegramRequestId܂B");
                    continue;
                }

                wsdlOperation.telegramResponseId = BlancoXmlUtil
                        .getTextContent(elementCommon, "telegramResponseId");
                if (wsdlOperation.telegramResponseId == null) {
                    System.out.println("telegramResponseId܂B");
                    continue;
                }

                wsdl.telegramProcessNamespace = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramProcessNamespace");
                if (wsdl.telegramProcessNamespace == null) {
                    System.out.println("telegramProcessNamespace܂B");
                    continue;
                }

                wsdlOperation.xsdNamespace = getNamespaceFromXsd(new File(
                        directoryXsd.getAbsolutePath() + "/"
                                + wsdlOperation.telegramRequestId + ".xsd"),
                        wsdlOperation.telegramRequestId);
                final String xsdNamespaceResponse = getNamespaceFromXsd(
                        new File(directoryXsd.getAbsolutePath() + "/"
                                + wsdlOperation.telegramResponseId + ".xsd"),
                        wsdlOperation.telegramResponseId);
                if (wsdlOperation.xsdNamespace.equals(xsdNamespaceResponse) == false) {
                    throw new IllegalArgumentException("vd["
                            + wsdlOperation.telegramRequestId + "]̖O["
                            + wsdlOperation.xsdNamespace + "]Ɖd["
                            + wsdlOperation.telegramResponseId + "]̖O["
                            + xsdNamespaceResponse + "]ƂvĂ܂B");
                }

                boolean isWsdlExist = false;
                for (int indexWsdl = 0; indexWsdl < listWsdl.size(); indexWsdl++) {
                    final WsdlStructure wsdlLook = (WsdlStructure) listWsdl
                            .get(indexWsdl);
                    if (wsdlLook.webServiceId.equals(wsdl.webServiceId)) {
                        // WSDL̓o^܂B
                        if (wsdlLook.location.equals(wsdl.location) == false) {
                            throw new IllegalArgumentException(
                                    "d` dID["
                                            + wsdlOperation.telegramProcessId
                                            + "] EFuT[rXID["
                                            + wsdl.webServiceId + "]̃P[V["
                                            + wsdl.location
                                            + "] ɓo^Ă郍P[V["
                                            + wsdlLook.location + "]ƈv܂B");
                        }

                        if (wsdlLook.telegramProcessNamespace
                                .equals(wsdl.telegramProcessNamespace) == false) {
                            throw new IllegalArgumentException(
                                    "d` dID["
                                            + wsdlOperation.telegramProcessId
                                            + "] EFuT[rXID["
                                            + wsdl.webServiceId + "]̖O["
                                            + wsdl.telegramProcessNamespace
                                            + "] ɓo^Ă閼O["
                                            + wsdlLook.telegramProcessNamespace
                                            + "]ƈv܂B");
                        }

                        // ̂ŏ㏑s܂B
                        isWsdlExist = true;
                        wsdl = wsdlLook;
                        break;
                    }
                }

                // WSDL OperationWSDL\̂ɒǉ܂B
                wsdl.listOperation.add(wsdlOperation);
                if (isWsdlExist == false) {
                    listWsdl.add(wsdl);
                }
            }
        }
    }

    /**
     * XSD̖OԂ擾܂B<br>
     * ̃\bh́AI BlancoNameUtilĂяoĂ܂B
     * 
     * @param fileXsd
     *            xsdt@C
     * @param targetName
     *            ^[QbgƂȂ閼O
     * @return
     * @throws IOException
     * @throws TransformerException
     */
    private static final String getNamespaceFromXsd(final File fileXsd,
            final String targetName) throws IOException, TransformerException,
            SAXException {
        if (fileXsd.exists() == false) {
            throw new IllegalArgumentException("w̓dID[" + targetName
                    + "]̂߂xsdt@C܂BdID[" + targetName
                    + "]K؂ɒ`Ă邱ƂmFĂB");
        }
        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fileXsd));
        try {
            final BlancoXsdParser parser = new BlancoXsdParser();
            final ComplexTypeStructure type = parser.process(inStream,
                    targetName);
            return type.getTargetNamespace();
        } finally {
            inStream.close();
        }
    }
}