/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.wsdl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.commons.calc.parser.BlancoCalcParser;
import blanco.commons.io.File2StreamWrapper;

/**
 * ^񂩂璆ԃt@CłXML쐬܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlMeta2Xml {
    public static void main(String[] args) {
        new File("tmp/telegram").mkdirs();
        // System.out.println("^񂩂XMLt@C쐬: Jn");

        try {
            new File2StreamWrapper(new File(
                    "./meta/wsdl/template/blancoWsdlTemplate.xls"), new File(
                    "./tmp/telegram/aaa.xml")) {
                protected void process(InputStream inStream,
                        OutputStream outStream) throws Exception {
                    new BlancoWsdlMeta2Xml().process(inStream, outStream);
                    outStream.flush();
                }
            }.run();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Excelt@CXMLt@Cɕϊ܂B<br>
     * `t@C͓IɃpXێĂ܂B
     * 
     * @param fileMetaSource
     * @param fileTarget
     * @throws IOException
     * @throws TransformerException
     */
    public void process(InputStream inStreamMetaSource,
            OutputStream outStreamTarget) throws IOException,
            TransformerException {
        InputStream inStreamDef = null;
        try {
            inStreamDef = new BufferedInputStream(getClass().getClassLoader()
                    .getResourceAsStream("blanco/wsdl/BlancoWsdlMeta2Xml.xml"));
            new BlancoCalcParser().process(inStreamDef, inStreamMetaSource,
                    outStreamTarget);
        } finally {
            if (inStreamDef != null)
                inStreamDef.close();
        }
    }
}