/*
 * blancoSOAP Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.sax;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.xml.transform.sax.SAXResult;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.MethodExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.sax.util.BlancoSaxUtil;

/**
 * ͗pXML͂ċۉSAX𐶐܂B<br>
 * ̃NXł́AConcreteContentHandler𐶐܂B<br>
 * <br>
 * ͂͗pXMLt@ĆAӓIȂ̂܂B_ł ȂIȂ̂ɂȂ܂B<br>
 * 1: ͗pXML̃Agr[gׂ͂Ďw肳ė̂Ɖ肵܂B<br>
 * 2: قȂKwɂēÕGeBeB݂Ȃ̂Ɖ肵܂B<br>
 * 3: implements ContentHandler ł͐t@CɒǋL̕Kv܂B<br>
 * Ql:http://java.sun.com/j2se/1.5.0/ja/docs/ja/api/org/xml/sax/ContentHandler.html<br>
 * TODO: charatersɂāA(1)͂char[]n悤ɖ߂ (2)W̏Ăт킯sׂǂl@B<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoSaxXml2Handler {
    // ͂ĂXMLt@C̊eL܂B

    /**
     * qNameL[ɓoꂵGgׂĂL܂B<br>
     * 2xڂɓoꂵGg𖳎邽߂ɂp܂B
     */
    private final Hashtable totalElementAttsHashtable = new Hashtable();

    /**
     * qNameL[ɃGguri, localName, qNameL܂B
     */
    private final Hashtable totalElementNamesHashtable = new Hashtable();

    /**
     * main\bhIɗp̓t@CB
     */
    static final String MAIN_INPUT_FILENAME = "./meta/sax/blancoSoapBlancoFw.xml";

    /**
     * eXgp̃Gg|Cg
     * 
     * @param args
     */
    public static void main(String[] args) {
        try {
            new BlancoSaxXml2Handler().process(new File(
                    "./meta/sax/blancoSoapBlancoFw.xml"), "blanco",
                    "blanco.plugin.soap.concretesax",
                    "BlancoSoapBlancoFwHandler");
            new BlancoSaxXml2Handler().process(new File(
                    BlancoSaxXml2Handler.MAIN_INPUT_FILENAME), "blanco",
                    "sample", "AaaHandler");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * \[XR[hs܂B
     * 
     * @param sourceFile
     * @param targetDirectory
     * @param packageName
     * @param className
     * @throws IOException
     */
    public void process(final File sourceFile, final String targetDirectory,
            final String packageName, final String className)
            throws IOException {
        // Java\[XR[h𐶐̂߂̐ݒ
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(targetDirectory);
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(getClassExpander(sourceFile, packageName,
                className));
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }

    /**
     * ̃NXWJs܂B
     * 
     * @param sourceFile
     * @param packageName
     * @param className
     * @return
     */
    private ClassExpander getClassExpander(final File sourceFile,
            final String packageName, final String className) {
        return new ClassExpander(new Type(packageName, className)) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                addFileComment(className + "ۉSAXNX<br>");
                getJavaDoc().addLine(className + "ۉSAXNX<br>");
                getJavaDoc().addLine(
                        "̃NX͉͗pXMLt@C͂ƂċۉSAXNXƂĐ܂B<br>");
                getJavaDoc().addLine("̃\[XR[hblancoIgɂ@BIɎĂ܂B<br>");
                getJavaDoc().addLine("T^Iȗp@͉L̂悤ɂȂ܂B<br>");
                getJavaDoc().addLine("<pre>");
                getJavaDoc()
                        .addLine(
                                "TransformerFactory tf = TransformerFactory.newInstance();");
                getJavaDoc().addLine(
                        "Transformer transformer = tf.newTransformer();");
                getJavaDoc().addLine(
                        "transformer.transform(new StreamSource(inStream), new SAXResult(new "
                                + className
                                + "())); // ۂɂ͎NXHandler^܂B");
                getJavaDoc().addLine("</pre>");

                // implements ContentHandler ǉ܂B
                addInterface(new Type("org.xml.sax.ContentHandler"));

                // tB[hϐ錾܂B
                FieldExpander field1 = new FieldExpander(new Type(
                        "java.util.Stack"), "fElementLocalNameStack") {
                };
                field1.setLiteralValue("new Stack()");
                field1.getJavaDoc().addLine("GglocalNamẽX^bNł<br>");
                field1.getJavaDoc().addLine("XML̊Kw\̂localNameL܂B");
                addField(field1);

                // tB[hϐ錾܂B
                FieldExpander field2 = new FieldExpander(new Type(
                        "java.util.Stack"), "fElementUriStack") {
                };
                field2.setLiteralValue("new Stack()");
                field2.getJavaDoc().addLine("GgURĨX^bNł<br>");
                field2.getJavaDoc().addLine("XML̊Kw\̂URIL܂B");
                addField(field2);

                SAXResult result = new SAXResult(new ContentHandler() {
                    public void setDocumentLocator(Locator arg0) {
                    }

                    public void startDocument() throws SAXException {
                    }

                    //  endDocument̏łB

                    public void endDocument() throws SAXException {
                        addMethod(new MethodExpander("startElement") {
                            protected boolean isFinal() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc()
                                        .addLine(
                                                "IWistartElementĂяoꂽ̂ŁAۃ\bhɌĂт킯܂");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("uri", "OURI");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "uri"));
                                getJavaDoc().addParameter("localName", "[J");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "localName"));
                                getJavaDoc().addParameter("qName", "ړt̏C");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "qName"));
                                getJavaDoc()
                                        .addParameter("atts", "Agr[g̃Xg");
                                addArgument(new Value(new Type(
                                        "org.xml.sax.Attributes"), "atts"));
                            }

                            public void implement() {
                                getData()
                                        .addLine(
                                                "if (fElementLocalNameStack.empty() == false) {");
                                getData()
                                        .addLine(
                                                "final String previousElementLocalNameOnStack = (String) fElementLocalNameStack.peek();");
                                getData()
                                        .addLine(
                                                "final String previousElementUriOnStack = (String) fElementUriStack.peek();");
                                Enumeration enumeration = totalElementAttsHashtable
                                        .keys();
                                for (boolean isFirst = true; enumeration
                                        .hasMoreElements(); isFirst = false) {
                                    String keyQName = (String) enumeration
                                            .nextElement();
                                    final String[] names = (String[]) totalElementNamesHashtable
                                            .get(keyQName);

                                    getData()
                                            .addLine(
                                                    (isFirst ? "" : "else ")
                                                            + "if (previousElementUriOnStack.equals(\""
                                                            + names[0]
                                                            + "\") && previousElementLocalNameOnStack.equals(\""
                                                            + names[1]
                                                            + "\")) {");
                                    getData()
                                            .addLine(
                                                    "fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".flush();");
                                    getData()
                                            .addLine(
                                                    "char[] wrk = fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".toCharArray();");
                                    getData()
                                            .addLine(
                                                    "fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".reset();");
                                    getData().addLine("if (wrk.length > 0) {");
                                    getData()
                                            .addLine(
                                                    "characters"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + "(wrk, 0, wrk.length);");
                                    getData().addLine("}");
                                    getData().addLine("");
                                    getData().addLine("}");
                                }
                                getData().addLine("}");

                                getData()
                                        .addLine(
                                                "fElementLocalNameStack.push(localName);");
                                getData()
                                        .addLine("fElementUriStack.push(uri);");

                                enumeration = totalElementAttsHashtable.keys();
                                for (boolean isFirst = true; enumeration
                                        .hasMoreElements(); isFirst = false) {
                                    StringBuffer lineStatement = new StringBuffer();
                                    String keyQName = (String) enumeration
                                            .nextElement();
                                    final String[] names = (String[]) totalElementNamesHashtable
                                            .get(keyQName);

                                    getData()
                                            .addLine(
                                                    (isFirst ? "" : "else ")
                                                            + "if (uri.equals(\""
                                                            + names[0]
                                                            + "\") && localName.equals(\""
                                                            + names[1]
                                                            + "\")) {");

                                    lineStatement.append("startElement"
                                            + BlancoNameAdjuster
                                                    .toClassName(keyQName)
                                            + "(uri, localName, qName");
                                    ArrayList atts = (ArrayList) totalElementAttsHashtable
                                            .get(keyQName);

                                    final int attrLength = atts.size();
                                    for (int index = 0; index < attrLength; index++) {
                                        // System.out.println("attr:"
                                        // + (String) atts.get(index));
                                        if (index == 0) {
                                            lineStatement.append(", ");
                                        } else {
                                            lineStatement.append(", ");
                                        }
                                        String[] attsNames = (String[]) atts
                                                .get(index);
                                        if (isXmlNaturePrefix(attsNames[0])) {
                                            // QNameɂANZXɐ؂ւ܂B
                                            lineStatement
                                                    .append("atts.getValue("
                                                            + "\""
                                                            + attsNames[2]
                                                            + "\")");
                                        } else {
                                            lineStatement
                                                    .append("atts.getValue(\""
                                                            + attsNames[0]
                                                            + "\", \""
                                                            + attsNames[1]
                                                            + "\")");
                                        }
                                    }
                                    lineStatement.append(");");
                                    getData().addLine(lineStatement.toString());

                                    getData().addLine("}");
                                }
                                getData().addLine("else {");
                                getData()
                                        .addLine(
                                                "throw new SAXException(\"XMLُBstartElement: ȂGg OURI[\" + uri + \"], [J[\" + localName + \"]m܂.\");");
                                getData().addLine("}");
                            }
                        });

                        addMethod(new MethodExpander("endElement") {
                            protected boolean isFinal() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc()
                                        .addLine(
                                                "IWiendElementĂяoꂽ̂ŁAۃ\bhɌĂт킯܂");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("uri", "OURI");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "uri"));
                                getJavaDoc().addParameter("localName", "[J");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "localName"));
                                getJavaDoc().addParameter("qName", "ړt̏C");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "qName"));
                            }

                            public void implement() {
                                getData()
                                        .addLine(
                                                "final String currentElementLocalNameOnStack = (String) fElementLocalNameStack.peek();");
                                getData()
                                        .addLine(
                                                "final String currentElementUriOnStack = (String) fElementUriStack.peek();");
                                getData()
                                        .addLine(
                                                "if (currentElementLocalNameOnStack.equals(localName) == false) {");
                                getData()
                                        .addLine(
                                                "throw new SAXException(\"XMLُB҂Gg̃[J[\" + currentElementLocalNameOnStack + \"]"
                                                        + "ۂ̃[J[\" + localName + \"]ƂĂ܂.\");");
                                getData().addLine("}");
                                getData()
                                        .addLine(
                                                "if (currentElementUriOnStack.equals(uri) == false) {");
                                getData()
                                        .addLine(
                                                "throw new SAXException(\"XMLُB҂Gg̖OURI[\" + currentElementUriOnStack + \"]"
                                                        + "ۂ̖OURI[\" + uri + \"]ƂĂ܂.\");");
                                getData().addLine("}");

                                Enumeration enumeration = totalElementAttsHashtable
                                        .keys();
                                for (boolean isFirst = true; enumeration
                                        .hasMoreElements(); isFirst = false) {
                                    StringBuffer lineStatement = new StringBuffer();
                                    String keyQName = (String) enumeration
                                            .nextElement();
                                    final String[] names = (String[]) totalElementNamesHashtable
                                            .get(keyQName);

                                    getData()
                                            .addLine(
                                                    (isFirst ? "" : "else ")
                                                            + "if (uri.equals(\""
                                                            + names[0]
                                                            + "\") && localName.equals(\""
                                                            + names[1]
                                                            + "\")) {");

                                    getData()
                                            .addLine(
                                                    "fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".flush();");
                                    getData()
                                            .addLine(
                                                    "char[] wrk = fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".toCharArray();");
                                    getData()
                                            .addLine(
                                                    "fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".reset();");
                                    getData().addLine("if (wrk.length > 0) {");
                                    getData()
                                            .addLine(
                                                    "characters"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + "(wrk, 0, wrk.length);");
                                    getData().addLine("}");

                                    lineStatement.append("endElement"
                                            + BlancoNameAdjuster
                                                    .toClassName(keyQName)
                                            + "(uri, localName, qName);");
                                    getData().addLine(lineStatement.toString());

                                    getData().addLine("}");
                                }
                                getData().addLine("else {");
                                getData()
                                        .addLine(
                                                "throw new SAXException(\"XMLُBendElement: ȂGg OURI[\" + uri + \"], [J[\" + localName + \"]m܂.\");");
                                getData().addLine("}");
                                getData().addLine("// ŌɃ|bvĊKwЂƂ߂܂B");
                                getData().addLine(
                                        "fElementLocalNameStack.pop();");
                                getData().addLine("fElementUriStack.pop();");
                            }
                        });

                        addMethod(new MethodExpander("characters") {
                            protected boolean isFinal() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc()
                                        .addLine(
                                                "IWicharactersĂяoꂽ̂ŁAۃ\bhɌĂт킯܂");
                                getJavaDoc().addLine("W񂵂ŌĂт킯s܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("ch", "XML̕");
                                addArgument(new Value(new Type("char[]"), "ch"));
                                getJavaDoc().addParameter("start", "z̊Jnʒu");
                                addArgument(new Value(new Type("int"), "start"));
                                getJavaDoc().addParameter("length",
                                        "z񂩂ǂݎ镶");
                                addArgument(new Value(new Type("int"), "length"));
                            }

                            public void implement() {
                                getData()
                                        .addLine(
                                                "final String currentElementLocalNameOnStack = (String) fElementLocalNameStack.peek();");
                                getData()
                                        .addLine(
                                                "final String currentElementUriOnStack = (String) fElementUriStack.peek();");

                                Enumeration enumeration = totalElementAttsHashtable
                                        .keys();
                                for (boolean isFirst = true; enumeration
                                        .hasMoreElements(); isFirst = false) {
                                    StringBuffer lineStatement = new StringBuffer();
                                    String keyQName = (String) enumeration
                                            .nextElement();
                                    final String[] names = (String[]) totalElementNamesHashtable
                                            .get(keyQName);

                                    getData()
                                            .addLine(
                                                    (isFirst ? "" : "else ")
                                                            + "if (currentElementUriOnStack.equals(\""
                                                            + names[0]
                                                            + "\") && currentElementLocalNameOnStack.equals(\""
                                                            + names[1]
                                                            + "\")) {");

                                    lineStatement.append("// characters"
                                            + BlancoNameAdjuster
                                                    .toClassName(keyQName)
                                            + "(ch, start, length);");
                                    getData().addLine(lineStatement.toString());

                                    getData()
                                            .addLine(
                                                    "fWriter"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(keyQName)
                                                            + ".write(ch, start, length);");

                                    getData().addLine("}");
                                }
                            }
                        });

                        addMethod(new MethodExpander("ignorableWhitespace") {
                            protected boolean isFinal() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc()
                                        .addLine(
                                                "IWiignorableWhitespaceĂяoꂽ̂ŁAۃ\bhɌĂт킯܂");
                                getJavaDoc().addLine("W񂵂ŌĂт킯s܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("ch", "XML̕");
                                addArgument(new Value(new Type("char[]"), "ch"));
                                getJavaDoc().addParameter("start", "z̊Jnʒu");
                                addArgument(new Value(new Type("int"), "start"));
                                getJavaDoc().addParameter("length",
                                        "z񂩂ǂݎ镶");
                                addArgument(new Value(new Type("int"), "length"));
                            }

                            public void implement() {
                                getData()
                                        .addLine(
                                                "final String currentElementLocalNameOnStack = (String) fElementLocalNameStack.peek();");
                                getData()
                                        .addLine(
                                                "final String currentElementUriOnStack = (String) fElementUriStack.peek();");

                                Enumeration enumeration = totalElementAttsHashtable
                                        .keys();
                                for (boolean isFirst = true; enumeration
                                        .hasMoreElements(); isFirst = false) {
                                    StringBuffer lineStatement = new StringBuffer();
                                    String keyQName = (String) enumeration
                                            .nextElement();
                                    final String[] names = (String[]) totalElementNamesHashtable
                                            .get(keyQName);

                                    getData()
                                            .addLine(
                                                    (isFirst ? "" : "else ")
                                                            + "if (currentElementUriOnStack.equals(\""
                                                            + names[0]
                                                            + "\") && currentElementLocalNameOnStack.equals(\""
                                                            + names[1]
                                                            + "\")) {");

                                    lineStatement.append("ignorableWhitespace"
                                            + BlancoNameAdjuster
                                                    .toClassName(keyQName)
                                            + "(ch, start, length);");
                                    getData().addLine(lineStatement.toString());

                                    getData().addLine("}");
                                }
                            }
                        });

                        addMethod(new MethodExpander("setDocumentLocator") {
                            // \bh̃VOj`w
                            public void setupSignature() {
                                getJavaDoc().addLine("̃\bh𖳎邽߂̃\bhłB");
                                addArgument(new Value(new Type(
                                        "org.xml.sax.Locator"), "locator"));
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("startPrefixMapping") {
                            // \bh̃VOj`w
                            public void setupSignature() {
                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "prefix"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "uri"));
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("endPrefixMapping") {
                            // \bh̃VOj`w
                            public void setupSignature() {
                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "prefix"));
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("processingInstruction") {
                            // \bh̃VOj`w
                            public void setupSignature() {
                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "target"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "data"));
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("skippedEntity") {
                            // \bh̃VOj`w
                            public void setupSignature() {
                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "name"));
                            }

                            public void implement() {
                            }
                        });
                    }

                    // ܂ł endDocument̏łB

                    //  startElement̏s܂B

                    /**
                     * startElementĂяoꂽۂɁAʂ̃\bh̍쐬s܂B
                     */
                    public void startElement(final String uri,
                            final String localName, final String qName,
                            final Attributes atts) throws SAXException {

                        final ArrayList listAttr = new ArrayList();

                        if (totalElementAttsHashtable.get(qName) != null) {
                            // łɓoꂵGgłB
                            // ̓XLbv܂B
                            return;
                        }
                        totalElementAttsHashtable.put(qName, listAttr);
                        totalElementNamesHashtable.put(qName, new String[] {
                                uri, localName, qName });

                        addMethod(new MethodExpander("startElement"
                                + BlancoNameAdjuster.toClassName(qName)) {
                            // \bh̃VOj`w
                            protected boolean isAbstract() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "startElementړt̏C[" + qName
                                                + "]ŌĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "ړt̏C̓\bhɊ܂܂̂Ɠ̂̂^܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("uri", "OURI");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "uri"));
                                getJavaDoc().addParameter("localName", "[J");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "localName"));
                                getJavaDoc().addParameter("qName", "ړt̏C");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "qName"));
                                final int attrLength = atts.getLength();
                                for (int index = 0; index < attrLength; index++) {
                                    getJavaDoc()
                                            .addParameter(
                                                    "attr"
                                                            + BlancoNameAdjuster
                                                                    .toClassName(atts
                                                                            .getQName(index)),
                                                    "Agr[g["
                                                            + atts
                                                                    .getQName(index)
                                                            + "]̒ln܂B");
                                    addArgument(new Value(new Type(
                                            "java.lang.String"), "attr"
                                            + BlancoNameAdjuster
                                                    .toClassName(atts
                                                            .getQName(index))));
                                    listAttr.add(new String[] {
                                            atts.getURI(index),
                                            atts.getLocalName(index),
                                            atts.getQName(index) });
                                }
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("endElement"
                                + BlancoNameAdjuster.toClassName(qName)) {
                            protected boolean isAbstract() {
                                return true;
                            }

                            // \bh̃VOj`w
                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "endElementړt̏C[" + qName
                                                + "]ŌĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "ړt̏C̓\bhɊ܂܂̂Ɠ̂̂^܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("uri", "OURI");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "uri"));
                                getJavaDoc().addParameter("localName", "[J");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "localName"));
                                getJavaDoc().addParameter("qName", "ړt̏C");
                                addArgument(new Value(new Type(
                                        "java.lang.String"), "qName"));
                            }

                            public void implement() {
                            }
                        });

                        FieldExpander field1 = new FieldExpander(new Type(
                                "java.io.CharArrayWriter"), "fWriter"
                                + BlancoNameAdjuster.toClassName(qName)) {
                        };
                        field1.setLiteralValue("new CharArrayWriter()");
                        field1.getJavaDoc().addLine(
                                "charactersɓn߂̃LbVł<br>");
                        field1.getJavaDoc().addLine("f[^~ς܂B");
                        addField(field1);

                        addMethod(new MethodExpander("characters"
                                + BlancoNameAdjuster.toClassName(qName)) {
                            // \bh̃VOj`w
                            protected boolean isAbstract() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "charactersړt̏C[" + qName
                                                + "]ŌĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "Ƃcharacters\bhW񂵂Ń\bhĂяo܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("ch", "XML̕");
                                addArgument(new Value(new Type("char[]"), "ch"));
                                getJavaDoc().addParameter("start", "z̊Jnʒu");
                                addArgument(new Value(new Type("int"), "start"));
                                getJavaDoc().addParameter("length",
                                        "z񂩂ǂݎ镶");
                                addArgument(new Value(new Type("int"), "length"));
                            }

                            public void implement() {
                            }
                        });

                        addMethod(new MethodExpander("ignorableWhitespace"
                                + BlancoNameAdjuster.toClassName(qName)) {
                            // \bh̃VOj`w
                            protected boolean isAbstract() {
                                return true;
                            }

                            public void setupSignature() {
                                getJavaDoc().addLine(
                                        "ignorableWhitespaceړt̏C["
                                                + qName + "]ŌĂяo܂B<br>");
                                getJavaDoc()
                                        .addLine(
                                                "Ƃcharacters\bhW񂵂Ń\bhĂяo܂B");

                                addException(new Type(
                                        "org.xml.sax.SAXException"));
                                getJavaDoc().addParameter("ch", "XML̕");
                                addArgument(new Value(new Type("char[]"), "ch"));
                                getJavaDoc().addParameter("start", "z̊Jnʒu");
                                addArgument(new Value(new Type("int"), "start"));
                                getJavaDoc().addParameter("length",
                                        "z񂩂ǂݎ镶");
                                addArgument(new Value(new Type("int"), "length"));
                            }

                            public void implement() {
                            }
                        });
                    }

                    // ܂ł startElement̏łB

                    public void endElement(String uri, String localName,
                            String qName) throws SAXException {
                    }

                    public void startPrefixMapping(String arg0, String arg1)
                            throws SAXException {
                    }

                    public void endPrefixMapping(String arg0)
                            throws SAXException {
                    }

                    public void characters(char[] ch, int start, int length)
                            throws SAXException {
                    }

                    public void ignorableWhitespace(char[] arg0, int arg1,
                            int arg2) throws SAXException {
                    }

                    public void processingInstruction(String arg0, String arg1)
                            throws SAXException {
                    }

                    public void skippedEntity(String arg0) throws SAXException {
                    }
                });

                BlancoSaxUtil.doTransform(sourceFile, result);
            }
        };
    }

    /**
     * XMLnɓĂʂȖOԂɂāAm܂B
     * 
     * @param arg
     * @return
     */
    public static final boolean isXmlNaturePrefix(final String arg) {
        if (arg.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (arg.equals("http://www.w3.org/2000/xmlns/")) {
            return true;
        }
        return false;
    }
}
