/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.test.db.ddl;

/**
 * {vOblancoDb̎ڂ̂AP\Ɋւ鎎{邽߂̃[eBeBłB
 * 
 * 1̗񂪊܂܂ꂽ\ΏۂƂȂ܂B<br>
 * ̃vO SQL Server 2000pDDL𐶐܂B
 */
public class SimpleTableSQLServer2000SingleColumnDDL {
    public static final String[] TYPES = { "BIGINT", "BINARY(50)", "BIT",
            "CHAR(10)", "DATETIME", "DECIMAL(18, 3)", "FLOAT", "IMAGE", "INT",
            "MONEY", "NCHAR(10)", "NTEXT", "NUMERIC", "NVARCHAR(10)", "REAL",
            "SMALLDATETIME", "SMALLINT", "SMALLMONEY", "TEXT", "TIMESTAMP",
            "TINYINT", "UNIQUEIDENTIFIER", "VARBINARY", "VARCHAR" };

    /**
     * DDL̍쐬s܂B
     * 
     * @param args
     *            Bw肳ꂽe͖܂B
     */
    public static void main(final String[] args) {
        System.out.println("------------------------------------------");
        System.out.println("-- 폜GAłB --");
        System.out.println("------------------------------------------");

        generateDeleteSingleColumnPrimary();
        generateDeleteSingleColumnNonPrimary();
        generateDeleteSingleColumnPrimaryNullable();
        generateDeleteSingleColumnNonPrimaryNullable();

        System.out.println("------------------------------------------");
        System.out.println("-- 琶GAłB --");
        System.out.println("------------------------------------------");

        generateSingleColumnPrimary();
        generateSingleColumnNonPrimary();
        generateSingleColumnPrimaryNullable();
        generateSingleColumnNonPrimaryNullable();
    }

    private static final void generateSingleColumnPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1̃vC}L[ɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TYPES[index]) || "NTEXT".equals(TYPES[index])
                    || "TEXT".equals(TYPES[index])) {
                System.out.println("-- " + TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out
                    .println("/*1̃vC}L[̕\𐶐܂B(" + TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " " + TYPES[index]
                    + " NOT NULL");
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateSingleColumnPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1NULLeȃvC}L[ɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TYPES[index]) || "NTEXT".equals(TYPES[index])
                    || "TEXT".equals(TYPES[index])) {
                System.out.println("-- " + TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out
                    .println("/*1̃vC}L[̕\𐶐܂B(" + TYPES[index] + ")*/");
            System.out.println("CREATE TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " " + TYPES[index]);
            System.out.println(", PRIMARY KEY (FIELD_" + fieldName + ")");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateSingleColumnNonPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1̗ɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*1̔vC}L[̕\𐶐܂B(" + TYPES[index]
                    + ")*/");
            System.out.println("CREATE TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + " (");
            System.out.println("FIELD_" + fieldName + " " + TYPES[index]
                    + " NOT NULL");
            System.out.println(");");
            System.out.println("");
        }
    }

    private static final void generateSingleColumnNonPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1NULLeȗɂ\쐬܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("/*1̔vC}L[̕\𐶐܂B(" + TYPES[index]
                    + ")*/");
            System.out.println("CREATE TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + "_NULLABLE (");
            System.out.println("FIELD_" + fieldName + " " + TYPES[index]);
            System.out.println(");");
            System.out.println("");
        }
    }

    // ͍폜GAłB
    // 폜pDDL𐶐܂B

    private static final void generateDeleteSingleColumnPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1̃vC}L[ɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TYPES[index]) || "NTEXT".equals(TYPES[index])
                    || "TEXT".equals(TYPES[index])) {
                System.out.println("-- " + TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteSingleColumnPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1NULLeȃvC}L[ɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            if ("IMAGE".equals(TYPES[index]) || "NTEXT".equals(TYPES[index])
                    || "TEXT".equals(TYPES[index])) {
                System.out.println("-- " + TYPES[index]
                        + "^̓vC}L[Ƃ邱Ƃ͂ł܂B");
                System.out.println("");
                continue;
            }

            System.out.println("DROP TABLE TEST_SINGLE_COLUMN_PRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

    private static final void generateDeleteSingleColumnNonPrimary() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1̗ɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + ";");
        }
    }

    private static final void generateDeleteSingleColumnNonPrimaryNullable() {
        System.out.println("------------------------------------------");
        System.out.println("-- 1NULLeȗɂ\폜܂B");
        System.out.println("------------------------------------------");
        System.out.println("");

        for (int index = 0; index < TYPES.length; index++) {
            final int spacePosition = TYPES[index].indexOf("(");
            String fieldName = TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            System.out.println("DROP TABLE TEST_SINGLE_COLUMN_NONPRIMARY_"
                    + (index + 1) + "_NULLABLE;");
        }
    }

}
