/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import blanco.db.mapping.BlancoDbMappingUtil;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * JDBC̃^ƂJavǎ^ւƃ}bsOs܂B
 * 
 * @author Yasuo Nakanishi o[W̊J
 * @author Tosiki Iga ێeiXS
 * @version 2005.12.20 {IɌver.2
 * @version 2005.05.06 {IɌver.1
 */
public class FieldFactory {
    private final BlancoDbResourceBundle bundle = new BlancoDbResourceBundle();

    /**
     * P\̏ƂɁAJDBČ^Javǎ^ւƃ}bsO܂B
     * 
     * @param resultSet
     *            P\̏̂߂̃UgZbgł
     * @return e[utB[h߂܂
     * @throws SQLException
     *             SQLOꍇ
     */
    public TableField createTableField(final ResultSet resultSet)
            throws SQLException {
        final int type = resultSet.getInt("DATA_TYPE");
        final String name = resultSet.getString("COLUMN_NAME");
        final String typeName = resultSet.getString("TYPE_NAME");
        final int isNullable = resultSet.getInt("NULLABLE");

        Class mappedClass = BlancoDbMappingUtil.mapResultSetMeta2JavaClass(
                type, isNullable == ResultSetMetaData.columnNoNulls);

        // ^ĂȂꍇ̏s܂B
        if (mappedClass == null) {
            mappedClass = BlancoDbMappingUtil.mapTypeName2JavaClass(typeName,
                    isNullable == ResultSetMetaData.columnNoNulls);
        }
        if (mappedClass == null) {
            if (bundle.getTypeMappingFailOnError().equals("true")) {
                throw new IllegalArgumentException(bundle.getTypeMappingErr001(
                        new BigDecimal(String.valueOf(type)),
                        BlancoDbMappingUtil.convertJdbcTypeToString(type)));
            }
            return null;
        }

        final TableField result = new TableField(mappedClass, name);
        result.setJdbcType(type);
        result.setSize(resultSet.getInt("COLUMN_SIZE"));
        result.setNullable(isNullable);

        switch (type) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
            result.setSize(resultSet.getInt("CHAR_OCTET_LENGTH"));
            break;
        case java.sql.Types.LONGVARCHAR:
            break;
        case java.sql.Types.DATE:
        case java.sql.Types.TIME:
        case java.sql.Types.TIMESTAMP:
            break;
        case java.sql.Types.REAL:
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
        case java.sql.Types.INTEGER:
        case java.sql.Types.BIGINT:
        case java.sql.Types.SMALLINT:
        case java.sql.Types.TINYINT:
        case java.sql.Types.BIT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
            } else {
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
            // Precision̂COLUMN_SIZE𗘗pĂ܂B
            result.setPrecision(resultSet.getInt("COLUMN_SIZE"));
            result.setScale(resultSet.getInt("DECIMAL_DIGITS"));
            break;
        case java.sql.Types.BINARY:
        case java.sql.Types.LONGVARBINARY:
            break;
        default:
            break;
        }

        return result;
    }

    /**
     * SQLsʂ̏ƂɁAJDBČ^Javǎ^ւƃ}bsO܂B
     * 
     * @param index
     *            tB[h̃CfBbNXԍ
     * @param meta
     *            ^
     * @return oꂽtB[h
     * @throws SQLException
     *             SQLOꍇ
     */
    public QueryField createQueryField(final int index,
            final ResultSetMetaData meta) throws SQLException {
        final int type = meta.getColumnType(index);
        final String name = meta.getColumnName(index);
        final String typeName = meta.getColumnTypeName(index);
        final int isNullable = meta.isNullable(index);

        Class mappedClass = BlancoDbMappingUtil.mapResultSetMeta2JavaClass(
                type, isNullable == ResultSetMetaData.columnNoNulls);

        // ^ĂȂꍇ̏s܂B
        if (mappedClass == null) {
            mappedClass = BlancoDbMappingUtil.mapTypeName2JavaClass(typeName,
                    isNullable == ResultSetMetaData.columnNoNulls);
        }
        if (mappedClass == null) {
            if (bundle.getTypeMappingFailOnError().equals("true")) {
                throw new IllegalArgumentException(bundle.getTypeMappingErr001(
                        new BigDecimal(String.valueOf(type)),
                        BlancoDbMappingUtil.convertJdbcTypeToString(type)));
            }
            return null;
        }

        final QueryField result = new QueryField(mappedClass, name);
        result.setJdbcType(type);
        result.setSize(meta.getColumnDisplaySize(index));
        result.setNullable(isNullable);
        result.setReadOnly(meta.isReadOnly(index));
        result.setWritable(meta.isWritable(index));
        result.setDefinitelyWritable(meta.isDefinitelyWritable(index));

        switch (type) {
        case java.sql.Types.CHAR:
        case java.sql.Types.VARCHAR:
            // Pe[uƈقȂA̎擾pX݂܂B
            break;
        case java.sql.Types.LONGVARCHAR:
            break;
        case java.sql.Types.DATE:
        case java.sql.Types.TIME:
        case java.sql.Types.TIMESTAMP:
            break;
        case java.sql.Types.REAL:
        case java.sql.Types.FLOAT:
        case java.sql.Types.DOUBLE:
        case java.sql.Types.INTEGER:
        case java.sql.Types.BIGINT:
        case java.sql.Types.SMALLINT:
        case java.sql.Types.TINYINT:
        case java.sql.Types.BIT:
            if (isNullable == ResultSetMetaData.columnNoNulls) {
            } else {
                result.setObjectMappingForPrimitiveNullSupport(true);
            }
            break;
        case java.sql.Types.DECIMAL:
        case java.sql.Types.NUMERIC:
            result.setPrecision(meta.getPrecision(index));
            result.setScale(meta.getScale(index));
            break;
        case java.sql.Types.BINARY:
        case java.sql.Types.LONGVARBINARY:
            break;
        default:
            break;
        }

        return result;
    }
}