/*
 * blancoCommons Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */

package blanco.commons.util;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BlancoXmlUtil {
    /**
     * IꂽGg當擾܂B
     * 
     * @param elementTarget
     * @return
     */
    public static final String getTextContent(final Element elementTarget) {
        String result = null;
        NodeList listText = elementTarget.getChildNodes();
        int sizeChildList = listText.getLength();
        for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
            Node nodeChild = listText.item(indexChild);
            if (nodeChild instanceof Text) {
                Text textLook = (Text) nodeChild;
                result = (result == null ? textLook.getData() : result
                        + textLook.getData());
            }
        }
        return result;
    }

    /**
     * Ggw̃^O̕ǂݍ݂܂B
     * 
     * @param elementTarget
     * @param tagName
     * @return
     */
    public static final String getTextContent(final Element elementTarget,
            final String tagName) {
        String result = null;
        NodeList listElementTarget = elementTarget
                .getElementsByTagName(tagName);
        int sizeList = listElementTarget.getLength();
        for (int index = 0; index < sizeList; index++) {
            Node nodeLook = listElementTarget.item(index);
            if (nodeLook instanceof Element) {
                Element elementLook = (Element) nodeLook;

                NodeList listText = elementLook.getChildNodes();
                int sizeChildList = listText.getLength();
                for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
                    Node nodeChild = listText.item(indexChild);
                    if (nodeChild instanceof Text) {
                        Text textLook = (Text) nodeChild;
                        result = (result == null ? textLook.getData() : result
                                + textLook.getData());
                    }
                }
            }
        }
        return result;
    }
}
