/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.db.BlancoDbMeta2Xml;
import blanco.db.BlancoDbTableMeta2Xml;
import blanco.db.BlancoDbXml2JavaClass;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;

/**
 * BlancoDb Ant Task
 */
public class BlancoDbTask extends Task {
    private String jdbcdriver = null;

    private String jdbcurl = null;

    private String jdbcuser = null;

    private String jdbcpassword = null;

    private String metadir = null;

    private String tmpdir = null;

    private String targetdir = null;

    private String basepackage = null;

    private String schema = null;

    private String table = null;

    private String sql = null;

    private String log = null;

    /**
     * @return basepackage ߂܂B
     */
    public String getBasepackage() {
        return basepackage;
    }

    /**
     * @param basepackage
     *            basepackage ݒB
     */
    public void setBasepackage(final String basepackage) {
        this.basepackage = basepackage;
    }

    /**
     * @return jdbcdriver ߂܂B
     */
    public String getJdbcdriver() {
        return jdbcdriver;
    }

    /**
     * @param jdbcdriver
     *            jdbcdriver ݒB
     */
    public void setJdbcdriver(final String jdbcdriver) {
        this.jdbcdriver = jdbcdriver;
    }

    /**
     * @return jdbcpassword ߂܂B
     */
    public String getJdbcpassword() {
        return jdbcpassword;
    }

    /**
     * @param jdbcpassword
     *            jdbcpassword ݒB
     */
    public void setJdbcpassword(final String jdbcpassword) {
        this.jdbcpassword = jdbcpassword;
    }

    /**
     * @return jdbcurl ߂܂B
     */
    public String getJdbcurl() {
        return jdbcurl;
    }

    /**
     * @param jdbcurl
     *            jdbcurl ݒB
     */
    public void setJdbcurl(final String jdbcurl) {
        this.jdbcurl = jdbcurl;
    }

    /**
     * @return jdbcuser ߂܂B
     */
    public String getJdbcuser() {
        return jdbcuser;
    }

    /**
     * @param jdbcuser
     *            jdbcuser ݒB
     */
    public void setJdbcuser(final String jdbcuser) {
        this.jdbcuser = jdbcuser;
    }

    /**
     * @return metadir ߂܂B
     */
    public String getMetadir() {
        return metadir;
    }

    /**
     * @param metadir
     *            metadir ݒB
     */
    public void setMetadir(final String metadir) {
        this.metadir = metadir;
    }

    /**
     * @return schema ߂܂B
     */
    public String getSchema() {
        return schema;
    }

    /**
     * @param schema
     *            schema ݒB
     */
    public void setSchema(final String schema) {
        this.schema = schema;
    }

    public void execute() throws BuildException {
        System.out.println("blancoDb ^XN");
        if (jdbcdriver == null) {
            throw new BuildException("jdbcdriverw肵ĂB");
        }
        if (jdbcurl == null) {
            throw new BuildException("jdbcurlw肵ĂB");
        }
        if (jdbcuser == null) {
            throw new BuildException("jdbcuserw肵ĂB");
        }
        if (jdbcpassword == null) {
            throw new BuildException("jdbcpasswordw肵ĂB");
        }
        if (metadir == null) {
            throw new BuildException("metadirw肵ĂB");
        }
        if (basepackage == null) {
            throw new BuildException("basepackagew肵ĂB");
        }
        if (tmpdir == null) {
            // e|tH_̎w肪Ȃꍇɂ́AJgtmpp܂B
            tmpdir = "tmp";
        }
        try {
            final File blancoSqlDirectory = new File(getMetadir());
            final File blancoTmpDbTableDirectory = new File(tmpdir
                    + "/db/table");
            final File blancoTmpDbSqlDirectory = new File(tmpdir + "/db/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbDatabaseConnectionSettingDef connDef = new BlancoDbDatabaseConnectionSettingDef();
            connDef.setJdbcDriver(getJdbcdriver());
            connDef.setJdbcUrl(getJdbcurl());
            connDef.setJdbcUser(getJdbcuser());
            connDef.setJdbcPassword(getJdbcpassword());

            if (getSchema() != null) {
                // XL[}wB
                connDef.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // SimpleTableGateway
                final BlancoDbTableMeta2Xml gateway2xml = new BlancoDbTableMeta2Xml() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                gateway2xml.process(connDef, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (log != null && log.equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbTableDirectory,
                        getBasepackage(), getTargetdir());
            }

            if (getSql() == null || getSql().equals("true")) {
                final File[] files = blancoSqlDirectory.listFiles();
                if (files != null) {
                    for (int index = 0; index < files.length; index++) {
                        // Excelt@CXMLt@C܂B
                        if (files[index].getName().endsWith(".xls") == false) {
                            continue;
                        }
                        InputStream inStream = null;
                        OutputStream outStream = null;
                        try {
                            final ByteArrayOutputStream workStream = new ByteArrayOutputStream();
                            inStream = new BufferedInputStream(
                                    new FileInputStream(files[index]));
                            outStream = new BufferedOutputStream(workStream);
                            new BlancoDbMeta2Xml() {
                                public boolean progress(int progressCurrent,
                                        int progressTotal, String progressItem) {
                                    // trueԂ܂B
                                    return true;
                                }
                            }.process(inStream, outStream);
                            outStream.flush();
                            outStream.close();
                            outStream = null;
                            inStream.close();
                            inStream = null;
                        } finally {
                            if (inStream != null) {
                                inStream.close();
                            }
                            if (outStream != null) {
                                outStream.close();
                            }
                        }
                    }
                }
                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (log != null && log.equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbSqlDirectory,
                        getBasepackage(), getTargetdir());

            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("rhɗO: rh𒆒f܂: " + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("rhɃG[: rh𒆒f܂: " + e.toString());
        }
    }

    public String getTargetdir() {
        return targetdir;
    }

    public void setTargetdir(final String targetdir) {
        this.targetdir = targetdir;
    }

    /**
     * @return Returns the sql.
     */
    public final String getSql() {
        return sql;
    }

    /**
     * @param sql
     *            The sql to set.
     */
    public final void setSql(final String sql) {
        this.sql = sql;
    }

    /**
     * @return Returns the table.
     */
    public final String getTable() {
        return table;
    }

    /**
     * @param table
     *            The table to set.
     */
    public final void setTable(final String table) {
        this.table = table;
    }

    public String getTmpdir() {
        return tmpdir;
    }

    public void setTmpdir(final String tmpdir) {
        this.tmpdir = tmpdir;
    }

    public String getLog() {
        return log;
    }

    public void setLog(final String log) {
        this.log = log;
    }
}
