/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import blanco.db.definition.QueryIterator;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetListMethod extends MethodExpander {

    private QueryIterator _iterator = null;

    public GetListMethod(final QueryIterator iterator) {
        super("getList");
        _iterator = iterator;
    }

    public void setupSignature() {
        setReturnType(new Type(List.class));
        if (_iterator.getScrollInterface().equals("forward_only") == false) {
            addArgument(new Value(int.class, "absoluteStartPoint"));
        }
        addArgument(new Value(int.class, "size"));
        addException(SQLException.class);
        addUsingType(new Type(ArrayList.class));

        getJavaDoc().addLine("ʂXgŎ擾܂B<br>");
        getJavaDoc().addLine("Xgɂ " + _iterator.getName() + "NXi[܂B");
        if (_iterator.getScrollInterface().equals("forward_only")) {
            getJavaDoc()
                    .addLine(
                            "FORWARD_ONLY(J[\)getList̗p͂ȂׂĂ. FORWARD_ONLY(J[\)ȊO̒l𗘗pčĐ邩 nexťĂяosĂ.");
        }
        if (_iterator.getScrollInterface().equals("forward_only") == false) {
            getJavaDoc().addParameter("absoluteStartPoint",
                    "ǂݏoJnsBŏ̍sǂݏoꍇɂ 1 w肵܂B");
        }
        getJavaDoc().addParameter("size", "ǂݏossB");
        getJavaDoc().addReturn(
                _iterator.getName() + "NXListBʂ0̏ꍇɂ͋̃XgB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addLine("List result = new ArrayList(size);");
        if (_iterator.getScrollInterface().equals("forward_only") == false) {
            implementor.addLine("if (absolute(absoluteStartPoint) == false) {");
            implementor.addLine("return result;");
            implementor.addLine("}");
        }
        implementor.addLine("for (int count = 1; count <= size; count++) {");
        if (_iterator.getScrollInterface().equals("forward_only")) {
            implementor.addLine("if (next() == false) {");
            implementor.addLine("break;");
            implementor.addLine("}");
        } else {
            implementor.addLine("if (count != 1) {");
            implementor.addLine("if (next() == false) {");
            implementor.addLine("break;");
            implementor.addLine("}");
            implementor.addLine("}");
        }
        implementor.addLine("result.add(getRow());");
        implementor.addLine("}");
        implementor.addLine("return result;");
    }
}