/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.sql.SQLException;

import blanco.db.util.BlancoDbObjectStorage;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareStatementCursorMethod extends MethodExpander {
    private BlancoDbObjectStorage storage = null;

    private Value queryArgument = new Value(String.class, "query");

    private Value resultSetTypeArgument = new Value(int.class, "resultSetType");

    private Value resultSetConcurrencyArgument = new Value(int.class,
            "resultSetConcurrency");

    public PrepareStatementCursorMethod(final BlancoDbObjectStorage storage) {
        super("prepareStatement");
        this.storage = storage;
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);
        addArgument(resultSetTypeArgument);
        addArgument(resultSetConcurrencyArgument);
        addException(SQLException.class);

        getJavaDoc().addLine("NG̃vRpC{܂B<br>");
        getJavaDoc().addLine("IɃJ[\̃XN[ωKvꍇɂ̂ݗp܂B<br>");
        getJavaDoc()
                .addLine(
                        "SQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[댯_ɒӂŗpĂB<br>");
        getJavaDoc().addLine("Iɂ Connection.prepareStatement Ăяo܂B");
        getJavaDoc().addParameter("query", "pNG(SQL)");
        getJavaDoc()
                .addParameter(
                        "resultSetType",
                        "ʃZbǧ^BResultSet.TYPE_FORWARD_ONLYAResultSet.TYPE_SCROLL_INSENSITIVEAResultSet.TYPE_SCROLL_SENSITIVÊꂩwB");
        getJavaDoc()
                .addParameter("resultSetConcurrency",
                        "s̎ށBResultSet.CONCUR_READ_ONLYAResultSet.CONCUR_UPDATABLÊꂩwB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor
                    .addLine("fLog.debug(\""
                            + getName()
                            + ": query = \" + query + \", resultSetType = \" + resultSetType + \", resultSetConcurrency = \" + resultSetConcurrency);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addStatement("close()");
        implementor
                .addStatement("fStatement = fConnection.prepareStatement(getQuery(), resultSetType, resultSetConcurrency)");
    }

}