/**
 * @file doxygen_problems.c
 * @author Shinichiro Nakamura
 * @brief Doxygen用のファイル。既知の問題点が記述してある。
 * @details
 *
 * @page problems 既知の問題点
 *
 * @section problems_hardware ハードウェアに関する既知の問題点
 *
 * - OLEDの電源配線ミス。
 *   - 電源の配線を追加する。
 *
 * - レギュレータのGNDの配線が細い。
 *   - 配線を太く、短くする。
 *
 * - 基板名やリビジョン、スペシャルサンクスのシルクが入っていない。
 *   - ガーバーデータ作成時にレイヤー指定を間違えたかも。
 *   - さらにチェックが甘かった。
 *
 * - OLEDのノイズ音が気になる。
 *   - 初期化パラメータの動作周波数変更で回避可能か？
 *
 * - OLEDに書き込みを行うとオーディオにノイズが発生する。
 *   - 配線がよくない。
 *   - 配置がよくない。
 *   - 完全分離が必須。
 *
 * - 発振器がオーディオを愛する人の周波数になっていない。
 *   - すいません！
 *
 * - ポリスイッチのパッケージが違う。
 *
 * - C31, C32への変なGND配線がある。
 *
 * - R37のビアがポリスイッチに近すぎる。
 *
 * - オーディオコネクタのパッケージがおかしい。
 *
 * - SDカードがレガシーSPIコアを使うようなペリフェラル割り当てになっている。
 *   - GPDMAによる転送が使えない。
 *   - OLEDよりもSDカードの方が優先度高いんじゃない？
 *
 * - SDカードを差し込むと電源がドロップする。
 *   - Cの容量を増やす。
 *   - Lを挿入して突入電流を阻止するか。
 *
 * - 何だかわからない電池BOXをやめて、入手可能なパッケージにしたい。
 *
 * - MIDI用UARTのコネクタのパッケージに位置決め穴がない。
 *
 * - MIC INの回路ってこれで良いの？
 *   - TI Stellaris LM3S9B96 Development Kitを参考にしている。
 *
 * - リセットスイッチを押さないとファームウェアが起動しない。
 *   - リセットの入り方が条件を満たしていないのではないか？
 *   - リセット解除が早すぎるのが原因。
 *   - 電源が安定する前に解除されている。
 *   - リセットICにしたい。
 *
 * @section problems_firmware ファームウェアに関する既知の問題点
 *
 * - codecの初期化に失敗することがある。
 *   - CMSISのドライバを使った実装に修正したい。
 *
 * - I2S DMAの開始で割り込み無限ループに突入する。
 *   - デバッガを外したコールドスタートで必ず発生する。
 *
 * - TLVを組み込んでブートできない。
 */

