/**
 * @file doxygen_hardware.c
 * @author Shinichiro Nakamura
 * @brief Doxygen用のファイル。ハードウェアに関するトピックが記述してある。
 * @details
 *
 * @page hardware ハードウェアに関するトピック
 *
 * ハードウェアに関する既知の問題点については @ref problems_hardware をご覧下さい。
 *
 * @section hardware_warning 使用上の注意
 *
 * OLEDは同じ内容を表示し続けると焼き付きが発生します。
 * 表示内容を時折変更するようにして下さい。
 *
 * @section hardware_validation ハードウェアテスト項目
 *
 * <pre>
 *   +======+================+===================================+
 *   |      | 緑ランプ波形   |                                   |
 *   |      +----------------+-----------------------------------+
 *   | OLED | 青ランプ波形   |                                   |
 *   |      +----------------+-----------------------------------+
 *   |      | 赤ランプ波形   |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | スイッチ入力   |                                   |
 *   | SW.  +----------------+-----------------------------------+
 *   |      | スイッチLED    |                                   |
 *   +------+----------------+-----------------------------------+
 *   |Volume| スイッチ入力   |                                   |
 *   +------+----------------+-----------------------------------+
 *   |DEBLED| スイッチ入力   |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | コーデック     |                                   |
 *   |      +----------------+-----------------------------------+
 *   |      | MIC-IN         |                                   |
 *   |      +----------------+-----------------------------------+
 *   |AUDIO | LINE-IN        |                                   |
 *   |      +----------------+-----------------------------------+
 *   |      | LINE-OUT       |                                   |
 *   |      +----------------+-----------------------------------+
 *   |      | PHONE-OUT      |                                   |
 *   +------+----------------+-----------------------------------+
 *   | JTAG | JTAG           |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | RESET          |                                   |
 *   |DEBSW.+----------------+-----------------------------------+
 *   |      | ISP            |                                   |
 *   +------+----------------+-----------------------------------+
 *   | USB  | USB-UART       |                                   |
 *   +------+----------------+-----------------------------------+
 *   | SD   | SDCARD         |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | UART1          |                                   |
 *   |      +----------------+-----------------------------------+
 *   | UART | UART2          |                                   |
 *   |      +----------------+-----------------------------------+
 *   |      | UART3          |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | Main Power     |                                   |
 *   | RTC  +----------------+-----------------------------------+
 *   |      | Battery        |                                   |
 *   +------+----------------+-----------------------------------+
 *   |      | 5.0V           |                                   |
 *   |POWER +----------------+-----------------------------------+
 *   |      | 3.3V           |                                   |
 *   +------+----------------+-----------------------------------+
 * </pre>
 */

