/* locore.s --- ֥ǽ񤫤ʤФʤʤؿ
 *              ѿ.
 *
 *
 */


.text

.globl		get_cr0, get_cr2, get_cr3, load_task_register
.globl		flush_tlb
.globl		resume, resume0
.globl		set_task_registers

/*************************************************************************
 * get_cr0 --- ȥ쥸 0 Ƥ֤
 *
 * 	ʤ
 *
 * ͡	ȥ쥸 0 Ƥ֤
 *
 * 	ȥ쥸 0 Ƥ֤
 *
 */
get_cr0:
		mov	%cr0, %eax
		ret

/*************************************************************************
 * get_cr2 --- ȥ쥸 2 Ƥ֤
 *
 * 	ʤ
 *
 * ͡	ȥ쥸 2 ơ
 *
 * 	ȥ쥸 2 Ƥ֤
 *
 */
get_cr2:
		mov	%cr2, %eax
		ret

/*************************************************************************
 * get_cr3 --- ȥ쥸 3 Ƥ֤
 *
 * 	ʤ
 *
 * ͡	ȥ쥸 3 ơ
 *
 * 	ȥ쥸 3 Ƥ֤
 *
 */
get_cr3:
		mov	%cr3, %eax
		ret


/*************************************************************************
 * set_cr3 --- ȥ쥸 3 Ƥꤹ롣
 *
 * 	ȥ쥸 3 ơ
 *
 * ͡	ʤ
 *
 * 	ȥ쥸 3 Ƥꤹ롣
 *
 */
set_cr3:
		movl	4(%esp),%eax		/*  CR3 Ƥ򥹥å */
						/* Ф */
		movl	%eax,%cr3		/* ꤹ롣*/
		ret


/*************************************************************************
 * load_task_register --- ȥ쥸Υ
 *
 * 	ǥ󥰤륿ȥ쥸ؤΥ쥯
 *
 * ͡	ʤ
 *
 * 	ltr ¹Ԥ롣
 *
 */
string1:
		.ascii "load_task_register: arg = 0x%x\n"
		.align 2
load_task_register:
		pushl	%ebp
		movl	%esp,%ebp
/*
		pushl	8(%ebp)
		pushl	$string1
		call	printf
*/
		movl	8(%ebp),%eax
		ltr	%ax
		leave
		ret


/*************************************************************************
 * resume --- ǻꤷץڤ괹롣
 *
 * 	ڤ괹ץ TSS 򤵤쥯
 *
 * ͡	ʤ
 *
 * 	Ϥ줿쥯 TSS jump 롣
 *		η̥ץڤ괹롣
 *
 */
LC0:
		.ascii "resume: arg = 0x%x\n"
		.align 2
offset:		.long	0x0000
selector:	.word	0x0000

resume:
#if 0
		pushl	%ebp
		movl	%esp, %ebp
		movl	8(%ebp), %edx
		pushl	%edx
		pushl	$LC0
		call	printf
		leave
		ret
#endif
		cli
		pushl	%ebp
		movl	%esp, %ebp
		movl	8(%ebp), %edx
		movw	%dx, (selector)
		lea	offset, %eax		/* */
		movl	%cr3, %ebx		/* TLB åեå夹 */
		movl	%ebx, %cr3
/*
 *		ץڤ괹
 *		ljmp	far (%ax)
 */
resume0:
		.byte	0xff
		.byte	0x28
		leave
		sti
		ret

/*************************************************************************
 * flush_tlb	--- ڡѴåեå夹롣
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	cr3 Ƥ get Ʊ put 롣
 *
 */
flush_tlb:
		pushl	%eax
		movl	%cr3, %eax
		movl	%eax, %cr3
		popl	%eax
		ret


set_task_registers:
		ret