/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* @(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/BTRON/manager/MM/port.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $ */

static char rcs[] = "@(#) $Header: /cvsroot/bfree-info/B-Free/Program/btron-pc/kernel/BTRON/manager/MM/port.c,v 1.1 2011/12/27 17:13:35 liu1 Exp $";


/*
 * $Log: port.c,v $
 * Revision 1.1  2011/12/27 17:13:35  liu1
 * Initial Version.
 *
 * Revision 1.2  1997-06-29 15:44:34  night
 * Ȥѹ
 *
 * ɤ SJIS  EUC ѹ
 * RCS  Log ޥΥȤɲä(ޤƤʤäեΤ)
 *
 *
 */

#include "memory_manager.h"


/* init_port - ׵դѤΥݡȤ
 *
 * 
 *	⤷Ǥ˥åݡȤƤˤ
 * 	⤷ʤξˤϡSUCCESS ֤롣
 *
 * ֤
 *	SUCCESS	
 *	FAIL	
 *
 */
W
init_port (void)
{
  ID	port;

  /* Ǥ˥ݡȤƤ
   */
  if (request_port != 0)
    {
      return (SUCCESS);
    }

  /* ݡȤ */
  if ((port = get_port (sizeof (struct mm_request_t), sizeof (struct mm_request_t))) <= 0)
    {
      /* ݡȤǤʤä */
      return (FAIL);
    }

  request_port = port;

  /* ݡȥޥ͡Ͽ */
  if (regist_port (BTRON_MM_MANAGER, port) != E_PORT_OK)
    {
      /* ݡȤ */
      return (FAIL);
    }

  return (SUCCESS);	/* ݡȤǤ */
}


/* get_request - ꥯȤ
 *
 */
W
get_request (struct mm_request_t *req)
{
  extern ER	sys_errno;

  ASSERT (req != NULL);

  sys_errno = rcv_mbf (req, sizeof (struct mm_request_t), request_port);
  if (sys_errno != E_OK)
    return (0);
  return (SUCCESS);
}


/* put_response -
 *
 */
W
put_response (struct mm_request_t *req, 
	      W errno,
	      W status,
	      W ret1,
	      W ret2)
{
  static struct mm_response_t	res;
  ER				syserr;

  if (req == NULL)
    {
      return (EMM_INVAL);
    }

  res.receive_port = request_port;
  res.msg_length = sizeof (res);
  res.operation = req->operation;
  res.errno = errno;
  res.status = status;
  res.ret1 = ret1;
  res.ret2 = ret2;

  /* ׵ḵ */
  syserr = snd_mbf (req->receive_port, sizeof (res), &res);
  return (EMM_OK);
}


/* 顼ˤʤäȤꥯȤ긵֤
 *
 */
W
error_response (struct mm_request_t *req, W errno)
{
  /* ׵ḵ */
  return (put_response (req, errno, 0, 0, 0));
}
