/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* echo.c --- echo ǥХɥ饤 
 *
 * ΥǥХɥ饤ФϡI/O ƥΥǥХåѤ˺
 * 
 */

#include "itron.h"
#include "errno.h"
#include "task.h"
#include "misc.h"
#include "func.h"
#include "interrupt.h"
#include "../io/io.h"

static ID	deviceid;	/* ǥХֹ(ǥХơ֥Υȥֹ) */
				/* ֹȤƻѤ롣*/
static ID	taskid;		/* ңӣåɥ饤ФΥɣ */


extern ER	init_echo (void);
static void echo_server ();

/* ǥХåѤ printf 
 */
#define DPRINTF(x)	{ printf x; }


/*****************************************************************************
 * init_echo 
 *
 * 
 *	ʤ
 *
 * ֤͡
 *	顼ֹ
 *	E_OK	ｪλ
 *
 * ǽ
 *
 *
 */
ER
init_echo (void)
{
  ER		err;
  T_CTSK	pktsk;

  err = def_dev (L"ţãȣ", CHAR, ANY_DEVICE, &deviceid);
  if (err != E_OK)
    {
      printf ("cannot initialize for echo device. err = %d\n", err);
      return (err);
    }

  DPRINTF(("init_echo: setup\n"));

  pktsk.tskatr = TA_HLNG;
  pktsk.startaddr = echo_server;
  pktsk.itskpri = 1;
  pktsk.stksz = PAGE_SIZE * 2;
  pktsk.addrmap = NULL;
  err = new_task (&pktsk, &taskid, TRUE);
  if (err != E_OK)
    {
      printf ("cannot create task for echo. err = %d\n", err);
      return (err);
    }
  printf ("echo: TASK ID = %d\n", taskid);
  return (E_OK);
}

static void
echo_server (void)
{
  T_IO_REQUEST	rcv_packet;
  T_IO_RESPONSE	res_packet;
  ER		err;
  
  printf ("ECHO: server start.\n");
  for (;;)
    {
      err = get_ioreq (deviceid, &rcv_packet);
      if (err == E_OK)
	{
	  printf ("ECHO: Receive request; command = %d\n", rcv_packet.command);
	  /* ޥɲ¹Ԥ */
	  switch (rcv_packet.command)
	    {
	      /* IO_NULL, IO_OPEN, IO_CLOSE ˤĤƤϲ⤷ʤ */
	    case IO_NULL:
	    case IO_OPEN:
	    case IO_CLOSE:
	      res_packet.stat = E_OK;
	      break;
	      
	    case IO_READ:
	      res_packet.stat = E_OK;
	      break;

	    case IO_WRITE:
	      {
		W	i;

		printf ("ECHO: write size = %d\n", rcv_packet.s.write_pack.size);
		for (i = 0; i < rcv_packet.s.write_pack.size; i++)
		  {
		    putchar (((B *)(rcv_packet.s.write_pack.bufp))[i]);
		  }
	      }
	      res_packet.stat = E_OK;
	      break;

	    case IO_STAT:
	      res_packet.stat = E_OK;
	      break;

	    case IO_CONTROL:
	      res_packet.stat = E_OK;
	      break;

	    default:
	      printf ("ECHO: paramater error\n");
	      res_packet.stat = E_PAR;
	      break;
	    }
	}
      
      put_res (deviceid, &rcv_packet, &res_packet);
    }
}

