/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* io.c --- ǥХ IO ˴ؤ륳ȥ륿
 *
 * ؿ
 *	init_io 	ɡϥǥХǽν
 *	def_dev 	ǥХϿ
 *	get_ioport 	ǥХѤΥåݡȤγ
 *	io_request 	ǥХФ׵
 *	io_response 	Ʊ⡼ɤΥǥХϤΤȤˣɣϤΥ쥹
 *			ݥ󥹤Ȥ
 *
 *
 *
 */

#include "itron.h"
#include "errno.h"
#include "task.h"
#include "misc.h"
#include "func.h"
#include "interrupt.h"
#include "../h/message.h"
#include "../io/io.h"

#define MAX_QUEUE	10


/**********************************************************************
 * io_device ¤
 *
 */
struct io_device
{
  ID			id;
  ID			portid;		/* IO ǥХإå */
					/* 뤿Υåݡ ID */
  IO_TYPE		type;
  B			name[MAX_DEVICE_NAME];
};

struct io_device	device_table[MAX_DEVICE];

static ID	get_ioport (void);



/*************************************************************************
 * init_io --- ɡϥǥХǽν
 *
 * 
 *	ʤ
 *
 * ֤͡
 *	顼ֹ
 *
 * ǽ
 *	ǥХơ֥ν
 *
 */
ER
init_io (void)
{
   W	i;

  for (i = 0; i < MAX_DEVICE; i++)
    {
      device_table[i].id = UNDEF_DEVICE;
    }
  return (E_OK);
}

/************************************************************************
 * def_dev -- ǥХϿ
 *
 * 
 *	name	ǥХ̾
 *	type	ǥХ
 *	id	ǥХ ID 
 *	rid	ǥХ ID (֤)
 *
 * ֤͡
 *	顼ֹ
 *
 * ǽ
 *	
 *
 *
 */
ER
def_dev (B *name, IO_TYPE type, ID id, ID *rid)
{
  W	i;
  ID	port;

  if (id == ANY_DEVICE)
    {
      for (i = 0; i < MAX_DEVICE; i++)
	{
	  if (device_table[i].id == UNDEF_DEVICE)
	    {
	      id = i;
	      break;
	    }
	}
      if (id == ANY_DEVICE)
	return (E_NOMEM);
    }

  if (device_table[id].id != UNDEF_DEVICE)
    return (E_ID);

  port = get_ioport ();
  if (port <= 0)
    {
      return (E_NOMEM);
    }
  device_table[id].id   = id;
  device_table[id].type = type;
  device_table[id].portid = port;
  bcopy (name, device_table[id].name, strlen (name) + 1);
  *rid = id;

  return (E_OK);
}


/************************************************************************
 * ref_dev -- ǥХλ
 *
 * 
 *	name	ǥХ̾
 *	type	ǥХ
 *	rid	ǥХ ID (֤)
 *
 * ֤͡
 *	顼ֹ
 *	E_PAR	ǥХפ
 *	E_OBJ	ꤵ줿ǥХ¸ߤʤ
 *
 * ǽ
 *	ǥХ̾ȥǥХפǥХ ID ֤
 *
 *
 */
ER
ref_dev (B *name, IO_TYPE type, ID *rid)
{
  W	i;

  if ((type != CHAR) && (type != BLOCK))
    {
      return (E_PAR);
    }

  for (i = 0; i < MAX_DEVICE; i++)
    {
      if (device_table[i].id != UNDEF_DEVICE)
	{
	  if ((strncmp (name, device_table[i].name, MAX_DEVICE_NAME) == 0) &&
	      (type == device_table[i].type))
	    {
	      *rid = device_table[i].id;
	      return (E_OK);
	    }
	}
    }

  return (E_OBJ);
}


/***********************************************************************
 * get_ioport --- ǥХѤΥåݡȤγ
 *
 * 
 *	ʤ
 *
 * ֤͡
 *		ǥХѤΥåݡ ID
 *	۾	NULL (0)
 *
 * ǽ
 *	ǥХѤΥåХåեݡȤ򥢥Ȥ롣
 *	ITRON ΥåХåեˤϥåλ꤬ɬפ
 *      åϡT_IO_REQUESTQ Ȥ
 *	ʤХåեȤ å 10 ʬݤ
 */
static ID
get_ioport (void)
{
  W		id;
  T_CMBF	pk_cmbf;
  ER		err;

  pk_cmbf.mbfatr = TA_TFIFO;
  pk_cmbf.bufsz = sizeof (T_IO_REQUEST) * MAX_QUEUE;
  pk_cmbf.maxmsz = sizeof (T_IO_REQUEST);
  for (id = MIN_USERMBFID; id <= MAX_USERMBFID; id++)
    {
      err = cre_mbf (id, &pk_cmbf);
      if (err == E_OK)		/* åݡȤݤǤ*/
	{
	  break;
	}
      else if (err != E_OBJ)	/*  ID ʳΥ顼Ǽ: 顼 */
	{			/*  ꥿			      */
	  return (NULL);
	}
    }

  if (id > MAX_USERMBFID)
    {
      return (NULL);
    }
  return (id);
}


/*************************************************************************
 * get_req --- ǥХɥ饤¦ǤΥåդ
 *
 * 
 *	device
 *	req
 *
 * ֤͡
 *	顼ֹ
 *
 * ǽ
 *
 *
 */
ER
get_ioreq (ID device, T_IO_REQUEST *req)
{
  ER	err;
  INT		rsize;

  if ((device < MIN_DEVID) || (device > MAX_DEVID))
    {
      return (E_ID);
    }

  if (device_table[device].id == UNDEF_DEVICE)
    {
      return (E_ID);
    }

  err = rcv_mbf ((VP)req, &rsize, device_table[device].portid);
  if (err != E_OK)
    {
      return (err);
    }
  return (E_OK);
}


/*************************************************************************
 *
 *
 *
 *
 */
ER
put_res (ID device, T_IO_REQUEST *req, T_IO_RESPONSE *res)
{
  ER	err;

  err = snd_mbf (req->resport, sizeof (T_IO_RESPONSE), res);
  return (err);
}



/*************************************************************************
 * io_request --- ǥХФ׵
 *
 * 
 *	device	׵ǥХΣɣ
 *	req	׵ѥå
 *	res	ѥå (Ʊ⡼ɤΤȤˤϻѤʤ)
 *	mode	Ʊ/Ʊ⡼ɤλ
 *		IO_SYNC		Ʊ⡼
 *		IO_ASYNC	Ʊ⡼
 *
 * ֤͡
 *	顼ֹ桧	Υ顼ֹϥǥХ׵Ǥ
 *			ɤΤ餻ΤǡɡϽΤ
 *			ޤǤɤϼѥåȤ򸫤뤷
 *			ʤ
 *	E_OK	ｪλ
 *
 * ǽ
 *	׵ѥåȤ˻ꤵ줿ǥХФơ׵롣
 *	
 *
 */
ER
io_request (ID device, T_IO_REQUEST *req, T_IO_RESPONSE *res, W mode)
{
  ID	res_port;
  ER	err;
  INT	size;

  res_port = req->resport;
  printf ("io_request: command = %d\n", req->command);
  err = snd_mbf (device_table[device].portid, sizeof (T_IO_REQUEST), req);
  if (err != E_OK)		/* å˼ */
    {
      return (err);
    }

  if (mode == IO_SYNC)	/* Ʊ⡼ɤλ쥹ݥ󥹤֤ΤԤ */
    {
      err = rcv_mbf (&req, &size, res_port);
      if (err != E_OK)
	{
	  return (err);
	}
      if (size != sizeof (T_IO_RESPONSE))
	{
	  return (E_OBJ);
	}
    }

  return (E_OK);
}


/*************************************************************************
 * io_response ---	Ʊ⡼ɤΥǥХϤΤȤˣɣϤΥ쥹
 *			ݥ󥹤Ȥ
 *
 */
ER
io_response (ID device, T_IO_REQUEST *req, T_IO_RESPONSE *res)
{
  ER	err;
  INT	size;

  err = rcv_mbf (&req, &size, req->resport);
  if (err != E_OK)
    {
      return (err);
    }
  if (size != sizeof (T_IO_RESPONSE))
    {
      return (E_OBJ);
    }
  return (E_OK);
}
