/*

B-Free Project ʪ GNU Generic PUBLIC LICENSE ˽ޤ

GNU GENERAL PUBLIC LICENSE
Version 2, June 1991

(C) B-Free Project.

*/
/* console.c --- 󥽡ؤϥ⥸塼
 *
 *
 * 󥽡ؤϤӽϤԤ
 *
 * ʤƤ륳󥽡ϴؿϡITRON ٥Τᡢ
 * ؤǤϡ̤ΥǥХɥ饤ФϤԤޤITRON νϤ⡢
 * ؤǥХɥ饤Ф𤷤ƹԤδؿѤΤϡ
 * Ω夲ľǤ롣
 *
 *
 */

#include "itron.h"
#include "errno.h"
#include "func.h"
#include "misc.h"

/*	ȥӥ塼Ȥ
 */
#define NORM_ATTR	0x1e		/* ̾ʸ 			*/
#define MAX_WIDTH	79
#define MAX_HEIGHT	24

#define TEXT_VRAM_ADDR	0x800A0000	/* TEXT VRAM Υɥ쥹		*/
#define TEXT_VRAM_SIZE	2000

#define GDC_STAT	0x0060
#define GDC_COMMAND	0x0062

#define CURSOR_POS(x,y)		(x + y * 80)

static W	mydevid;

/***********************************************************************
 * position --- ־
 *
 */
struct position
{
  W	x;
  W	y;
};

static	struct position	cursor;


static void	set_cursor_pos (W x, W y);
static void	inc_cursor (W count);
static void	write_vram (W x, W y, W ch, W attr);
static void	write_kanji_vram (W x, W y, UW kanji, W attr);
static void	scroll_up (void);

/*************************************************************************
 * simple_init_console 
 *
 * 
 *
 * ͡
 *
 * 
 *
 */
void
simple_init_console (void)
{
  console_clear ();
}

/*************************************************************************
 * init_crt --- CRT ν
 *
 * 	ʤ
 *
 * ͡	󥽡ǥХΥǥХ
 *
 * 	󥽡ǥХ(̤򥯥ꥢ)
 *		ݥ (cursor) 롣
 *		ɥ饤оƤӽФؿ֤
 *
 * ա	ɥ饤оϡ餫 GLOBAL ȤƤ뤬
 *		ɥ饤̾ϡȯĶδɤ TRON ɤ
 *		ʤᡢδؿ TRON ɤѴ롣
 *
 */
BOOL
init_crt (W id)
{
/*
  console_clear ();
  cursor.x = 0;
  cursor.y = 0;
  set_cursor_pos (cursor.x, cursor.y);
*/
/*  string_shift_to_tron (device_table[id].name); */
  mydevid = id;
  return (TRUE);
}

/************************************************************************
 * intr_crt
 */
W
intr_crt ()
{
}

/*************************************************************************
 * putchar --- ʸ; ͥΥӥ롼
 *
 *
 * 	ch	Ϥʸ (TRON )
 *
 * ͡	ʤ
 *
 * 	write_vram ƤӽФVRAM ˣʸϤ롣
 *		δؿϡͥ뤫åϤˤѤ롣
 *		Τᡢδؿ GLOBAL ȤƤ롣
 *
 *
 * ա	δؿϡϤǤʸɤåƤʤ
 *		ϤǤʤʸꤵ줿Ǥ⡢VRAM ˽񤭹⤦Ȥ롣
 *
 */
void
putchar (TCODE ch)
{
  TCODE	c;
  static B before_ch;

  dis_int ();
#ifdef notdef
  if ((ch >= 0x80) && (ch <= 0xff) && (before_ch == 0))
    {
      before_ch = ch;
      return;
    }
  else if (before_ch)
    {
      ch = (before_ch << 8) | ch;
      write_kanji_vram (cursor.x, cursor.y, c, NORM_ATTR);
      inc_cursor (2);
      before_ch = 0;
      return;
    }
#endif /* notdef */

  switch (ch)
    {
    default:
#ifdef notdef
      if (ch & 0xFF00)
	{
	  c = halfword_swap (ch);
	  write_kanji_vram (cursor.x, cursor.y, c, NORM_ATTR);
	  inc_cursor (2);
	}
      else
	{
	  write_vram (cursor.x, cursor.y, ch, NORM_ATTR);
	  inc_cursor (1);
	}
#else
      write_vram (cursor.x, cursor.y, ch, NORM_ATTR);
      inc_cursor (1);
#endif /* notdef */
      break;

    case '\n':
      write_cr ();
      break;

    case '\t':
      write_tab ();
      break;
    }
  ena_int ();
}

/*************************************************************************
 * putchar_tron --- ʸ; ͥΥӥ롼
 *
 *
 * 	ch	Ϥʸ (TRON )
 *
 * ͡	ʤ
 *
 * 	write_vram ƤӽФVRAM ˣʸϤ롣
 *		δؿϡͥ뤫åϤˤѤ롣
 *		Τᡢδؿ GLOBAL ȤƤ롣
 *
 *
 * ա	δؿϡϤǤʸɤåƤʤ
 *		ϤǤʤʸꤵ줿Ǥ⡢VRAM ˽񤭹⤦Ȥ롣
 *
 */
void
putchar_tron (TCODE ch)
{
  TCODE	c;

  switch (ch)
    {
    default:
      if (ch & 0xFF00)
	{
	  c = halfword_swap (ch);
	  write_kanji_vram (cursor.x, cursor.y, c, NORM_ATTR);
	  inc_cursor (2);
	}
      else
	{
	  write_vram (cursor.x, cursor.y, ch, NORM_ATTR);
	  inc_cursor (1);
	}
      break;

    case '\n':
      write_cr ();
      break;

    case '\t':
      write_tab ();
      break;
    }
}

/*************************************************************************
 * inc_cursor --- ʤ롣
 *
 * 	count	ΰư
 *
 * ͡	ʤ
 *
 * 	ꤷ̤ʤ(count ϡ2Ǥ)
 *		⤷뤬̤Ϥߤϡ򼡤ιԤ
 *		ʤ롣
 *		˰ֲιԤˤˤϡʾ岼ιԤˤʤΤǡ
 *		륢åפ롣
 *
 */
static void
inc_cursor (W count)
{
  cursor.x += count;
  if (cursor.x >= MAX_WIDTH)
    {
      cursor.y++;
      if (cursor.y >= MAX_HEIGHT)
	{
	  scroll_up ();
	  cursor.y = MAX_HEIGHT;
	}
      cursor.x = 0;
    }
  set_cursor_pos (cursor.x, cursor.y);
}

/*************************************************************************
 * write_cr --- Ԥ
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	򼡤ιԤƬ˰ư롣
 *		⤷Ǥ˹ԤֺǸʤСΤ򥹥뤹롣
 *
 */
void
write_cr (void)
{
  cursor.x = 0;
  if (cursor.y >= MAX_HEIGHT)
    {
      scroll_up ();
    }
  else
    {
      cursor.y++;
    }
  set_cursor_pos (cursor.x, cursor.y);
}

/*************************************************************************
 * write_tab --- ֤Ϥ롣
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	֤Ϥ롣
 *
 */
void
write_tab ()
{
  W	tmp;

  if (cursor.x < MAX_WIDTH)
    {
      tmp = ROUNDUP (cursor.x + 1, 8) - 1;
      while (cursor.x < tmp)
	{
	  write_vram (cursor.x, cursor.y, ' ', 0xe1);
	  cursor.x++;
	}
    }
}

/*************************************************************************
 * scroll_up --- Τ򥹥륢åפ
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	Τԥ뤹롣
 *
 */
static void
scroll_up (void)  
{
  UH	*addr;
  W		i;
  
  addr = (unsigned short *)TEXT_VRAM_ADDR;
  for (i = 0; i < TEXT_VRAM_SIZE - 80; i++)
    {
      addr[i] = addr[i + 80];
    }
  for (i = 0; i <= MAX_WIDTH; i++)
    {
      write_vram (i, MAX_HEIGHT, ' ', 0xe1);
    }
}

/*************************************************************************
 * console_clear --- 󥽡򥯥ꥢ롣
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	󥽡ΤϤϤޤǤʸ롣
 *
 */
void
console_clear (void)
{
  W	x, y;
  
  for (y = 0; y <= MAX_HEIGHT; y++)
    for (x = 0; x <= MAX_WIDTH; x++)
      {
	write_vram (x, y, ' ', 0xE1);
      }
  cursor.x = cursor.y = 0;
  set_cursor_pos (cursor.x, cursor.y);
}

/*************************************************************************
 * write_vram --- VRAM ʸ񤭹
 *
 * 	x, y	ɸ
 *		ch	Ϥʸ
 *		attr	ʸ°
 *
 * ͡	ʤ
 *
 * 	 x, y ǻꤷɸʸ񤭹.
 *		δؿϡASCII ʸѤˤʤäƤ롣
 *
 *
 * ա	ߡattr ̵뤷Ƥ롣
 *
 */
static void
write_vram (W x, W y, W ch, W attr)
{
  short	*addr;
  short *attr_addr;
  
  addr = (short *)TEXT_VRAM_ADDR;
  addr [CURSOR_POS (x, y)] = ch & 0x00ff;
}

/*************************************************************************
 * write_kanji_vram --- ֣ңͤ˴ʸ񤭹.
 *
 * 	x, y	ɸ
 *		kanji	Ϥʸ
 *		attr	ʸ°
 *
 * ͡	ʤ
 *
 * 	 x, y ǻꤷɸʸ񤭹.
 *		δؿϡTRON ʸѤˤʤäƤ롣
 *
 *
 * ա	ߡattr ̵뤷Ƥ롣
 *
 */
static void
write_kanji_vram (W x, W y, UW kanji, W attr)
{
  UH	*addr;
  H	*attr_addr;
  UH	 first, second;

  first = ((kanji >> 8) & 0xff) - 0x20;
  second = (kanji << 8) & 0xff00;

  addr = (unsigned short *)TEXT_VRAM_ADDR;
  addr [CURSOR_POS (x, y)] = second | first;
  addr [CURSOR_POS (x + 1, y)] = second | (first | 0x80);
}

/*************************************************************************
 * set_cursor_pos --- ֤.
 *
 * 	x, y	ɸ
 *
 * ͡	ʤ
 *
 * 	ꤷɸ˥ư롣
 *
 */
static void
set_cursor_pos (W x, W y)
{
  W	adr;
  
  dis_int ();
  adr = x + (y * 80);
  while ((inb (GDC_STAT) & 0x04) == 0)
    ;
  outb (GDC_COMMAND, 0x49);
  outb (GDC_STAT, adr & 0xff);
  outb (GDC_STAT, (adr >> 8) & 0xff);
  ena_int ();
}

/*************************************************************************
 * delete_key --- ʸʸõ롣
 *
 * 	ʤ
 *
 * ͡	ʤ
 *
 * 	ߥ뤬ԤκǸʸõ롣
 *
 */
void
delete_key (void)
{
  if (cursor.x > 0)
    {
      cursor.x--;
      write_vram (cursor.x, cursor.y, ' ', 0x1f);
      set_cursor_pos (cursor.x, cursor.y);
    }
}


/*************************************************************************
 * move_cursol --- ꤷ֤˰ư
 *
 * 	x
 *		y
 *
 * ͡	TRUE
 *		FALSE
 *
 * 	ѿ cursor ˤϡ֤äƤ롣
 *		move_cursol() ϡcursor ͤѹ롣
 *		ˡɽ֤򿷤 cursor ΰ֤ѹ롣
 *
 */
W
move_cursol (int x, int y)
{
  if ((x >= 0) && (x < 80) &&
      (y >= 0) && (y < 25))
    {
      cursor.x = x;
      cursor.y = y;
      set_cursor_pos (cursor.x, cursor.y);
      return (TRUE);
    }
  else
    {
      return (FALSE);
    }
}
