/*!
  \file
  \brief PPM z̍쐬

  \author Satofumi KAMIMURA

  $Id$
*/

#include "CreatePpmArrayFromSurface.h"


static char* createFrom8bit(const SDL_Surface* surface) {

  char* buffer = new char[surface->w * surface->h * 4];
  char* p = buffer;
  for (int y = 0; y < surface->h; ++y) {
    for (int x = 0; x < surface->w; ++x) {
      int pixel_index = y * surface->w + x;
      Uint8 index = *(((Uint8 *)surface->pixels) + pixel_index);
      SDL_Color color = surface->format->palette->colors[index];

      *(p++) = color.r;
      *(p++) = color.g;
      *(p++) = color.b;
      *(p++) = 0xff;
    }
  }
  return buffer;
}


static char* createFromTrueColor(const SDL_Surface* surface) {

  char* buffer = new char[surface->w * surface->h * 4];
  char* p = buffer;
  const SDL_PixelFormat* format = surface->format;
  Uint8* pixel_color = (Uint8 *)surface->pixels;
  for (int y = 0; y < surface->h; ++y) {
    for (int x = 0; x < surface->w; ++x) {

      Uint32 pixel = 0;
      for (int i = 0; i < format->BytesPerPixel; ++i) {
        pixel <<= 8;
        pixel |= *pixel_color;
        ++pixel_color;
      }
      for (int i = 0; i < 4 - format->BytesPerPixel; ++i) {
        pixel <<= 8;
      }
#if SDL_BYTEORDER == SDL_LIL_ENDIAN
      Uint8 byte3 = pixel;
      Uint8 byte2 = pixel >> 8;
      Uint8 byte1 = pixel >> 16;
      Uint8 byte0 = pixel >> 24;
      Uint32 converted_pixel =
        (byte3 << 24) | (byte2 << 16) | (byte1 << 8) | byte0;
      pixel = converted_pixel;
#endif

      Uint8 red, green, blue;
      SDL_GetRGB(pixel, surface->format, &red, &green, &blue);

      *(p++) = red;
      *(p++) = green;
      *(p++) = blue;
      *(p++) = 0xff;
    }
  }
  return buffer;
}


char* beego::createPpmArray(const SDL_Surface* surface,
                            int* width, int* height) {

  *width = surface->w;
  *height = surface->h;

  // tH[}bg̔
  SDL_PixelFormat* format = surface->format;
  return (format->BitsPerPixel == 8)
    ? createFrom8bit(surface) : createFromTrueColor(surface);
}
