/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * playback.c
 * Copyright (C) Koichi Akabe 2009 <mail@vbkaisetsu.com>
 * 
 * playback.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * playback.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>
#include "SDL/SDL.h"
#include "libavcodec/avcodec.h"
#include "libavformat/avformat.h"
#include "libswscale/swscale.h"
#include "bdcdec/bdcdec.h"
#include "bdplayback.h"
#include "m2ts/m2ts.h"

#define	 NUM_SOUNDS			2

volatile int timer_flag;
SDL_Surface *scr;
SDL_AudioSpec s_fmt;
volatile int tracksaver;
AVFrame *pFrameBGR[256];
unsigned char *buffer[256];
volatile int viewframe, setframe;
volatile int viewsleep;

int bdpb_setMovie(struct BD_MovieData *mdata, char disc_root[], int playlist_num)
{
	FILE *fp, *fp2;
	char mplsfile[512];
	char m2tsfile[512];
	char tmpfile[512];
	char *mplsdata;
	fpos_t fpos;
	long fs;
	long p;
	int i, j, k;
	long playlist_start_p;
	long playlist_mark_start_p;
	long extention_start_p;
	sprintf(mplsfile, "%s/BDMV/PLAYLIST/%05d.mpls", disc_root, playlist_num);
	memcpy(mdata->disc_root, disc_root, 512);
	// Analyzing Playlist
	fp = fopen(mplsfile, "rb");
	if(fp == 0)
		return -1;
	fseek(fp, 0, SEEK_END);
	fgetpos(fp, &fpos);
	fs = fpos.__pos;
	mplsdata = malloc(fs * sizeof(char));
	fseek(fp, 0, SEEK_SET);
	if(fread(mplsdata, sizeof(char), fs, fp) != fs)
	{
		printf("can't read\n");
	}
	// start with " M, P, L, S "
	if(mplsdata[0] != 0x4d || mplsdata[1] != 0x50 || mplsdata[2] != 0x4c || mplsdata[3] != 0x53)
	{
		return -1;
	}
	
	// get mpls version
	memcpy(mdata->pl.version, mplsdata + 4, 4);
	
	// get data start position
	playlist_start_p  = (unsigned char)mplsdata[0x08] << 24;
	playlist_start_p |= (unsigned char)mplsdata[0x09] << 16;
	playlist_start_p |= (unsigned char)mplsdata[0x0a] << 8;
	playlist_start_p |= (unsigned char)mplsdata[0x0b];
	playlist_mark_start_p  = (unsigned char)mplsdata[0x0c] << 24;
	playlist_mark_start_p |= (unsigned char)mplsdata[0x0d] << 16;
	playlist_mark_start_p |= (unsigned char)mplsdata[0x0e] << 8;
	playlist_mark_start_p |= (unsigned char)mplsdata[0x0f];
	extention_start_p  = (unsigned char)mplsdata[0x10] << 24;
	extention_start_p |= (unsigned char)mplsdata[0x11] << 16;
	extention_start_p |= (unsigned char)mplsdata[0x12] << 8;
	extention_start_p |= (unsigned char)mplsdata[0x13];
	
	// appInfoPlayList
	mdata->pl.appinf_pl_type = mplsdata[0x2d];
	mdata->pl.appinf_pl_count  = (unsigned char)mplsdata[0x2e] << 8;
	mdata->pl.appinf_pl_count |= (unsigned char)mplsdata[0x2f];
	
	mdata->pl.appinf_pl_uomask  = (unsigned char)mplsdata[0x30] << 24;
	mdata->pl.appinf_pl_uomask |= (unsigned char)mplsdata[0x31] << 16;
	mdata->pl.appinf_pl_uomask |= (unsigned char)mplsdata[0x32] << 8;
	mdata->pl.appinf_pl_uomask |= (unsigned char)mplsdata[0x33];
	mdata->pl.appinf_pl_uomask2  = (unsigned char)mplsdata[0x34] << 24;
	mdata->pl.appinf_pl_uomask2 |= (unsigned char)mplsdata[0x35] << 16;
	mdata->pl.appinf_pl_uomask2 |= (unsigned char)mplsdata[0x36] << 8;
	mdata->pl.appinf_pl_uomask2 |= (unsigned char)mplsdata[0x37];
	
	mdata->pl.appinf_pl_flags = mplsdata[0x38];
	
	// PlayListItem
	mdata->pl.playlength  = (unsigned char)mplsdata[0x40] << 8;
	mdata->pl.playlength |= (unsigned char)mplsdata[0x41];
	mdata->pl.sublength  = (unsigned char)mplsdata[0x42] << 8;
	mdata->pl.sublength |= (unsigned char)mplsdata[0x43];
	
	mdata->pl.clipname = malloc(mdata->pl.playlength * sizeof(char**));
	mdata->pl.codecId = malloc(mdata->pl.playlength * sizeof(char**));
	mdata->pl.multiangle = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.c_condition = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.stcId = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.intime = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.outtime = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.pl_uomask = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.pl_uomask2 = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.pl_RAflag = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.stillmode = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.stilltime = malloc(mdata->pl.playlength * sizeof(short));
	mdata->pl.angleEntries = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.angleDiffAudio = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.angleSeamlessChange = malloc(mdata->pl.playlength * sizeof(char));
	
	mdata->pl.p_vs_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.p_as_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.pgtxs_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.igs_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.s_vs_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.s_as_length = malloc(mdata->pl.playlength * sizeof(char));
	mdata->pl.pip_pgtxs_length = malloc(mdata->pl.playlength * sizeof(char));
	
	mdata->pl.vs_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.vs_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.vs_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.vs_format = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.vs_framerate = malloc(mdata->pl.playlength * sizeof(char*));
	
	mdata->pl.as_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.as_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.as_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.as_ptype = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.as_samplerate = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.as_lang = malloc(mdata->pl.playlength * sizeof(char**));
	
	mdata->pl.s_vs_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_vs_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_vs_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_vs_format = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_vs_framerate = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_vs_sa_ref_len = malloc(mdata->pl.playlength * sizeof(int*));
	mdata->pl.s_vs_sa_ref = malloc(mdata->pl.playlength * sizeof(char**));
	mdata->pl.s_vs_pip_ref_len = malloc(mdata->pl.playlength * sizeof(int*));
	mdata->pl.s_vs_pip_ref = malloc(mdata->pl.playlength * sizeof(char**));

	mdata->pl.s_as_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_as_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_as_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_as_ptype = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_as_samplerate = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.s_as_lang = malloc(mdata->pl.playlength * sizeof(char**));
	mdata->pl.s_as_pa_ref_len = malloc(mdata->pl.playlength * sizeof(int*));
	mdata->pl.s_as_pa_ref = malloc(mdata->pl.playlength * sizeof(char**));
	
	mdata->pl.pgtxs_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.pgtxs_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.pgtxs_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.pgtxs_lang = malloc(mdata->pl.playlength * sizeof(char**));
	
	mdata->pl.igs_stream_t = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.igs_pid = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.igs_coding = malloc(mdata->pl.playlength * sizeof(char*));
	mdata->pl.igs_lang = malloc(mdata->pl.playlength * sizeof(char**));
	
	mdata->pl.sub_clipname = malloc(mdata->pl.sublength * sizeof(char***));
	mdata->pl.sub_codecId = malloc(mdata->pl.sublength * sizeof(char***));
	mdata->pl.sub_stcId = malloc(mdata->pl.sublength * sizeof(char**));
	mdata->pl.sub_type = malloc(mdata->pl.sublength * sizeof(char));
	mdata->pl.sub_isrepeat = malloc(mdata->pl.sublength * sizeof(char));
	mdata->pl.sub_length = malloc(mdata->pl.sublength * sizeof(char));
	mdata->pl.sub_c_condition = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_multiClip = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_intime = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_outtime = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_syncPlayID = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_startPTS = malloc(mdata->pl.sublength * sizeof(char*));
	mdata->pl.sub_clipEntries = malloc(mdata->pl.sublength * sizeof(char*));
	
	for(i = 0; i < mdata->pl.playlength; i++)
	{
		mdata->pl.clipname[i] = malloc(256 * sizeof(char*));
		mdata->pl.codecId[i] = malloc(256 * sizeof(char*));
		mdata->pl.stcId[i] = malloc(256 * sizeof(char));
	}
	p = 0x44;
	
	for(i = 0; i < mdata->pl.playlength; i++)
	{
		mdata->pl.clipname[i] = malloc(256 * sizeof(char*));
		mdata->pl.codecId[i] = malloc(256 * sizeof(char*));
		mdata->pl.stcId[i] = malloc(256 * sizeof(char));
		mdata->pl.clipname[i][0] = malloc(5 * sizeof(char));
		mdata->pl.codecId[i][0] = malloc(4 * sizeof(char));
		
		mdata->pl.clipname[i][0][0] = mplsdata[p + 0x02];
		mdata->pl.clipname[i][0][1] = mplsdata[p + 0x03];
		mdata->pl.clipname[i][0][2] = mplsdata[p + 0x04];
		mdata->pl.clipname[i][0][3] = mplsdata[p + 0x05];
		mdata->pl.clipname[i][0][4] = mplsdata[p + 0x06];
		mdata->pl.codecId[i][0][0] = mplsdata[p + 0x07];
		mdata->pl.codecId[i][0][1] = mplsdata[p + 0x08];
		mdata->pl.codecId[i][0][2] = mplsdata[p + 0x09];
		mdata->pl.codecId[i][0][3] = mplsdata[p + 0x0a];
		mdata->pl.multiangle[i] = mplsdata[p + 0x0c] >> 4;
		mdata->pl.c_condition[i] = mplsdata[p + 0x0c] & 0x0f;
		mdata->pl.stcId[i][0] = mplsdata[p + 0x0d];
		mdata->pl.intime[i]  = (unsigned char)mplsdata[p + 0x0e] << 24;
		mdata->pl.intime[i] |= (unsigned char)mplsdata[p + 0x0f] << 16;
		mdata->pl.intime[i] |= (unsigned char)mplsdata[p + 0x10] << 8;
		mdata->pl.intime[i] |= (unsigned char)mplsdata[p + 0x11];
		mdata->pl.outtime[i]  = (unsigned char)mplsdata[p + 0x12] << 24;
		mdata->pl.outtime[i] |= (unsigned char)mplsdata[p + 0x13] << 16;
		mdata->pl.outtime[i] |= (unsigned char)mplsdata[p + 0x14] << 8;
		mdata->pl.outtime[i] |= (unsigned char)mplsdata[p + 0x15];
		mdata->pl.pl_uomask[i]  = (unsigned char)mplsdata[p + 0x16] << 24;
		mdata->pl.pl_uomask[i] |= (unsigned char)mplsdata[p + 0x17] << 16;
		mdata->pl.pl_uomask[i] |= (unsigned char)mplsdata[p + 0x18] << 8;
		mdata->pl.pl_uomask[i] |= (unsigned char)mplsdata[p + 0x19];
		mdata->pl.pl_uomask2[i]  = (unsigned char)mplsdata[p + 0x1a] << 24;
		mdata->pl.pl_uomask2[i] |= (unsigned char)mplsdata[p + 0x1b] << 16;
		mdata->pl.pl_uomask2[i] |= (unsigned char)mplsdata[p + 0x1c] << 8;
		mdata->pl.pl_uomask2[i] |= (unsigned char)mplsdata[p + 0x1d];
		mdata->pl.pl_RAflag[i] = mplsdata[p + 0x1e];
		mdata->pl.stillmode[i] = mplsdata[p + 0x1f];
		mdata->pl.stilltime[i]  = (unsigned char)mplsdata[p + 0x20] << 8;
		mdata->pl.stilltime[i] |= (unsigned char)mplsdata[p + 0x21];
		if(mdata->pl.multiangle[i] == 1) // Multi Angle
		{
			mdata->pl.angleEntries[i] = mplsdata[p + 0x22];
			mdata->pl.angleDiffAudio[i] = mplsdata[p + 0x23] >> 1;
			mdata->pl.angleSeamlessChange[i] = mplsdata[p + 0x23] & 0x01;
			p += 0x24;
			for(j = 1; j < mdata->pl.angleEntries[i]; j++)
			{
				mdata->pl.clipname[i][j] = malloc(5 * sizeof(char));
				mdata->pl.codecId[i][j] = malloc(4 * sizeof(char));
				mdata->pl.clipname[i][j][0] = mplsdata[p];
				mdata->pl.clipname[i][j][1] = mplsdata[p + 0x01];
				mdata->pl.clipname[i][j][2] = mplsdata[p + 0x02];
				mdata->pl.clipname[i][j][3] = mplsdata[p + 0x03];
				mdata->pl.clipname[i][j][4] = mplsdata[p + 0x04];
				mdata->pl.codecId[i][j][0] = mplsdata[p + 0x05];
				mdata->pl.codecId[i][j][1] = mplsdata[p + 0x06];
				mdata->pl.codecId[i][j][2] = mplsdata[p + 0x07];
				mdata->pl.codecId[i][j][3] = mplsdata[p + 0x08];
				mdata->pl.stcId[i][j] = mplsdata[p + 0x09];
				p += 0x0a;
			}
		}
		else
		{
			p += 0x22;
		}
		mdata->pl.p_vs_length[i] = mplsdata[p + 0x04];
		mdata->pl.p_as_length[i] = mplsdata[p + 0x05];
		mdata->pl.pgtxs_length[i] = mplsdata[p + 0x06];
		mdata->pl.igs_length[i] = mplsdata[p + 0x07];
		mdata->pl.s_vs_length[i] = mplsdata[p + 0x08];
		mdata->pl.s_as_length[i] = mplsdata[p + 0x09];
		mdata->pl.pip_pgtxs_length[i] = mplsdata[p + 0x0a];
		p += 0x10;
		
		mdata->pl.vs_stream_t[i] = malloc(mdata->pl.p_vs_length[i] * sizeof(char));
		mdata->pl.vs_pid[i] = malloc(mdata->pl.p_vs_length[i] * sizeof(char));
		mdata->pl.vs_coding[i] = malloc(mdata->pl.p_vs_length[i] * sizeof(char));
		mdata->pl.vs_format[i] = malloc(mdata->pl.p_vs_length[i] * sizeof(char));
		mdata->pl.vs_framerate[i] = malloc(mdata->pl.p_vs_length[i] * sizeof(char));
		for(j = 0; j < mdata->pl.p_vs_length[i]; j++)
		{
			mdata->pl.vs_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.vs_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.vs_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.vs_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.vs_format[i][j] = (unsigned char)mplsdata[p + 0x02] >> 4;
			mdata->pl.vs_framerate[i][j] = (unsigned char)mplsdata[p + 0x02] & 0x0f;
			p += mplsdata[p] + 1;
		}
		
		mdata->pl.as_stream_t[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char));
		mdata->pl.as_pid[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char));
		mdata->pl.as_coding[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char));
		mdata->pl.as_ptype[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char));
		mdata->pl.as_samplerate[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char));
		mdata->pl.as_lang[i] = malloc(mdata->pl.p_as_length[i] * sizeof(char*));
		for(j = 0; j < mdata->pl.p_as_length[i]; j++)
		{
			mdata->pl.as_lang[i][j] = malloc(3 * sizeof(char));
			mdata->pl.as_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.as_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.as_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.as_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.as_ptype[i][j] = (unsigned char)mplsdata[p + 0x02] >> 4;
			mdata->pl.as_samplerate[i][j] = (unsigned char)mplsdata[p + 0x02] & 0x0f;
			mdata->pl.as_lang[i][j][0] = mplsdata[p + 0x03];
			mdata->pl.as_lang[i][j][1] = mplsdata[p + 0x04];
			mdata->pl.as_lang[i][j][2] = mplsdata[p + 0x05];
			p += mplsdata[p] + 1;
		}
		
		mdata->pl.pgtxs_stream_t[i] = malloc(mdata->pl.pgtxs_length[i] * sizeof(char));
		mdata->pl.pgtxs_pid[i] = malloc(mdata->pl.pgtxs_length[i] * sizeof(char));
		mdata->pl.pgtxs_coding[i] = malloc(mdata->pl.pgtxs_length[i] * sizeof(char));
		mdata->pl.pgtxs_lang[i] = malloc(mdata->pl.pgtxs_length[i] * sizeof(char*));
		for(j = 0; j < mdata->pl.pgtxs_length[i]; j++)
		{
			mdata->pl.pgtxs_lang[i][j] = malloc(3 * sizeof(char));
			mdata->pl.pgtxs_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.pgtxs_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.pgtxs_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.pgtxs_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.pgtxs_lang[i][j][0] = mplsdata[p + 0x02];
			mdata->pl.pgtxs_lang[i][j][1] = mplsdata[p + 0x03];
			mdata->pl.pgtxs_lang[i][j][2] = mplsdata[p + 0x04];
			p += mplsdata[p] + 1;
		}
		
		mdata->pl.igs_stream_t[i] = malloc(mdata->pl.igs_length[i] * sizeof(char));
		mdata->pl.igs_pid[i] = malloc(mdata->pl.igs_length[i] * sizeof(char));
		mdata->pl.igs_coding[i] = malloc(mdata->pl.igs_length[i] * sizeof(char));
		mdata->pl.igs_lang[i] = malloc(mdata->pl.igs_length[i] * sizeof(char*));
		for(j = 0; j < mdata->pl.igs_length[i]; j++)
		{
			mdata->pl.igs_lang[i][j] = malloc(3 * sizeof(char));
			mdata->pl.igs_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.igs_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.igs_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.igs_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.igs_lang[i][j][0] = mplsdata[p + 0x02];
			mdata->pl.igs_lang[i][j][1] = mplsdata[p + 0x03];
			mdata->pl.igs_lang[i][j][2] = mplsdata[p + 0x04];
			p += mplsdata[p] + 1;
		}
		mdata->pl.s_vs_stream_t[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char));
		mdata->pl.s_vs_pid[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char));
		mdata->pl.s_vs_coding[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char));
		mdata->pl.s_vs_format[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char));
		mdata->pl.s_vs_framerate[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char));
		mdata->pl.s_vs_sa_ref_len[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(int));
		mdata->pl.s_vs_sa_ref[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char*));
		mdata->pl.s_vs_pip_ref_len[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(int));
		mdata->pl.s_vs_pip_ref[i] = malloc(mdata->pl.s_vs_length[i] * sizeof(char*));
		
		for(j = 0; j < mdata->pl.p_vs_length[i]; j++)
		{
			mdata->pl.s_vs_sa_ref[i][j] = malloc(256 * sizeof(char));
			mdata->pl.s_vs_pip_ref[i][j] = malloc(256 * sizeof(char));
			mdata->pl.s_vs_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.s_vs_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.s_vs_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.s_vs_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.s_vs_format[i][j] = (unsigned char)mplsdata[p + 0x02] >> 4;
			mdata->pl.s_vs_framerate[i][j] = (unsigned char)mplsdata[p + 0x02] & 0x0f;
			p += mplsdata[p] + 1;
			mdata->pl.s_vs_sa_ref_len[i][j] = mplsdata[p];
			p += 2;
			if(mdata->pl.s_vs_sa_ref_len[i][j] > 0)
			{
				for(k = 0; k < mdata->pl.s_vs_sa_ref_len[i][j]; k++)
				{
					mdata->pl.s_vs_sa_ref[i][j][k] = mplsdata[p++];
				}
				if(mdata->pl.s_vs_sa_ref_len[i][j] % 2 != 0)
				{
					p++;
				}
			}
			mdata->pl.s_vs_pip_ref_len[i][j] = mplsdata[p];
			p += 2;
			if(mdata->pl.s_vs_pip_ref_len[i][j] > 0)
			{
				for(k = 0; k < mdata->pl.s_vs_pip_ref_len[i][j]; k++)
				{
					mdata->pl.s_vs_pip_ref[i][j][k] = mplsdata[p++];
				}
				if(mdata->pl.s_vs_pip_ref_len[i][j] % 2 != 0)
				{
					p++;
				}
			}
		}
		mdata->pl.s_as_stream_t[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char));
		mdata->pl.s_as_pid[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char));
		mdata->pl.s_as_coding[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char));
		mdata->pl.s_as_ptype[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char));
		mdata->pl.s_as_samplerate[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char));
		mdata->pl.s_as_lang[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char*));
		mdata->pl.s_as_pa_ref_len[i] = malloc(mdata->pl.s_as_length[i] * sizeof(int));
		mdata->pl.s_as_pa_ref[i] = malloc(mdata->pl.s_as_length[i] * sizeof(char*));
		for(j = 0; j < mdata->pl.s_as_length[i]; j++)
		{
			mdata->pl.s_as_lang[i][j] = malloc(3 * sizeof(char));
			mdata->pl.s_as_stream_t[i][j] = mplsdata[p + 0x01];
			mdata->pl.s_as_pid[i][j]  = (unsigned char)mplsdata[p + 0x02] << 8;
			mdata->pl.s_as_pid[i][j] |= (unsigned char)mplsdata[p + 0x03];
			p += mplsdata[p] + 1;
			mdata->pl.s_as_coding[i][j] = mplsdata[p + 0x01];
			mdata->pl.s_as_ptype[i][j] = (unsigned char)mplsdata[p + 0x02] >> 4;
			mdata->pl.s_as_samplerate[i][j] = (unsigned char)mplsdata[p + 0x02] & 0x0f;
			mdata->pl.s_as_lang[i][j][0] = mplsdata[p + 0x03];
			mdata->pl.s_as_lang[i][j][1] = mplsdata[p + 0x04];
			mdata->pl.s_as_lang[i][j][2] = mplsdata[p + 0x05];
			p += mplsdata[p] + 1;
			mdata->pl.s_as_pa_ref_len[i][j] = mplsdata[p];
			p += 2;
			if(mdata->pl.s_as_pa_ref_len[i][j] > 0)
			{
				for(k = 0; k < mdata->pl.s_as_pa_ref_len[i][j]; k++)
				{
					mdata->pl.s_as_pa_ref[i][j][k] = mplsdata[p++];
				}
				if(mdata->pl.s_as_pa_ref_len[i][j] % 2 != 0)
				{
					p++;
				}
			}
		}
	}
	
	// SubPath
	for(i = 0; i < mdata->pl.sublength; i++)
	{
		p += 5;
		mdata->pl.sub_clipname[i] = malloc(256 * sizeof(char**));
		mdata->pl.sub_codecId[i] = malloc(256 * sizeof(char**));
		mdata->pl.sub_stcId[i] = malloc(256 * sizeof(char*));
		mdata->pl.sub_c_condition[i] = malloc(256 * sizeof(char));
		mdata->pl.sub_multiClip[i] = malloc(256 * sizeof(char));
		mdata->pl.sub_stcId[i] = malloc(256 * sizeof(char));
		mdata->pl.sub_intime[i] = malloc(256 * sizeof(long));
		mdata->pl.sub_outtime[i] = malloc(256 * sizeof(long));
		mdata->pl.sub_syncPlayID[i] = malloc(256 * sizeof(int));
		mdata->pl.sub_startPTS[i] = malloc(256 * sizeof(long));
		mdata->pl.sub_clipEntries[i] = malloc(256 * sizeof(char));
		
		mdata->pl.sub_type[i] = mplsdata[p];
		mdata->pl.sub_isrepeat[i] = mplsdata[p + 2];
		mdata->pl.sub_length[i] = mplsdata[p + 5];
		p += 8;
		for(j = 0; j < mdata->pl.sub_length[i]; j++)
		{
			mdata->pl.sub_clipname[i][j] = malloc(256 * sizeof(char*));
			mdata->pl.sub_codecId[i][j] = malloc(256 * sizeof(char*));
			mdata->pl.sub_clipname[i][j][0] = malloc(5 * sizeof(char));
			mdata->pl.sub_codecId[i][j][0] = malloc(4 * sizeof(char));
			mdata->pl.sub_stcId[i][j] = malloc(256 * sizeof(char*));
			mdata->pl.sub_clipname[i][j][0][0] = mplsdata[p + 0x02];
			mdata->pl.sub_clipname[i][j][0][1] = mplsdata[p + 0x03];
			mdata->pl.sub_clipname[i][j][0][2] = mplsdata[p + 0x04];
			mdata->pl.sub_clipname[i][j][0][3] = mplsdata[p + 0x05];
			mdata->pl.sub_clipname[i][j][0][4] = mplsdata[p + 0x06];
			mdata->pl.sub_codecId[i][j][0][0] = mplsdata[p + 0x07];
			mdata->pl.sub_codecId[i][j][0][1] = mplsdata[p + 0x08];
			mdata->pl.sub_codecId[i][j][0][2] = mplsdata[p + 0x09];
			mdata->pl.sub_codecId[i][j][0][3] = mplsdata[p + 0x0a];
			mdata->pl.sub_c_condition[i][j] = mplsdata[p + 0x0e] & 0x1e;
			mdata->pl.sub_multiClip[i][j] = mplsdata[p + 0x0e] & 0x01;
			mdata->pl.sub_stcId[i][j][0] = mplsdata[p + 0x0f];
			mdata->pl.sub_intime[i][j]  = (unsigned char)mplsdata[p + 0x10] << 24;
			mdata->pl.sub_intime[i][j] |= (unsigned char)mplsdata[p + 0x11] << 16;
			mdata->pl.sub_intime[i][j] |= (unsigned char)mplsdata[p + 0x12] << 8;
			mdata->pl.sub_intime[i][j] |= (unsigned char)mplsdata[p + 0x13];
			mdata->pl.sub_outtime[i][j]  = (unsigned char)mplsdata[p + 0x14] << 24;
			mdata->pl.sub_outtime[i][j] |= (unsigned char)mplsdata[p + 0x15] << 16;
			mdata->pl.sub_outtime[i][j] |= (unsigned char)mplsdata[p + 0x16] << 8;
			mdata->pl.sub_outtime[i][j] |= (unsigned char)mplsdata[p + 0x17];
			mdata->pl.sub_syncPlayID[i][j]  = (unsigned char)mplsdata[p + 0x18] << 8;
			mdata->pl.sub_syncPlayID[i][j] |= (unsigned char)mplsdata[p + 0x19];
			mdata->pl.sub_startPTS[i][j]  = (unsigned char)mplsdata[p + 0x20] << 24;
			mdata->pl.sub_startPTS[i][j] |= (unsigned char)mplsdata[p + 0x21] << 16;
			mdata->pl.sub_startPTS[i][j] |= (unsigned char)mplsdata[p + 0x22] << 8;
			mdata->pl.sub_startPTS[i][j] |= (unsigned char)mplsdata[p + 0x23];
			if(mdata->pl.sub_multiClip[i][j] == 1) // Multi Clip Entries
			{
				mdata->pl.sub_clipEntries[i][j] = mplsdata[p + 0x22];
				p += 0x24;
				for(k = 1; k < mdata->pl.sub_clipEntries[i][j]; k++)
				{
					mdata->pl.sub_clipname[i][j][k] = malloc(5 * sizeof(char));
					mdata->pl.sub_codecId[i][j][k] = malloc(4 * sizeof(char));
					mdata->pl.sub_clipname[i][j][k][0] = mplsdata[p];
					mdata->pl.sub_clipname[i][j][k][1] = mplsdata[p + 0x01];
					mdata->pl.sub_clipname[i][j][k][2] = mplsdata[p + 0x02];
					mdata->pl.sub_clipname[i][j][k][3] = mplsdata[p + 0x03];
					mdata->pl.sub_clipname[i][j][k][4] = mplsdata[p + 0x04];
					mdata->pl.sub_codecId[i][j][k][0] = mplsdata[p + 0x05];
					mdata->pl.sub_codecId[i][j][k][1] = mplsdata[p + 0x06];
					mdata->pl.sub_codecId[i][j][k][2] = mplsdata[p + 0x07];
					mdata->pl.sub_codecId[i][j][k][3] = mplsdata[p + 0x08];
					mdata->pl.sub_stcId[i][j][k] = mplsdata[p + 0x09];
					p += 0x0a;
				}
			}
			else
			{
				p += 0x24;
			}
		}
	}
	
	// Mark
	p = playlist_mark_start_p;
	mdata->pl.mark_length  = mplsdata[p + 0x04] << 8;
	mdata->pl.mark_length  = mplsdata[p + 0x05];
	mdata->pl.mark_type = malloc(mdata->pl.mark_length * sizeof(char));
	mdata->pl.mark_idRef = malloc(mdata->pl.mark_length * sizeof(short));
	mdata->pl.mark_timestamp = malloc(mdata->pl.mark_length * sizeof(long));
	mdata->pl.mark_entry_es_pid = malloc(mdata->pl.mark_length * sizeof(short));
	mdata->pl.mark_duration = malloc(mdata->pl.mark_length * sizeof(long));
	p += 6;
	for(i = 0; i < mdata->pl.mark_length; i++)
	{
		mdata->pl.mark_type[i]  = mplsdata[p + 0x01];
		mdata->pl.mark_idRef[i]  = (unsigned char)mplsdata[p + 0x02] << 8;
		mdata->pl.mark_idRef[i] |= (unsigned char)mplsdata[p + 0x03];
		mdata->pl.mark_timestamp[i]  = (unsigned char)mplsdata[p + 0x04] << 24;
		mdata->pl.mark_timestamp[i] |= (unsigned char)mplsdata[p + 0x05] << 16;
		mdata->pl.mark_timestamp[i] |= (unsigned char)mplsdata[p + 0x06] << 8;
		mdata->pl.mark_timestamp[i] |= (unsigned char)mplsdata[p + 0x07];
		mdata->pl.mark_entry_es_pid[i]  = (unsigned char)mplsdata[p + 0x08] << 8;
		mdata->pl.mark_entry_es_pid[i] |= (unsigned char)mplsdata[p + 0x09];
		mdata->pl.mark_duration[i]  = (unsigned char)mplsdata[p + 0x0a] << 24;
		mdata->pl.mark_duration[i] |= (unsigned char)mplsdata[p + 0x0b] << 16;
		mdata->pl.mark_duration[i] |= (unsigned char)mplsdata[p + 0x0c] << 8;
		mdata->pl.mark_duration[i] |= (unsigned char)mplsdata[p + 0x0d];
		p += 0x0e;
	}
	fclose(fp);
	mdata->pCodecCtx = malloc(8192 * sizeof(AVCodecContext*));
	mdata->pFrame = malloc(8192 * sizeof(AVFrame*));
	mdata->pPCM = malloc(8192 * sizeof(short*));
	//    output headers
	sprintf(m2tsfile, "%s/BDMV/STREAM/%s.m2ts", disc_root, mdata->pl.clipname[0][0]);
	sprintf(tmpfile, "/tmp/temp_%s.m2ts", mdata->pl.clipname[0][0]);
	char decodedData[6144];
	int r;
	fp = fopen(m2tsfile, "rb");
	fp2 = fopen(tmpfile, "wb");
	fseek(fp, 0, SEEK_END);
	fgetpos(fp, &fpos);
	fs = fpos.__pos;
	fseek(fp, 0, SEEK_SET);
	for(i = 0; i < 50; i++)
	{
		r = m2tsDecrypt(fp, mdata->key, i, decodedData);
		if(r != 0)
		{
			break;
		}
		if(fwrite(decodedData, sizeof(char), 6144, fp2) != 6144)
			return -1;
	}
	fclose(fp2);
	fclose(fp);
	
	printf("a\n");
	if(av_open_input_file(&mdata->pFormatCtx, tmpfile, NULL, 0, NULL) != 0)
        return -1;
    if(av_find_stream_info(mdata->pFormatCtx) < 0)
        return -1;
	printf("b\n");
	dump_format(mdata->pFormatCtx, 0, tmpfile, 0);
    for(i = 0; i < mdata->pFormatCtx->nb_streams; i++)
	{
		mdata->pCodecCtx[mdata->pFormatCtx->streams[i]->id] = mdata->pFormatCtx->streams[i]->codec;
    }
	mdata->pvCodec = malloc(mdata->pl.p_vs_length[0] * sizeof(AVCodec*));
	for(i = 0; i < mdata->pl.p_vs_length[0]; i++)
	{
		if(mdata->pl.vs_coding[0][i] == 0xea)
			mdata->pvCodec[i] = avcodec_find_decoder(CODEC_ID_VC1);
		else if(mdata->pl.vs_coding[0][i] == 0x02)
			mdata->pvCodec[i] = avcodec_find_decoder(CODEC_ID_MPEG2VIDEO);
		else if(mdata->pl.vs_coding[0][i] == 0x1c)
			mdata->pvCodec[i] = avcodec_find_decoder(CODEC_ID_H264);
		else
			return -1;
		if(!mdata->pvCodec[i])
			return -1;
		if(avcodec_open(mdata->pCodecCtx[mdata->pl.vs_pid[0][i]], mdata->pvCodec[i]) < 0)
			return -1;
	}
	mdata->paCodec = malloc(mdata->pl.p_as_length[0] * sizeof(AVCodec*));
	for(i = 0; i < mdata->pl.p_as_length[0]; i++)
	{
		if(mdata->pl.as_coding[0][i] == 0x81)
			mdata->paCodec[i] = avcodec_find_decoder(CODEC_ID_AC3);
		else
			return -1;
		if(!mdata->paCodec[i])
			return -1;
		if(avcodec_open(mdata->pCodecCtx[mdata->pl.as_pid[0][i]], mdata->paCodec[i]) < 0)
			return -1;
	}
	return 0;
}

int bdpb_seek(struct BD_MovieData *mdata, unsigned long pos)
{
	int i, j;
	char m2tsfile[512];
	fpos_t fpos;
	long long fs;
	long long p, p2;
	int r;
	unsigned long s, e;
	char decodedData[6144];
	unsigned long block;
	char af_ctrl;
	unsigned long startpts = 0;
	char foundpes_h = 0;
	p2 = 0;
	p = 1;
	pos *= 2;
	for(i = 0; i < mdata->pl.playlength; i++)
	{
		if(mdata->pl.intime[i] * 2 <= pos && pos < mdata->pl.outtime[i] * 2)
		{
			mdata->pli = i;
			pos -= mdata->pl.intime[i] * 2;
			sprintf(m2tsfile, "%s/BDMV/STREAM/%s.m2ts", mdata->disc_root, mdata->pl.clipname[i][0]);
			mdata->fp = fopen(m2tsfile, "rb");
			if(mdata->fp == 0)
				return -1;
			fseek(mdata->fp, 0, SEEK_END);
			fgetpos(mdata->fp, &fpos);
			fs = fpos.__pos;
			block = 0;
			while(1)
			{
				r = m2tsDecrypt(mdata->fp, mdata->key, block, decodedData);
				if(r != 0)
				{
					return -1;
				}
				for(i = 0; i < 6144; i += 192)
				{
					if(decodedData[i + 5] & 0x40)
					{
						af_ctrl = (decodedData[i + 5] & 0xf0) >> 4;
						if(af_ctrl == 2)
							continue;
						if(af_ctrl == 3)
						{
							if(decodedData[i + 9 + decodedData[i + 8]] == 0x00 && decodedData[i + 10 + decodedData[i + 8]] == 0x00 && decodedData[i + 11 + decodedData[i + 8]] == 0x01) // it is PES header
							{
								startpts  = ((unsigned char)decodedData[i + 18 + decodedData[i + 8]] & 0x0e) << 29;
								startpts |=  (unsigned char)decodedData[i + 19 + decodedData[i + 8]] << 22;
								startpts |= ((unsigned char)decodedData[i + 20 + decodedData[i + 8]] & 0xfe) << 14;
								startpts |=  (unsigned char)decodedData[i + 21 + decodedData[i + 8]] << 7;
								startpts |= ((unsigned char)decodedData[i + 22 + decodedData[i + 8]] & 0xfe) >> 1;
								foundpes_h = 1;
								break;
							}
						}
						else
						{
							if(decodedData[i + 8] == 0x00 && decodedData[i + 9] == 0x00 && decodedData[i + 10] == 0x01) // it is PES header
							{
								startpts  = ((unsigned char)decodedData[i + 17] & 0x0e) << 29;
								startpts |=  (unsigned char)decodedData[i + 18] << 22;
								startpts |= ((unsigned char)decodedData[i + 19] & 0xfe) << 14;
								startpts |=  (unsigned char)decodedData[i + 20] << 7;
								startpts |= ((unsigned char)decodedData[i + 21] & 0xfe) >> 1;
								foundpes_h = 1;
								break;
							}
						}
					}
				}
				if(foundpes_h)
					break;
				block++;
			}
			pos += startpts;
			s = 0;
			e = fs / 6144;
			block = e / 2;
			foundpes_h = 0;
			j = 0;
			while(1)
			{
				if(!foundpes_h)
				{
					foundpes_h = 0;
					block++;
				}
				else
					block = (e - s) / 2 + s;
				r = m2tsDecrypt(mdata->fp, mdata->key, block, decodedData);
				if(r != 0)
				{
					e = block;
					break;
				}
				foundpes_h = 0;
				for(i = 0; i < 6144; i += 192)
				{
					if(decodedData[i + 5] & 0x40)
					{
						af_ctrl = (decodedData[i + 5] & 0xf0) >> 4;
						if(af_ctrl == 2)
							continue;
						if(af_ctrl == 3)
						{
							if(decodedData[i + 9 + decodedData[i + 8]] == 0x00 && decodedData[i + 10 + decodedData[i + 8]] == 0x00 && decodedData[i + 11 + decodedData[i + 8]] == 0x01) // it is PES header
							{
								foundpes_h = 1;
								p  = ((unsigned char)decodedData[i + 18 + decodedData[i + 8]] & 0x0e) << 29;
								p |=  (unsigned char)decodedData[i + 19 + decodedData[i + 8]] << 22;
								p |= ((unsigned char)decodedData[i + 20 + decodedData[i + 8]] & 0xfe) << 14;
								p |=  (unsigned char)decodedData[i + 21 + decodedData[i + 8]] << 7;
								p |= ((unsigned char)decodedData[i + 22 + decodedData[i + 8]] & 0xfe) >> 1;
								if(j == 0)
								{
									if(p == p2)
									{
										mdata->block = block;
										mdata->packet = i;
										j = 1;
										continue;
									}
									p2 = p;
									if(p < pos)
									{
										e = block;
										break;
									}
									else
									{
										s = block;
										break;
									}
								}
								else
								{
									if(p < pos)
									{
										if(p2 < pos)
										{
											if(pos - p < pos - p2)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
										else
										{
											if(pos - p < p2 - pos)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
									}
									else
									{
										if(p2 < pos)
										{
											if(p - pos < pos - p2)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
										else
										{
											if(p - pos < p2 - pos)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
									}
								}
							}
						}
						else
						{
							if(decodedData[i + 8] == 0x00 && decodedData[i + 9] == 0x00 && decodedData[i + 10] == 0x01) // it is PES header
							{
								foundpes_h = 1;
								p  = ((unsigned char)decodedData[i + 17] & 0x0e) << 29;
								p |=  (unsigned char)decodedData[i + 18] << 22;
								p |= ((unsigned char)decodedData[i + 19] & 0xfe) << 14;
								p |=  (unsigned char)decodedData[i + 20] << 7;
								p |= ((unsigned char)decodedData[i + 21] & 0xfe) >> 1;
								if(j == 0)
								{
									if(p == p2)
									{
										mdata->block = block;
										mdata->packet = i;
										j = 1;
										continue;
									}
									p2 = p;
									if(pos < p)
									{
										e = block;
										break;
									}
									else
									{
										s = block;
										break;
									}
								}
								else
								{
									if(p < pos)
									{
										if(p2 < pos)
										{
											if(pos - p < pos - p2)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
										else
										{
											if(pos - p < p2 - pos)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
									}
									else
									{
										if(p2 < pos)
										{
											if(p - pos < pos - p2)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
										else
										{
											if(p - pos < p2 - pos)
											{
												p2 = p;
												mdata->packet = i;
											}
										}
									}
								}
							}
						}
					}
				}
				if(j == 1)
				{
					mdata->pb_status = 2;
					return 0;
				}
			}
			fclose(mdata->fp);
		}
	}
	return -1;
}

struct sample
{
    unsigned char *data;
    unsigned long dlen;
    char datalock;
} sound;

void bdpb_count()
{
	int y;
	//timer_flag++;
	if(viewsleep == 1)
	{
		if(viewframe - 1 == setframe || (viewframe == 0 && setframe == 255))
		{
			viewsleep = 0;
			SDL_PauseAudio(0);
		}
		return;
	}
	if(viewframe != setframe)
	{
		for(y = scr->h - 1; y >= 0; y--)
		{
			memcpy(scr->pixels + y * scr->pitch, pFrameBGR[viewframe]->data[0] + y * pFrameBGR[viewframe]->linesize[0], scr->w * 3);
		}
		SDL_UpdateRect(scr, 0, 0, scr->w, scr->h);
		viewframe++;
		if(viewframe == 256)
			viewframe = 0;
	}
	else
	{
		viewsleep = 1;
		sound.dlen = 0;
		SDL_PauseAudio(1);
	}
}

void mixaudio(void *unused, unsigned char *stream, int len)
{
	int i;
	long a;
	if(sound.dlen >= len)
	{
		sound.datalock = 1;
		memcpy(stream, sound.data, len);
		a = sound.dlen;
		for(i = 0; i < sound.dlen; i += len)
		{
			memcpy(sound.data + i, sound.data + i + len, len);
		}
		if(a != sound.dlen)
			printf("aaaaaa\n");
		sound.dlen -= len;
		sound.datalock = 0;
	}
}


int bdpb_playloopf(struct BD_MovieData *mdata)
{
	// Initializer SDL
	if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_TIMER) < 0) {
        printf("ERROR：%s\n", SDL_GetError());
        return -1;
    }
    SDL_WM_SetCaption("Blu-ray Player for Linux 0.1 alpha", NULL);
	
	int size_w, size_h;
	size_w = 1200;
	size_h = 675;
    scr = SDL_SetVideoMode(size_w, size_h, 24, SDL_SWSURFACE);
    if (scr == NULL) {
        fprintf(stderr, "ERROR: SDL initialize failed\n");
        SDL_Quit();
        return -1;
    }
	int r, pid, y, l, x;
	int i, j, k, pl;
	int sub_x, sub_y;
	char decodedData_sub[2][6144], *decodedData;
	unsigned char *stream;
	long length;
	long bytesDecoded;
	int frameFinished;
	struct sigaction act, oldact;
	struct itimerval value, ovalue;
	struct timespec playwait, fpswait, audiowait, syncwait;
	
	char subpict_forced;
	int subpict_left;
	int subpict_top;
	int subpict_width;
	int subpict_height;
	
	long block;
	
	unsigned char subpict_p_y[256];
	unsigned char subpict_p_cr[256];
	unsigned char subpict_p_cb[256];
	unsigned char subpict_p_a[256];
	
	unsigned char *subpict_data;
	long subpict_datalength, p;
	int filllen;
	char nullpict;
	double alpha, ialpha;
	char alphacolor, invalphacolor;
	
	char *scrdata_tmp1, *scrdata_tmp2, *scrdata_tmp3;
	int hpt, wpl;
	char syncflag1;
	int ddn;
	char videook;
	playwait.tv_sec = 0;
	playwait.tv_nsec = 500000;
	audiowait.tv_sec = 0;
	audiowait.tv_nsec = 5000000;
	fpswait.tv_sec = 0;
	fpswait.tv_nsec = 500000;
	syncwait.tv_sec = 0;
	syncwait.tv_nsec = 10000;
	int error_flag = 0;
	int a_decOut_s;
	for(i = 0; i < 256; i++)
	{
		pFrameBGR[i] = avcodec_alloc_frame();
		buffer[i] = (unsigned char*)malloc(sizeof(unsigned char) * avpicture_get_size(PIX_FMT_BGR24, scr->w, scr->h));
		avpicture_fill((AVPicture*)pFrameBGR[i], buffer[i], PIX_FMT_BGR24, scr->w, scr->h);
	}
	setframe = 0;
	viewframe = 0;
	viewsleep = 0;
	act.sa_handler = bdpb_count;
	act.sa_flags = 0;
	sigaction(SIGALRM, &act, &oldact);
	if(mdata->pl.vs_framerate[mdata->pli][0] == 1)
		value.it_value.tv_usec = 41708; // 23.976 (24000/1001)
	else if(mdata->pl.vs_framerate[mdata->pli][0] == 2)
		value.it_value.tv_usec = 41667; // 24.000
	else if(mdata->pl.vs_framerate[mdata->pli][0] == 3)
		value.it_value.tv_usec = 40000; // 25.000
	else if(mdata->pl.vs_framerate[mdata->pli][0] == 4)
		value.it_value.tv_usec = 33367; // 29.970 (30000/1001)
	else if(mdata->pl.vs_framerate[mdata->pli][0] == 5)
		value.it_value.tv_usec = 20000; // 50.000
	else if(mdata->pl.vs_framerate[mdata->pli][0] == 6)
		value.it_value.tv_usec = 16683; // 59.940 (60000/1001)
	else
		return -1;
	value.it_value.tv_sec = 0;
	value.it_interval.tv_sec = 0;
	value.it_interval.tv_usec = value.it_value.tv_usec;
	setitimer(ITIMER_REAL, &value, &ovalue);
	if(mdata->pids[1] != 0xffff)
	{
		sound.dlen = 0;
		s_fmt.freq = mdata->pCodecCtx[mdata->pids[1]]->sample_rate;
		s_fmt.format = AUDIO_S16;
		s_fmt.channels = mdata->pCodecCtx[mdata->pids[1]]->channels;
		s_fmt.samples = 512;
		s_fmt.callback = mixaudio;
		s_fmt.userdata = NULL;
		if ( SDL_OpenAudio(&s_fmt, NULL) < 0 ) {
		    return -1;
		}
		sound.data = malloc(10485760 * sizeof(char));
		sound.datalock = 0;
		SDL_PauseAudio(0);
		mdata->pPCM[mdata->pids[1]] = malloc(AVCODEC_MAX_AUDIO_FRAME_SIZE * sizeof(short));
		for(i = 0; i < AVCODEC_MAX_AUDIO_FRAME_SIZE; i++)
			mdata->pPCM[mdata->pids[1]][i] = 0;
	}
	timer_flag = 0;
	mdata->imgConvertCtx = sws_getContext(mdata->pCodecCtx[mdata->pids[0]]->width, mdata->pCodecCtx[mdata->pids[0]]->height, PIX_FMT_YUV420P, scr->w, scr->h, PIX_FMT_BGR24, SWS_FAST_BILINEAR, NULL, NULL, NULL);
	subpict_data = malloc(sizeof(char) * mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height * 4);
	mdata->pFrame[mdata->pids[0]] = avcodec_alloc_frame();
	scrdata_tmp1 = malloc(sizeof(char) * mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height);
	scrdata_tmp2 = malloc(sizeof(char) * mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
	scrdata_tmp3 = malloc(sizeof(char) * mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
	for(i = 255; i >= 0; i--)
	{
		subpict_p_y[i] = 0;
		subpict_p_cr[i] = 0;
		subpict_p_cb[i] = 0;
		subpict_p_a[i] = 0;
	}
	nullpict = 2;
	videook = 0;
	block = mdata->block;
	l = m2tsDecrypt(mdata->fp, mdata->key, block++, decodedData_sub[0]);
	decodedData = decodedData_sub[0];
	syncflag1 = 0;
	ddn = 1;
	/*
	  parallel processing
	 */
	#pragma omp parallel
	#pragma omp sections
	{
		#pragma omp section
		{
			while(!error_flag)
			{
				l = m2tsDecrypt(mdata->fp, mdata->key, block, decodedData_sub[ddn]);
				syncflag1 = 1;
				while(syncflag1 == 1)
				{
					nanosleep(&syncwait, NULL);
				}
				if(ddn == 1)
					ddn = 0;
				else
					ddn = 1;
				block++;
			}
		}
		#pragma omp section
		{
			while(!error_flag)
			{
				if(l != 0)
				{
					printf("move to next stream\n");
					error_flag = 1;
				}
				for(i = 0; i < 6144; i += 192)
				{
					if(mdata->pb_status != 1)
					{
						while(mdata->pb_status == 0)
						{
							nanosleep(&playwait, NULL);
						}
						if(mdata->pb_status == 2)
						{
							m2tsReset();
							while(syncflag1 == 0)
							{
								nanosleep(&syncwait, NULL);
							}
							block = mdata->block;
							l = m2tsDecrypt(mdata->fp, mdata->key, block, decodedData);
							if(l != 0)
							{
								printf("move to next stream\n");
								error_flag = 1;
							}
							l = m2tsDecrypt(mdata->fp, mdata->key, ++block, decodedData_sub[ddn]);
							if(l != 0)
							{
								printf("move to next stream\n");
								error_flag = 1;
							}
							i = mdata->packet;
							mdata->pb_status = 1;
						}
						if(mdata->pb_status == 3)
						{
							av_free(mdata->pFrame[mdata->pids[0]]);
							mdata->pids[0] = tracksaver;
							mdata->pFrame[mdata->pids[0]] = avcodec_alloc_frame();
							mdata->pb_status = 1;
						}
						if(mdata->pb_status == 4)
						{
							free(mdata->pPCM[mdata->pids[1]]);
							mdata->pids[1] = tracksaver;
							mdata->pPCM[mdata->pids[1]] = malloc(AVCODEC_MAX_AUDIO_FRAME_SIZE * sizeof(short));
							for(i = 0; i < AVCODEC_MAX_AUDIO_FRAME_SIZE; i++)
								mdata->pPCM[mdata->pids[1]][i] = 0;
							mdata->pb_status = 1;
						}
						if(mdata->pb_status == 5)
						{
							mdata->pids[2] = tracksaver;
							nullpict = 1;
							mdata->pb_status = 1;
						}
					}
					r = m2tsSet192Data(decodedData + i, &pid, &length, mdata->pids);
					if(r == -1 || r == -2 || r == -4 || r == -3)
					{
						continue;
					}
					if(r == -5)
						i -= 192;
					stream = (unsigned char*)get_m2tsStreamData(pid, &length);
					if(mdata->pids[0] == pid) // is video stream
					{
						frameFinished = 0;
						while(length > 0)
						{
							bytesDecoded = avcodec_decode_video(mdata->pCodecCtx[pid], mdata->pFrame[pid], &frameFinished, stream, length);
							if(bytesDecoded < 0)
							{
								videook = 0;
								break;
							}
							videook = 1;
							length -= bytesDecoded;
							stream += bytesDecoded;

							if(frameFinished)
							{
								if(mdata->pids[1] == 0xffff)
								{
									while(timer_flag == 0)
									{
										nanosleep(&fpswait, NULL);
									}
								}
								//if(timer_flag >= 1)
								//{
								//	timer_flag = 0;
								//	break;
								//}
								// 字幕を合成
								if(nullpict == 0)
								{
									memcpy(scrdata_tmp1, mdata->pFrame[pid]->data[0], mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height);
									memcpy(scrdata_tmp2, mdata->pFrame[pid]->data[1], mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
									memcpy(scrdata_tmp3, mdata->pFrame[pid]->data[2], mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
									x = 0;
									y = 0;
									hpt = subpict_height + subpict_top;
									wpl = subpict_width + subpict_left;
									for(k = subpict_top; k < hpt; k++)
									{
										for(j = subpict_left; j < wpl; j++)
										{
											alpha = (double)subpict_data[x * 4 + y * subpict_width * 4 + 3] / 255;
											ialpha = 1 - alpha;
											p = k * mdata->pCodecCtx[mdata->pids[0]]->width + j;
											alphacolor = (double)subpict_data[x * 4 + y * subpict_width * 4] * alpha;
											invalphacolor = (double)(unsigned char)mdata->pFrame[pid]->data[0][p] * ialpha;
											mdata->pFrame[pid]->data[0][p] = (int)(invalphacolor + alphacolor);
											x++;
										}
										x = 0;
										y++;
									}
									x = 0;
									y = 0;
									hpt /= 2;
									wpl /= 2;
									for(k = subpict_top / 2; k < hpt; k++)
									{
										for(j = subpict_left / 2; j < wpl; j++)
										{
											alpha = (double)subpict_data[x * 4 + y * subpict_width * 4 + 3] / 255;
											ialpha = 1 - alpha;
											p = k * mdata->pCodecCtx[mdata->pids[0]]->width / 2 + j;
											alphacolor = (double)subpict_data[x * 4 + y * subpict_width * 4 + 1] * alpha;
											invalphacolor = (double)(unsigned char)mdata->pFrame[pid]->data[1][p] * ialpha;
											mdata->pFrame[pid]->data[1][p] = (char)(invalphacolor + alphacolor);
											alphacolor = (double)subpict_data[x * 4 + y * subpict_width * 4 + 2] * alpha;
											invalphacolor = (double)(unsigned char)mdata->pFrame[pid]->data[2][p] * ialpha;
											mdata->pFrame[pid]->data[2][p] = (int)(invalphacolor + alphacolor);
											x += 2;
										}
										x = 0;
										y += 2;
									}
								}
								setframe++;
								if(setframe == 256)
								{
									setframe = 0;
								}
								while(1)
								{
									if(!(viewframe - 1 == setframe || (viewframe == 0 && setframe == 255)))
									{
										break;
									}
									nanosleep(&fpswait, NULL);
								}
								sws_scale(mdata->imgConvertCtx, mdata->pFrame[pid]->data, mdata->pFrame[pid]->linesize, 0, mdata->pCodecCtx[pid]->height, pFrameBGR[setframe]->data, pFrameBGR[setframe]->linesize);
								timer_flag--;
								if(nullpict == 0)
								{
									memcpy(mdata->pFrame[pid]->data[0], scrdata_tmp1, mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height);
									memcpy(mdata->pFrame[pid]->data[1], scrdata_tmp2, mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
									memcpy(mdata->pFrame[pid]->data[2], scrdata_tmp3, mdata->pCodecCtx[mdata->pids[0]]->width * mdata->pCodecCtx[mdata->pids[0]]->height / 4);
								}
							}
						}
					}
					if(mdata->pids[1] == pid && videook) // is audio stream
					{
						while (length > 0) {
							a_decOut_s = AVCODEC_MAX_AUDIO_FRAME_SIZE * sizeof(short);
							bytesDecoded = avcodec_decode_audio2(mdata->pCodecCtx[pid], mdata->pPCM[pid], &a_decOut_s, stream, length);
							if (bytesDecoded < 0)
							{
								break;
							}
							length -= bytesDecoded;
							stream += bytesDecoded;
							if(a_decOut_s <= 0)
								continue;
							while(sound.dlen > 1024 * s_fmt.size || sound.datalock)
							{
								nanosleep(&audiowait, NULL); // スリープを入れずに実行すると負荷が激しいので
							}
							memcpy(sound.data + sound.dlen, mdata->pPCM[pid], a_decOut_s);
							sound.dlen += a_decOut_s;
						}
					}
					if(mdata->pids[2] == pid) // is subpicture stream
					{
						if(stream[0] == 0x16)
						{
							nullpict = 2;
							subpict_forced = stream[18];
							subpict_left  = (unsigned char)stream[19] << 8;
							subpict_left |= (unsigned char)stream[20];
							subpict_top  = (unsigned char)stream[21] << 8;
							subpict_top |= (unsigned char)stream[22];
						}
						if(stream[0] == 0x17)
						{
							subpict_forced = stream[18];
							subpict_left  = (unsigned char)stream[5] << 8;
							subpict_left |= (unsigned char)stream[6];
							subpict_top  = (unsigned char)stream[7] << 8;
							subpict_top |= (unsigned char)stream[8];
							subpict_width  = (unsigned char)stream[9] << 8;
							subpict_width |= (unsigned char)stream[10];
							subpict_height  = (unsigned char)stream[11] << 8;
							subpict_height |= (unsigned char)stream[12];
						}
						if(stream[0] == 0x14)
						{
							j  = (unsigned char)stream[1] << 8;
							j |= (unsigned char)stream[2];
							for(pl = 5; pl < j + 3; pl += 5)
							{
								subpict_p_y[stream[pl]] = stream[pl + 1];
								subpict_p_cr[stream[pl]] = stream[pl + 2];
								subpict_p_cb[stream[pl]] = stream[pl + 3];
								subpict_p_a[stream[pl]] = stream[pl + 4];
							}
						}
						if(stream[0] == 0x15)
						{
							nullpict = 1;
							subpict_datalength  = (unsigned char)stream[1] << 8;
							subpict_datalength |= (unsigned char)stream[2];
							subpict_datalength -= 11;
							subpict_width  = (unsigned char)stream[10] << 8;
							subpict_width |= (unsigned char)stream[11];
							subpict_height  = (unsigned char)stream[12] << 8;
							subpict_height |= (unsigned char)stream[13];
							for(j = 0; j < subpict_width * subpict_height * 4; j++)
							{
								subpict_data[j] = 0;
							}
							sub_x = 0;
							sub_y = 0;
							j = 0;
							stream += 14;
							
							for(j = 0; j < subpict_datalength; j++)
							{
								if(stream[j] == 0x00)
								{
									if(stream[j + 1] == 0x00)
									{
										sub_x = 0;
										sub_y++;
										j += 1;
										continue;
									}
									if((stream[j + 1] & 0xc0) == 0x00)
									{
										filllen = stream[j + 1] & 0x3f;
										for(k = sub_x; k < sub_x + filllen; k++)
										{
											subpict_data[sub_y * subpict_width * 4 + k * 4] = subpict_p_y[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 1] = subpict_p_cr[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 2] = subpict_p_cb[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 3] = subpict_p_a[0];
										}
										sub_x += filllen;
										j += 1;
										continue;
									}
									if((stream[j + 1] & 0xc0) == 0x40)
									{
										filllen  = ((unsigned char)stream[j + 1] & 0x3f) << 8;
										filllen |= (unsigned char)stream[j + 2];
										for(k = sub_x; k < sub_x + filllen; k++)
										{
											subpict_data[sub_y * subpict_width * 4 + k * 4] = subpict_p_y[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 1] = subpict_p_cr[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 2] = subpict_p_cb[0];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 3] = subpict_p_a[0];
										}
										sub_x += filllen;
										j += 2;
										continue;
									}
									if((stream[j + 1] & 0xc0) == 0x80)
									{
										filllen = (unsigned char)stream[j + 1] & 0x3f;
										for(k = sub_x; k < sub_x + filllen; k++)
										{
											subpict_data[sub_y * subpict_width * 4 + k * 4] = subpict_p_y[stream[j + 2]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 1] = subpict_p_cr[stream[j + 2]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 2] = subpict_p_cb[stream[j + 2]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 3] = subpict_p_a[stream[j + 2]];
										}
										sub_x += filllen;
										j += 2;
										continue;
									}
									if((stream[j + 1] & 0xc0) == 0xc0)
									{
										filllen  = ((unsigned char)stream[j + 1] & 0x3f) << 8;
										filllen |= (unsigned char)stream[j + 2];
										for(k = sub_x; k < sub_x + filllen; k++)
										{
											subpict_data[sub_y * subpict_width * 4 + k * 4] = subpict_p_y[stream[j + 3]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 1] = subpict_p_cr[stream[j + 3]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 2] = subpict_p_cb[stream[j + 3]];
											subpict_data[sub_y * subpict_width * 4 + k * 4 + 3] = subpict_p_a[stream[j + 3]];
										}
										sub_x += filllen;
										j += 3;
										continue;
									}
								}
								else
								{
									subpict_data[sub_y * subpict_width * 4 + sub_x * 4] = subpict_p_y[stream[j]];
									subpict_data[sub_y * subpict_width * 4 + sub_x * 4 + 1] = subpict_p_cr[stream[j]];
									subpict_data[sub_y * subpict_width * 4 + sub_x * 4 + 2] = subpict_p_cb[stream[j]];
									subpict_data[sub_y * subpict_width * 4 + sub_x * 4 + 3] = subpict_p_a[stream[j]];
									sub_x++;
								}
							}
							stream -= 14;
						}
						if(stream[0] == 0x80)
						{
							if(nullpict == 1)
								nullpict = 0;
						}
					}
				}
				while(syncflag1 == 0)
				{
					nanosleep(&syncwait, NULL);
				}
				decodedData = decodedData_sub[ddn];
				syncflag1 = 0;
			}
		} //  end of section
	}
	return -1;
}

void bdpb_playback(struct BD_MovieData *mdata)
{
	mdata->pb_status = 1;
}

void bdpb_pause(struct BD_MovieData *mdata)
{
	mdata->pb_status = 0;
}

void bdpb_stop(struct BD_MovieData *mdata)
{
	mdata->pb_status = 0;
	bdpb_seek(mdata, mdata->pl.mark_timestamp[0]);
}

void bdpb_changeVideoTrack(struct BD_MovieData *mdata, int track)
{
	mdata->pb_status = 3;
	tracksaver = track;
}

void bdpb_changeAudioTrack(struct BD_MovieData *mdata, int track)
{
	mdata->pb_status = 4;
	tracksaver = track;
}

void bdpb_changeSubpictureTrack(struct BD_MovieData *mdata, int track)
{
	mdata->pb_status = 5;
	tracksaver = track;
}

