/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const Ci = Components.interfaces;
const Cc = Components.classes;
const XPC = {
	createInstance: function(aContractId, aInterface){
		return Components.classes[aContractId].createInstance(Components.interfaces[aInterface]);
	},
	getService: function(aContractId, aInterface){
	    return Components.classes[aContractId].getService(Components.interfaces[aInterface]);
	}
}

const B2R_STORAGE_SERVICE_CONTRACTID = "@bbs2ch.sourceforge.jp/b2r-storage-service;1";
const B2R_STORAGE_SERVICE_CID = Components.ID("a06586e0-3b8a-42c1-a76f-9800c805f175");
const B2R_STORAGE_SERVICE_CNAME = "b2rStorageService js component";

var gStorageService = null;




	// ********** ********* b2rStorageService ********** **********

function b2rStorageService(){
	this._database = null;
}

b2rStorageService.prototype = {

	get database(){
		return this._database;
	},


	setThreadData: function(aThreadURL, aBoardURL, aDatID, aTitle, aLineCount, aLastModified, aMaruGetted){
		this._thread.setThreadData(aThreadURL, aBoardURL, aDatID, aTitle, aLineCount, aLastModified, aMaruGetted);
	},
	getThreadData: function(aBoardURL, aDatID){
		return this._thread.getThreadData(aBoardURL, aDatID);
	},
	deleteThreadData: function(aBoardURL, aDatID, aRemoveDatFile){
		this._thread.deleteThreadData(aBoardURL, aDatID, aRemoveDatFile);
	},

	boardSubjectUpdate: function(aBoardURL, aBoardType, aSubjectFile){
		this._board.boardSubjectUpdate(aBoardURL, aBoardType, aSubjectFile);
	},
	getBoardData: function(aBoardURL){
		return this._board.getBoardData(aBoardURL);
	},

	updateBbsmenu: function(aBbsmenuFile){
		return this._bbsmenu.updateBbsmenu(aBbsmenuFile);
	},

	_startup: function(){
		var b2rService = XPC.getService("@bbs2ch.sourceforge.jp/b2r-global-service;1", "b2rIGlobalService");
		var dbFile = b2rService.io.getDataDir();
		dbFile.appendRelativePath("logs-050pre2");
		dbFile.appendRelativePath("storage.sqlite");
		if(!dbFile.exists()){
			dbFile.create(Ci.nsILocalFile.NORMAL_FILE_TYPE, 0666);
		}

		var storageService = XPC.getService("@mozilla.org/storage/service;1", "mozIStorageService");
		this._database = storageService.openDatabase(dbFile);

		var subScriptLoader = XPC.getService("@mozilla.org/moz/jssubscript-loader;1", "mozIJSSubScriptLoader");
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rStorageThread.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rStorageBoard.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rStorageBbsmenu.js", null);

		this._thread = new b2rStorageThread();
		this._board = new b2rStorageBoard();
		this._bbsmenu = new b2rStorageBbsmenu();
	},


	_quit: function(){
			// XXX mozIStorageConnection.close() は、Gecko 1.9 から
		if(this._database.close){
			this._database.close();
		}
	},


	_getNormarizedString: function(aString){
		var unicodeNormalizer  = XPC.createInstance("@mozilla.org/intl/unicodenormalizer;1", "nsIUnicodeNormalizer");
		var normalizedStr = {};
		unicodeNormalizer.NormalizeUnicodeNFKC(aString.toLowerCase(), normalizedStr);
		return this._html2Text(normalizedStr.value);
	},

	_html2Text: function(aString){
		if(aString.indexOf("&") == -1){
			return aString;
		}
		return aString.replace(/&quot;/g, "\"").replace(/&amp;/g, "&").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
	},

	// ********** ********* implements nsIObserver ********** **********

	observe: function(aSubject, aTopic, aData){
		var observerService = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");

		switch(aTopic){
			case "app-startup":
				observerService.addObserver(this, "b2rIGlobalService:startup", false);
				observerService.addObserver(this, "b2rIGlobalService:quit", false);
				break;
			case "b2rIGlobalService:startup":
				this._startup();
				observerService.removeObserver(this, "b2rIGlobalService:startup");
				break;
			case "b2rIGlobalService:quit":
				this._quit();
				observerService.removeObserver(this, "b2rIGlobalService:quit");
				break;
		}
	},


	// ********** ********* implements nsIClassInfo ********** **********

	get classDescription() {
		return B2R_STORAGE_SERVICE_CNAME;
	},
	get classID() {
		return B2R_STORAGE_SERVICE_CID;
	},
	get implementationLanguage() {
		return Ci.nsIProgrammingLanguage.JAVASCRIPT;
	},
	get flags() {
		return Ci.nsIClassInfo.SINGLETON;
	},
	get contractID() {
    	return B2R_STORAGE_SERVICE_CONTRACTID;
	},
	getInterfaces: function(aCount) {
	    var interfaces = [
			Ci.b2rIStorageService,
			Ci.nsIClassInfo,
			Ci.nsIObserver,
			Ci.nsISupports
		];
	    aCount.value = interfaces.length;
    	return interfaces;
	},
 	getHelperForLanguage: function(aLanguage) {
    	return null;
	},


	// ********** ********* implements nsISupports ********** **********

	QueryInterface: function(aIID){
		if(aIID.equals(Ci.b2rIStorageService)) return this;
		if(aIID.equals(Ci.nsIClassInfo)) return this;
		if(aIID.equals(Ci.nsIObserver)) return this;
		if(aIID.equals(Ci.nsISupports)) return this;

		throw Components.results.NS_ERROR_NO_INTERFACE;
	}
}

// ********** ********* Component Registration ********** **********


var b2rStorageServiceFactory = {

	createInstance: function (aOuter, aIID){
		if(aOuter != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;

		if(!gStorageService){
			gStorageService = new b2rStorageService();
		}

		return gStorageService.QueryInterface(aIID);
	}

};


var Module = {

	registerSelf: function(aCompMgr, aFileSpec, aLocation, aType){
		aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);

		aCompMgr.registerFactoryLocation(
						B2R_STORAGE_SERVICE_CID,
						B2R_STORAGE_SERVICE_CNAME,
						B2R_STORAGE_SERVICE_CONTRACTID,
						aFileSpec, aLocation, aType);

		var categoryManager = XPC.getService("@mozilla.org/categorymanager;1", "nsICategoryManager");
		categoryManager.addCategoryEntry("app-startup", B2R_STORAGE_SERVICE_CNAME,
											B2R_STORAGE_SERVICE_CONTRACTID, true, true);
	},


	unregisterSelf: function(aCompMgr, aFileSpec, aLocation){
		aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
		aCompMgr.unregisterFactoryLocation(B2R_STORAGE_SERVICE_CID, aFileSpec);

		var categoryManager = XPC.getService("@mozilla.org/categorymanager;1", "nsICategoryManager");
		categoryManager.deleteCategoryEntry("app-startup", B2R_STORAGE_SERVICE_CONTRACTID, true);
	},


	getClassObject: function(aCompMgr, aCID, aIID){
		if(aCID.equals(B2R_STORAGE_SERVICE_CID)) return b2rStorageServiceFactory;

		if(!aIID.equals(Ci.nsIFactory))
			throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

		throw Components.results.NS_ERROR_NO_INTERFACE;
	},


	canUnload: function(aCompMgr){
		return true;
	}

};


function NSGetModule(aCompMgr, aFileSpec){
	return Module;
}