/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const Ci = Components.interfaces;
const Cc = Components.classes;
const XPC = {
	createInstance: function(aContractId, aInterface){
		return Components.classes[aContractId].createInstance(Components.interfaces[aInterface]);
	},
	getService: function(aContractId, aInterface){
	    return Components.classes[aContractId].getService(Components.interfaces[aInterface]);
	}
}


const B2R_GLOBAL_SERVICE_CONTRACTID = "@bbs2ch.sourceforge.jp/b2r-global-service;1";
const B2R_GLOBAL_SERVICE_CID = Components.ID("{e3c8ad09-ff53-40cf-9942-26c8d7a96fe7}");
const B2R_GLOBAL_SERVICE_CNAME = "b2rGlobalService js component";

var gGlobalService = null;


	// ********** ********* b2rGlobalService ********** **********

function b2rGlobalService(){
	this._io = null;
	this._threadUtils = null;
	this._history = null;
	this._viewer = null;

	this._initialized = false;
}

b2rGlobalService.prototype = {

	BOARD_TYPE_2CH:    Ci.b2rIGlobalService.BOARD_TYPE_2CH,
	BOARD_TYPE_OLD2CH: Ci.b2rIGlobalService.BOARD_TYPE_OLD2CH,
	BOARD_TYPE_BE2CH:  Ci.b2rIGlobalService.BOARD_TYPE_BE2CH,
	BOARD_TYPE_JBBS:   Ci.b2rIGlobalService.BOARD_TYPE_JBBS,
	BOARD_TYPE_MACHI:  Ci.b2rIGlobalService.BOARD_TYPE_MACHI,
	BOARD_TYPE_PAGE:   Ci.b2rIGlobalService.BOARD_TYPE_PAGE,

	get userAgent(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		if(!this._userAgent){
			try{
				var extensionManager = XPC.getService("@mozilla.org/extensions/manager;1", "nsIExtensionManager");
				var appInfo = XPC.getService("@mozilla.org/xre/app-info;1", "nsIXULAppInfo");
				var bbs2chID = "{0B9D558E-6983-486b-9AAD-B6CBCD2FC807}";
				var item = extensionManager.getItemForID(bbs2chID);
				this._userAgent = new Array(
							"Monazilla/1.00 (", item.name, "/", item.version, "; ",
							appInfo.name, "/", appInfo.version, ")").join("");
			}catch(ex){
				this._userAgent = "Monazilla/1.00 (bbs2chreader/0.5.0)"
			}
		}

		return this._userAgent;
	},


	get serverURL(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		if(!this._serverURL){
			var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
			var port = 0;
			try{
				var appInfo = XPC.createInstance("@mozilla.org/xre/app-info;1", "nsIXULAppInfo");
	    	    if(appInfo.name == "Firefox"){
					port = pref.getIntPref("extensions.bbs2chreader.server_port");
				}else if(appInfo.name == "SeaMonkey"){
					port = pref.getIntPref("extensions.bbs2chreader.server_port.seamonkey");
				}else{
					port = pref.getIntPref("extensions.bbs2chreader.server_port.other");
				}
			}catch(ex){
				port = pref.getIntPref("extensions.bbs2chreader.server_port.other");
			}

			var spec = "http://127.0.0.1:" + port;
			var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");
			this._serverURL = ioService.newURI(spec, null, null).QueryInterface(Ci.nsIURL);
		}
		return this._serverURL.clone();
	},


	get io(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		return this._io;
	},
	get threadUtils(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		return this._threadUtils;
	},
	get history(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		return this._history;
	},
	get viewer(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		return this._viewer;
	},
	get abone(){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		return this._abone;
	},

	getHttpChannel: function(aURL){
		if(!this._initialized) throw Components.results.NS_ERROR_NOT_INITIALIZED;
		if(aURL === null){
			throw Components.results.NS_ERROR_INVALID_POINTER;
		}

		var httpChannel;
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
		var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");

			// 0=ブラウザの設定に従う  1=直接接続する  2=独自に設定する
		var proxyMode = pref.getIntPref("extensions.bbs2chreader.http_proxy_mode");
		if(proxyMode != 0){
			var httpPHandler = ioService.getProtocolHandler("http").QueryInterface(Ci.nsIHttpProtocolHandler);
			var pps = XPC.getService("@mozilla.org/network/protocol-proxy-service;1", "nsIProtocolProxyService");

			if(proxyMode == 1){
				var proxyInfo = pps.newProxyInfo("direct", "", -1, 0, 0, null);
				httpChannel = httpPHandler.newProxiedChannel(aURL, proxyInfo).QueryInterface(Ci.nsIHttpChannel);
			}else if(proxyMode == 2){
				var httpProxyValue = pref.getComplexValue("extensions.bbs2chreader.http_proxy_value",
							Ci.nsISupportsString).data;
				httpProxyValue = httpProxyValue.replace(/\s/g, "");
				if(httpProxyValue.match(/([^:]+):(\d+)/)){
					var host = RegExp.$1;
					var port = parseInt(RegExp.$2);
					try{
						var proxyInfoDirect = pps.newProxyInfo("direct", "", -1, 0, 0, null);
						var proxyInfo = pps.newProxyInfo("http", host, port, 0, 10, proxyInfoDirect);
						httpChannel = httpPHandler.newProxiedChannel(aURL, proxyInfo)
							.QueryInterface(Ci.nsIHttpChannel);
					}catch(ex){
						dump("b2rGlobalIO.getHttpChannel() : " + ex +"\n");
					}
				}
			}
		}

		if(!httpChannel){
			httpChannel = ioService.newChannelFromURI(aURL).QueryInterface(Ci.nsIHttpChannel);
		}

		httpChannel.setRequestHeader("User-Agent", this.userAgent, false);
		httpChannel.notificationCallbacks = {
		    getInterface: function(aIID, aInstance) {
	    	    Components.returnCode = Components.results.NS_ERROR_NO_INTERFACE;
	        	return null;
		    }
		};
		return httpChannel;
	},

	openURL: function(aURLSpec, aReferrer, aAddTab){
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
		var windowMediator = XPC.getService("@mozilla.org/appshell/window-mediator;1", "nsIWindowMediator");
		var browserWindow = windowMediator.getMostRecentWindow("navigator:browser");
		if(browserWindow){
			var contentBrowser = browserWindow.document.getElementById("content");
			if(aAddTab){
				var newTab = contentBrowser.addTab(aURLSpec, aReferrer);
				if(pref.getBoolPref("extensions.bbs2chreader.tab_load_in_foreground"))
					contentBrowser.selectedTab = newTab;
			}else{
				contentBrowser.loadURI(aURLSpec, aReferrer);
			}
			return;
		}

		// Firefox/Seamonkey 以外のブラウザでの処理はここに書く

		this.openNewWindow(aURLSpec);
	},


	openNewWindow: function(aURLSpec){
		var argString = XPC.createInstance("@mozilla.org/supports-string;1", "nsISupportsString");
		argString.data = aURLSpec || "about:blank";

		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
		var browserURL = pref.getCharPref("browser.chromeURL");
		var winWatcher = XPC.getService("@mozilla.org/embedcomp/window-watcher;1", "nsIWindowWatcher");
		winWatcher.openWindow(null, browserURL, "_blank", "chrome,all,dialog=no", argString);
	},


	_startup: function(){
		var subScriptLoader = XPC.getService("@mozilla.org/moz/jssubscript-loader;1", "mozIJSSubScriptLoader");
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rGlobalIO.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rGlobalThreadUtils.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rGlobalHistory.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rGlobalViewer.js", null);
		subScriptLoader.loadSubScript("chrome://bbs2chreader/content/components/b2rAboneManager.js", null);

		this._initialized = true;
		this._io = new b2rGlobalIO();
		this._threadUtils = new b2rGlobalThreadUtils();
		this._history = new b2rGlobalHistory();
		this._viewer = new b2rGlobalViewer();
		this._abone = new b2rAboneManager();
	},


	_quitApp: function(){
		this._abone._saveAboneData();
	},

	_shutdown: function(){
		this._io = null;
		this._threadUtils = null;
		this._history = null;
		this._viewer = null;
		this._abone = null;

		this._initialized = false;
	},


	// ********** ********* implements nsIObserver ********** **********

	observe: function(aSubject, aTopic, aData){
		var observerService = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");

		switch(aTopic){
			case "app-startup":
				observerService.addObserver(this, "profile-after-change", false);
				observerService.addObserver(this, "quit-application", false);
				observerService.addObserver(this, "xpcom-shutdown", false);
				break;
			case "profile-after-change":
				this._startup();
				observerService.removeObserver(this, "profile-after-change");
				observerService.notifyObservers(null, "b2rIGlobalService:startup", "startup");
				break;
			case "quit-application":
				this._quitApp();
				observerService.removeObserver(this, "quit-application");
				observerService.notifyObservers(null, "b2rIGlobalService:quit", "quit");
				break;
			case "xpcom-shutdown":
				this._shutdown();
				observerService.removeObserver(this, "xpcom-shutdown");
				break;
		}
	},


	// ********** ********* implements nsIClassInfo ********** **********

	get classDescription() {
		return B2R_GLOBAL_SERVICE_CNAME;
	},


	get classID() {
		return B2R_GLOBAL_SERVICE_CID;
	},


	get implementationLanguage() {
		return Ci.nsIProgrammingLanguage.JAVASCRIPT;
	},


	get flags() {
		return Ci.nsIClassInfo.SINGLETON;
	},


	get contractID() {
    	return B2R_GLOBAL_SERVICE_CONTRACTID;
	},


	getInterfaces: function(aCount) {
	    var interfaces = [
			Ci.b2rIGlobalService,
			Ci.nsIClassInfo,
			Ci.nsIObserver,
			Ci.nsISupports
		];
	    aCount.value = interfaces.length;
    	return interfaces;
	},


 	getHelperForLanguage: function(aLanguage) {
    	return null;
	},


	// ********** ********* implements nsISupports ********** **********

	QueryInterface: function(aIID){
		if(aIID.equals(Ci.b2rIGlobalService)) return this;
		if(aIID.equals(Ci.nsIClassInfo)) return this;
		if(aIID.equals(Ci.nsIObserver)) return this;
		if(aIID.equals(Ci.nsISupports)) return this;

		throw Components.results.NS_ERROR_NO_INTERFACE;
	}

};




// ********** ********* Component Registration ********** **********


var b2rGlobalServiceFactory = {

	createInstance: function (aOuter, aIID){
		if(aOuter != null)
			throw Components.results.NS_ERROR_NO_AGGREGATION;

		if(!gGlobalService){
			gGlobalService = new b2rGlobalService();
		}

		return gGlobalService.QueryInterface(aIID);
	}

};


var Module = {

	registerSelf: function(aCompMgr, aFileSpec, aLocation, aType){
		aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);

		aCompMgr.registerFactoryLocation(
						B2R_GLOBAL_SERVICE_CID,
						B2R_GLOBAL_SERVICE_CNAME,
						B2R_GLOBAL_SERVICE_CONTRACTID,
						aFileSpec, aLocation, aType);

		var categoryManager = XPC.getService("@mozilla.org/categorymanager;1", "nsICategoryManager");
		categoryManager.addCategoryEntry("app-startup", B2R_GLOBAL_SERVICE_CNAME,
											B2R_GLOBAL_SERVICE_CONTRACTID, true, true);
	},


	unregisterSelf: function(aCompMgr, aFileSpec, aLocation){
		aCompMgr = aCompMgr.QueryInterface(Ci.nsIComponentRegistrar);
		aCompMgr.unregisterFactoryLocation(B2R_GLOBAL_SERVICE_CID, aFileSpec);

		var categoryManager = XPC.getService("@mozilla.org/categorymanager;1", "nsICategoryManager");
		categoryManager.deleteCategoryEntry("app-startup", B2R_GLOBAL_SERVICE_CONTRACTID, true);
	},


	getClassObject: function(aCompMgr, aCID, aIID){
		if(aCID.equals(B2R_GLOBAL_SERVICE_CID)) return b2rGlobalServiceFactory;

		if(!aIID.equals(Ci.nsIFactory))
			throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

		throw Components.results.NS_ERROR_NO_INTERFACE;
	},


	canUnload: function(aCompMgr){
		return true;
	}

};


function NSGetModule(aCompMgr, aFileSpec){
	return Module;
}