/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is bbs2chreader.
 *
 * The Initial Developer of the Original Code is
 * flyson.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *    flyson <flyson at users.sourceforge.jp>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


function b2rGlobalViewer(){
	this._init();
}

b2rGlobalViewer.prototype = {

	get logined(){
		return this._logined;
	},


	get sessionID(){
		return this._sessionID;
	},


	_init: function(){
		this._logined = false;
		this._sessionID = "";

		this._autoAuth();
	},


	auth: function(){
		this._logined = false;
		this._sessionID = "";

		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
		var maruEnabled = pref.getBoolPref("extensions.bbs2chreader.maru_enabled");
		if(!maruEnabled){ return; }
		this._authDelay();
	},


	_autoAuth: function(){
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

		var maruAutoAuth = pref.getBoolPref("extensions.bbs2chreader.maru_auto_auth");
		if(!maruAutoAuth){ return; }
		var maruEnabled = pref.getBoolPref("extensions.bbs2chreader.maru_enabled");
		if(!maruEnabled){ return; }

			// 6ԈȓɃOCĂꍇ́AXLbv
			// ۂ 2ch viewer ̃ZbVLԂ 24 ?
		var lastAuthTime = pref.getIntPref("extensions.bbs2chreader.maru_last_auth_time");
		var nowTime = Math.round(Date.now() / 1000);
		if((nowTime - lastAuthTime) < 21600){
			this._logined = true;
			this._sessionID = pref.getCharPref("extensions.bbs2chreader.maru_session_id");

			dump("b2rGlobalViewer: 2ch Viewer Auth SKIP\n");
			var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
			os.notifyObservers(null, "b2r-2ch-viewer-auth", "SKIP");
			return;
		}

		var timer = XPC.createInstance("@mozilla.org/timer;1", "nsITimer");
		var timerCallback = {};
		timerCallback._context = this;
		timerCallback.observe = function(aTimer){
			dump("b2rGlobalViewer: 2ch Viewer Auth Start\n");
			this._context._authDelay();
		}
		timer.init(timerCallback, 500, Ci.nsITimer.TYPE_ONE_SHOT);

	},

	_authDelay: function(){
		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");

		var maruAuthURLSpec = pref.getCharPref("extensions.bbs2chreader.maru_auth_url");
		var maruID = pref.getCharPref("extensions.bbs2chreader.maru_id");
		var maruPass = pref.getCharPref("extensions.bbs2chreader.maru_password");

		var ioService = XPC.getService("@mozilla.org/network/io-service;1", "nsIIOService");
		var maruAuthURL = ioService.newURI(maruAuthURLSpec, null, null).QueryInterface(Ci.nsIURL);

		var httpChannel = gGlobalService.getHttpChannel(maruAuthURL);
		httpChannel.setRequestHeader("User-Agent", "DOLIB/1.00", false);
		httpChannel.setRequestHeader("X-2ch-UA", gGlobalService.userAgent, false);
		httpChannel.setRequestHeader("Content-Type", "application/x-www-form-urlencoded", false);
		httpChannel = httpChannel.QueryInterface(Ci.nsIUploadChannel);

		var strIStream = XPC.createInstance("@mozilla.org/io/string-input-stream;1", "nsIStringInputStream");
		var postString = String("ID=" + maruID + "&PW=" + maruPass);
		strIStream.setData(postString, postString.length);
		httpChannel.setUploadStream(strIStream, "application/x-www-form-urlencoded", -1);
		httpChannel.requestMethod = "POST";

		var listener = {
			onStartRequest: function(aRequest, aContext){
				this._bInputStream = XPC.createInstance("@mozilla.org/binaryinputstream;1", "nsIBinaryInputStream");
				this._data = new Array();
			},
			onDataAvailable: function (aRequest, aContext, aInputStream, aOffset, aCount){
				this._bInputStream.setInputStream(aInputStream);
				this._data.push(this._bInputStream.readBytes(aCount));
			},
			onStopRequest: function(aRequest, aContext, aStatus){
				var data = this._data.join("");
				if(data.indexOf("ERROR:") != -1){
					aContext.wrappedJSObject._maruLoginNG();
					return;
				}
				aContext.wrappedJSObject._maruLoginOK(data.substring(11, data.length -1));
			}
		};
		this.wrappedJSObject = this;
		httpChannel.asyncOpen(listener, this);

	},

	_maruLoginOK: function(aSessionID){
		this._logined = true;
		this._sessionID = aSessionID;

		var pref = XPC.getService("@mozilla.org/preferences-service;1", "nsIPrefBranch");
		var nowTime = Math.round(Date.now() / 1000);
		pref.setCharPref("extensions.bbs2chreader.maru_session_id", aSessionID);
		pref.setIntPref("extensions.bbs2chreader.maru_last_auth_time", nowTime);
		dump("b2rGlobalViewer: 2ch Viewer Auth OK\n");

		var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
		os.notifyObservers(null, "b2r-2ch-viewer-auth", "OK");
	},

	_maruLoginNG: function(aSessionID){
		this._maruLogined = false;
		this._maruSessionID = "";
		dump(this.maruSessionID + "\n");
		dump("b2rGlobalViewer: 2ch Viewer Auth NG\n");

		var alertsService = XPC.getService("@mozilla.org/alerts-service;1", "nsIAlertsService");
		alertsService.showAlertNotification("", "bbs2chreader", "Login failed on 2ch Viewer", false, "", null);

		var os = XPC.getService("@mozilla.org/observer-service;1", "nsIObserverService");
		os.notifyObservers(null, "b2r-2ch-viewer-auth", "NG");
	}

};