//
//  BSIPIArrayController.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 07/11/11.
//  Copyright 2007-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSIPIArrayController.h"
#import <AppKit/NSToolbarItem.h>


@implementation BSIPIArrayController
- (void)removeAll:(id)sender
{
    [self removeObjects:[self arrangedObjects]];
}

- (void)selectFirst:(id)sender
{
    [self setSelectionIndex:0];
}

- (void)selectLast:(id)sender
{
    unsigned count = [self countOfArrangedObjects];
    if (count == 0) {
        return;
    }
    [self setSelectionIndex:(count-1)];
}

- (unsigned int)countOfArrangedObjects
{
    return [[self arrangedObjects] count];
}

- (BOOL)validateMenuItem:(NSMenuItem *)menuItem
{
    if ([menuItem action] == @selector(removeAll:)) {
        return ([self countOfArrangedObjects] > 0);
    }
    return [super validateMenuItem:menuItem];
}

- (BOOL)validateToolbarItem:(NSToolbarItem *)toolbarItem
{
    if ([toolbarItem action] == @selector(remove:)) {
        return [self canRemove];
    }
    return [super validateToolbarItem:toolbarItem];
}
@end
