//
//  CMRSingletonObject.h
//  CMF
//
//  Updated by Tsutomu Sawada on 09/06/22.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#define APP_SINGLETON_FACTORY_METHOD_IMPLEMENTATION(methodName) \
static id st_instance = nil;\
\
+ (id) methodName\
{\
    @synchronized(self) {\
        if (st_instance == nil) {\
            [[self alloc] init];\
        }\
    }\
    return st_instance;\
}\
+ (id) allocWithZone: (NSZone *) zone\
{\
    @synchronized(self) {\
        if (st_instance == nil) {\
            st_instance = [super allocWithZone: zone];\
            return st_instance;\
        }\
    }\
    return nil;\
}\
- (id) copyWithZone: (NSZone *) zone {return self;}\
- (id) retain {return self;}\
- (unsigned) retainCount {return UINT_MAX;}\
- (void) release{}\
- (id) autorelease{return self;}
