//: CMRTaskManager_p.h
/**
  * $Id: CMRTaskManager_p.h,v 1.1.1.1 2005-05-11 17:51:07 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

#import "CMRTaskManager.h"
#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>

#import <SGFoundation/SGFoundation.h>
#import <SGAppKit/SGAppKit.h>

#import <CocoMonar/CocoMonar.h>
#import "UTILKit.h"
#import "CMRTask.h"
#import "CMRTaskItemController.h"


#define APP_TASK_MANAGER_NIB_NAME			@"CMRTaskManager"
#define APP_TASK_MANAGER_DEFAULT_CAPACITY	5



@interface CMRTaskManager(TaskInProgress)
- (void) taskWillProgressProcessing : (NSTimer *) aTimer;
- (void) addTaskInProgress : (id<CMRTask>) aTask;
- (void) removeTask : (id<CMRTask>) aTask;

- (void) taskWillStartProcessing : (NSNotification *) aNotification;
- (void) taskDidFinishProcessing : (NSNotification *) aNotification;
- (void) registerNotificationWithTask : (id<CMRTask>) aTask;
- (void) removeFromNotificationWithTask : (id<CMRTask>) aTask;

- (BOOL) shouldRegisterTask : (id<CMRTask>) aTask;
@end



@interface CMRTaskManager(TaskItemManagement)
- (CMRTaskItemController *) controllerForTask : (id<CMRTask>) aTask;
- (NSMutableArray *) tasksInProgress;
- (NSMutableArray *) taskItemControllers;
- (NSMutableDictionary *) controllerMapping;
- (CMRTaskItemController *) controllerForTask : (id<CMRTask>) aTask;
- (void) addTaskItemController : (CMRTaskItemController *) newController;

- (unsigned) capacity;
- (void) removeFinishedControllersIfNeeded;
@end



// CMRTaskManager-ViewAccessor.m
@interface CMRTaskManager(ViewAccessor)
- (NSScrollView *) scrollView;
/* Accessor for m_taskContainerView */
- (SGContainerTableView *) taskContainerView;

- (void) taskContainerViewScrollLastRowToVisible;
- (void) setupTaskContainerView;
- (void) setupUIComponents;
@end
