/**
 * $Id: BoardManager.h,v 1.3.2.4 2006-09-01 13:46:54 masakih Exp $
 * 
 * BoardManager.h
 *
 * Copyright (c) 2004 Takanori Ishikawa, All rights reserved.
 * See the file LICENSE for copying permission.
 */

#import <SGFoundation/SGFoundation.h>

@class SmartBoardList;
/*!
    @class		BoardManager
    @abstract   fXg dataSource 񋟂ƁAef̑ւ̃ANZXꊇĎ舵}l[W
    @discussion BoardManager ́AfXg dataSource 񋟂܂B܂AefɊւ
				X̑̓ǂݏT|[g܂Bf̖͂OňӂɎʂ邱ƂɒӂĂB
				BoardManager Ōf̑ǂݏہAقƂǂ̃\bhŌf́uOvL[
				Kv܂BAO킩ȂAURL 킩Ăꍇ́AboardNameForURL:
				\bhŖO𓾂邱Ƃł܂B
				BoardManager î݂Ƃj舵f̑F
				EURLi̋tAURL ړ]̃T|[g܂ށj
				EftHg
				EftHgRen
				EftHg[
				E Be OCďނǂH
				EXbhꗗł̃\[gJƁA^~
*/

/*
typedef enum _BSBeLoginPolicyType {
	BSBeLoginTriviallyNeeded	= 0, // Be OCK{
	BSBeLoginTriviallyOFF		= 1, // Be OC͖Ӗi2chł͂ȂfȂǁj
	BSBeLoginDecidedByUser		= 2, // Be OC邩ǂ̓[U̐ݒQƂ
	BSBeLoginNoAccountOFF		= 3  // ݒ Be AJEgݒ肳ĂȂ
} BSBeLoginPolicyType;
*/
@interface BoardManager : NSObject
{
    @private
	SmartBoardList		*_defaultList;
	SmartBoardList		*_userList;
	NSDictionary		*_noNameDict;	// NoNameManager 𓝍
}
+ (id) defaultManager;

- (SmartBoardList *) defaultList;
- (SmartBoardList *) userList;

- (NSString *) defaultBoardListPath;
- (NSString *) userBoardListPath;
+ (NSString *) NNDFilepath;

- (NSURL *) URLForBoardName : (NSString *) boardName;
- (NSString *) boardNameForURL : (NSURL *) anURL;

- (void) updateURL : (NSURL    *) anURL
      forBoardName : (NSString *) aName;

/*!
 * @method        tryToDetectMovedBoard
 * @abstract      Detect moved BBS as possible.
 * @discussion    Detect moved BBS from HTML contents server has
 *                returned. It may be unexpected contents (expected
 *                index.html), but it can contain information about 
 *                new location of BBS.
 *
 * @param boardName BBS Name
 * @result          return YES, if BoardManager change old location.
 */
- (BOOL) tryToDetectMovedBoard : (NSString *) boardName;

/*!
 * @method        detectMovedBoardWithResponseHTML:
 * @abstract      Detect moved BBS as possible.
 * @discussion    Detect moved BBS from HTML contents server has
 *                returned. It may be unexpected contents (expected
 *                index.html), but it can contain information about 
 *                new location of BBS.
 *
 * @param aHTML     HTML contents, NSString
 * @param boardName BBS Name
 * @result          return YES, if BoardManager change old location.
 */
- (BOOL) detectMovedBoardWithResponseHTML : (NSString *) htmlContents
                                boardName : (NSString *) boardName;
@end

@interface BoardManager(BSAddition)
// CMRNoNameManager 𓝍
// NoNameManager ׂ͂ CMRBBSSignature ɂƂĂABoardManager ւ
// ɔAׂ NSString ɕύX̂ŒӁB

- (NSDictionary *) noNameDict;

/* ̖O */
- (NSString *) defaultNoNameForBoard : (NSString *) boardName;
- (void) setDefaultNoName : (NSString *) aName
			 	 forBoard : (NSString *) boardName;
/* \[gJ */
- (NSString *) sortColumnForBoard : (NSString *) boardName;
- (void) setSortColumn : (NSString *) anIdentifier
			  forBoard : (NSString *) boardName;
- (BOOL) sortColumnIsAscendingAtBoard : (NSString *) boardName;
- (void) setSortColumnIsAscending : (BOOL	   ) isAscending
						  atBoard : (NSString *) boardName;

// SledgeHammer Addition
- (BOOL) alwaysBeLoginAtBoard : (NSString *) boardName;
- (void) setAlwaysBeLogin : (BOOL	   ) alwaysLogin
				  atBoard : (NSString *) boardName;
- (NSString *) defaultKotehanForBoard : (NSString *) boardName;
- (void) setDefaultKotehan : (NSString *) aName
				  forBoard : (NSString *) boardName;
- (NSString *) defaultMailForBoard : (NSString *) boardName;
- (void) setDefaultMail : (NSString *) aString
			   forBoard : (NSString *) boardName;

// LittleWish Addition
/* ӁF1.1.x ł͂܂C^tF[X̂ */
// available in BathyScaphe 1.2 and later.
- (BOOL) allThreadsShouldAAThreadAtBoard : (NSString *) boardName;
- (void) setAllThreadsShouldAAThread : (BOOL      ) shouldAAThread
							 atBoard : (NSString *) boardName;

// LittleWish Addtion : Read-only Properties
- (NSImage *) iconForBoard : (NSString *) boardName;
- (BSBeLoginPolicyType) typeOfBeLoginPolicyForBoard : (NSString *) boardName;

/*
	[U̓͂󂯂B
	
	@param aBoard f
	@param presetValue:aValue eLXgtB[h̃ftHgl
	@result LZɂ nil
*/
- (NSString *) askUserAboutDefaultNoNameForBoard : (NSString *) boardName
									 presetValue : (NSString *) aValue;
@end

///////////////////////////////////////////////////////////////
///////////////// [ N o t i f i c a t i o n ] /////////////////
///////////////////////////////////////////////////////////////

extern NSString *const CMRBBSManagerUserListDidChangeNotification;
extern NSString *const CMRBBSManagerDefaultListDidChangeNotification;
