//
//  SmartBLIEditorHelper.m
//  BathyScaphe
//
//  Created by Hori,Masaki on 06/01/03.
//  Copyright 2006 BathyScaphe Project. All rights reserved.
//

#import "SmartBLIEditorHelper.h"

#import "SmartCondition.h"

//#import "BSDatePicker.h"

//rootHelperを始点とする双方向リンクドリンストを構成する。
//rootHelperは特別扱いされ、ビューを表示しない。
//
//	IBOutlet NSPopUpButton *allOrAnyPopUp;
//	IBOutlet NSScrollView *container;
//	IBOutlet NSButton *includeFallInDATCheck;
//	IBOutlet NSButton *excludeAdThreadCheck;
//	IBOutlet NSTextField *nameField;
//はrootHelperにのみ存在し、(SmartBoardListItemEditor.nib内で接続）
//	IBOutlet id expressionView;
//	IBOutlet id numberView;
//	IBOutlet id dateView;
//はrootHelper以外にのみ存在する。(SmartBLIEditorComponents.nib内で接続)
//
//rootHelperはSmartBoardListItemEditor.nib内でインスタンス化されると最初のhelperを生成する。
//
//	containerはNSScrollViewであり、そのdocumentViewは上下がひくり返ったFlippedViewである。
//	FlppedView内にColorBackgroundViewが条件数分配置されている。
//
//	---NSScrollView----------------------
//	| ---FlippedView------------------- |
//	| | ---ColorBackgroundView------- | |
//	| | |                           | | |
//	| | |                           | | |
//	| | ----------------------------- | |
//	| | ---ColorBackgroundView------- | |
//	| | |                           | | |
//	| | |                           | | |
//	| | ----------------------------- | |
//	| --------------------------------| |
//	-------------------------------------
//


#pragma mark## External Variables ##
NSString *SmartBLIEditorComponentsNibName = @"SmartBLIEditorComponents";

NSString *CriteriaSpecificationsPlist = @"CriteriaSpecifications.plist";
NSString *CriteriaSpecificationsCriteriaKey = @"criteria";
NSString		*CriteriaNameKey = @"name";
NSString		*CriteriaTypeKey = @"type";
NSString *CriteriaSpecificationsOrdersKey = @"orders";

#pragma mark## Class Variables ##
static NSDictionary *sCriteriaSpecifications = nil;


@implementation SmartBLIEditorHelper

+ (void)initialize
{
	static BOOL isFirst = YES;
	//	@synchronized(self) {
	if(isFirst) {
		isFirst = NO;
		
		if(!sCriteriaSpecifications) {
			NSString *path;
			path = [[NSBundle applicationSpecificBundle] pathForResourceWithName:CriteriaSpecificationsPlist];
			if(!path) {
				path = [[NSBundle mainBundle] pathForResourceWithName:CriteriaSpecificationsPlist];
			}
			if(path) {
				sCriteriaSpecifications = [[NSDictionary dictionaryWithContentsOfFile:path] retain];
			}
			UTILAssertNotNil(sCriteriaSpecifications);
		}
	}
	//	}
}

+ (NSDictionary *)criteriaSpecifications
{
	return sCriteriaSpecifications;
}

- (void)dealloc
{
	if(previousHelper == nil && nextHelper != nil) {
		nextHelper->previousHelper = nil;
		[nextHelper release];
		nextHelper = nil;
	}
	
	[expressionView release];
	[numberView release];
	[dateView release];
	
	[super dealloc];
}

- (void)awakeFromNib
{
	// containerが存在するのは rootHelper のみ。
	if(container) {
		FlippedView *d;
		d = [[[FlippedView alloc] initWithFrame:[container documentVisibleRect]] autorelease];
		[container setDocumentView:d];
		[self addCriterion:self];
	} else {
		id item;
		
		item = [self uiItemForTag:criterionPopUpTag];
		item = [item menu];
		[item setDelegate:item];
	}
}

- (IBAction)addCriterion:(id)sender
{
	id newHelper;
	
	newHelper = [[[[self class] alloc] init] autorelease];
	[newHelper loadComponent];
	[self insertHelper:newHelper after:self];
	[newHelper addConditionView];
}
- (IBAction)removeCriterion:(id)sender
{
	[self removeConditionView];
}
- (IBAction)changeCriterionPop:(id)sender
{	
	[self builExpressionViews];
}

- (void)insertHelper:(SmartBLIEditorHelper *)newHelper after:(SmartBLIEditorHelper *)helper
{
	newHelper->previousHelper = helper;
	newHelper->nextHelper = helper->nextHelper;
	helper->nextHelper = [newHelper retain];
	if(newHelper->nextHelper) {
		newHelper->nextHelper->previousHelper = newHelper;
	}
}
- (void)addHelper:(SmartBLIEditorHelper *)newHelper
{
	SmartBLIEditorHelper *lastHepler = self;
	
	while(lastHepler->nextHelper) lastHepler = lastHepler->nextHelper;
	
	newHelper->previousHelper = lastHepler;
	newHelper->nextHelper = lastHepler->nextHelper;
	lastHepler->nextHelper = [newHelper retain];
	if(newHelper->nextHelper) {
		newHelper->nextHelper->previousHelper = newHelper;
	}
}
- (void)removeHelper:(SmartBLIEditorHelper *)helper
{
	helper->previousHelper->nextHelper = helper->nextHelper;
	if(helper->nextHelper) {
		helper->nextHelper->previousHelper = helper->previousHelper;
	}
	helper->nextHelper = helper->previousHelper = nil;
	[helper autorelease];
}
- (SmartBLIEditorHelper *)nextHelper
{
	return nextHelper;
}
- (SmartBLIEditorHelper *)previousHelper
{
	if([previousHelper isEqual:[self rootHelper]]) return nil;
	
	return previousHelper;
}
- (SmartBLIEditorHelper *)rootHelper
{
	SmartBLIEditorHelper *prev, *curr = self;
	
	while(prev = curr->previousHelper) curr = prev;
	
	return curr;
}

@end
