/**
 * $Id: CMRAppDelegate.m,v 1.24.2.4 2006-09-07 19:35:16 tsawada2 Exp $
 * 
 * CMRAppDelegate.m
 *
 * Copyright (c) 2004 Takanori Ishikawa, All rights reserved.
 * See the file LICENSE for copying permission.
 */
#import "CMRAppDelegate_p.h"
#import "BoardWarrior.h"
#import "CMRBrowser.h"

#import <SGAppKit/NSColor-SGExtensions.h>
#import <SGAppKit/NSImage-SGExtensions.h>

@class CMRDocumentController;

#define kOnlineItemKey				@"On Line"
#define kOfflineItemKey				@"Off Line"
#define kOnlineItemImageName		@"online"
#define kOfflineItemImageName		@"offline"

@implementation CMRAppDelegate
- (void) awakeFromNib
{
	m_shouldCascadeBrowserWindow = YES;
    [self setupMenu];
}


- (BOOL) shouldCascadeBrowserWindow
{
	return m_shouldCascadeBrowserWindow;
}

- (void) setShouldCascadeBrowserWindow: (BOOL) flag
{
	m_shouldCascadeBrowserWindow = flag;
}

#pragma mark IBAction

- (IBAction) showPreferencesPane : (id) sender
{
    [[CMRPref sharedPreferencesPane] showWindow : sender];
}
- (IBAction) showStandardFindPanel : (id) sender
{
    [[TextFinder standardTextFinder] showWindow : self];
}
- (IBAction) toggleOnlineMode : (id) sender
{    
    [NSApp sendAction : @selector(toggleOnlineMode:)
                   to : CMRPref
                 from : sender];
}

- (IBAction) togglePreviewPanel : (id) sender
{
	BOOL	result_;
	result_ = [NSApp sendAction : @selector(togglePreviewPanel:)
							 to : [CMRPref sharedImagePreviewer]
						   from : sender];

	if(NO == result_) NSLog(@"togglePreviewPanel: fail to send action.");
}

- (IBAction) showTaskInfoPanel : (id) sender
{
    [[CMRTaskManager defaultManager] showWindow : sender];
}

// For Help Menu
- (IBAction) openURL : (id) sender
{
    NSURL *url;
    
    UTILAssertRespondsTo(sender, @selector(representedObject));
    if (url = [sender representedObject]) {
        UTILAssertKindOfClass(url, NSURL);
        [[NSWorkspace sharedWorkspace] openURL : url];
    }
}

// Application Reset Alert's help button delegate
- (BOOL) alertShowHelp : (NSAlert *) alert
{
	[[NSHelpManager sharedHelpManager] openHelpAnchor : [alert helpAnchor]
											   inBook : [NSBundle applicationHelpBookName]];
	return YES;
}

- (IBAction) resetApplication : (id) sender
{
    CMRApplicationReset(self);
}

- (IBAction) openURLPanel : (id) sender
{
	if (NO == [NSApp isActive]) [NSApp activateIgnoringOtherApps: YES];
	[[CMROpenURLManager defaultManager] askUserURL];
}

- (IBAction) clearHistory : (id) sender
{
	[[CMRHistoryManager defaultManager] removeAllItems];
	[[BSHistoryMenuManager defaultManager] updateHistoryMenuWithMenu : [[[CMRMainMenuManager defaultManager] historyMenuItem] submenu]];
}

- (IBAction) showAcknowledgment : (id) sender
{
	NSBundle	*mainBundle;
    NSString	*fileName;
	NSString	*appName;
	NSWorkspace	*ws = [NSWorkspace sharedWorkspace];

    mainBundle = [NSBundle mainBundle];
    fileName = [mainBundle pathForResource : @"Acknowledgments" ofType : @"rtf"];
	appName = [ws absolutePathForAppBundleWithIdentifier : @"com.apple.TextEdit"];
	
    [ws openFile : fileName withApplication : appName];
}

- (IBAction) closeAll : (id) sender
{
	//̕@ł́uBathyScaphe ɂāvplȂǂȂiSafari ł͕ĂIj
	//NSArray	*array_ = [NSApp orderedWindows];
	//if (array_ == nil || [array_ count] == 0) return;
	
	//[array_ makeObjectsPerformSelector : @selector(performClose:)
	//						withObject : sender];
	
	//̕@ƊT˗ǂAmakeWindowsPerform:inOrder: gĔMZN^ "Canft take any arguments"
	//łAperformClose: gėǂ̂ǂsBiclose ĂԎ邪A܂Ɓcj
	[NSApp makeWindowsPerform : @selector(performClose:) inOrder : YES];
}

- (IBAction) miniaturizeAll : (id) sender
{
	[NSApp miniaturizeAll : sender];
}

- (IBAction) launchCMLF : (id) sender
{
    [[NSWorkspace sharedWorkspace] launchApplication: [CMRPref helperAppPath]];
}

- (IBAction) runBoardWarrior: (id) sender
{
	BoardWarrior *bw = [BoardWarrior warrior];
	
	if ([bw isInProgress]) return;
	[bw syncBoardLists];
}

- (void) orderFrontMainBrowserAndShowThListForBrd: (NSString *) boardName
						  addBrdToUsrListIfNeeded: (BOOL) addToList
{
	if (CMRMainBrowser != nil) {
		[[CMRMainBrowser window] makeKeyAndOrderFront : self];
	} else {
		[[CMRDocumentController sharedDocumentController] newDocument : self];
	}

	// addBrdToUsrListIfNeeded IvV͓ʂ̊Ԗi YES Łj
	[CMRMainBrowser selectRowWhoseNameIs : boardName]; // ̌ʂƂ outlineView  selectionDidChange: umɁv
													   // ĂяoA showThreadsListForBoardName: Ăяo
}

- (IBAction) startHEADCheckDirectly: (id) sender
{
	BOOL	hasBeenOnline = [CMRPref isOnlineMode];

	// ȒP̂߁AIC[h؂
	if(hasBeenOnline) [self toggleOnlineMode: sender];
	
	[self orderFrontMainBrowserAndShowThListForBrd: CMXFavoritesDirectoryName addBrdToUsrListIfNeeded: NO];
	[CMRMainBrowser reloadThreadsList: sender];

	// KvȂICɕA
	if(hasBeenOnline) [self toggleOnlineMode: sender];
}

#pragma mark validation
- (BOOL) validateToolbarItem : (NSToolbarItem *) theItem
{
	SEL action_ = [theItem action];
	if (action_ == @selector(launchCMLF:)) {
		NSString	*name_ = [CMRPref helperAppDisplayName];

		if (nil == name_) {
			return NO;
		} else {
			[theItem setLabel : name_];
			[theItem setPaletteLabel : name_];
			return YES;
		}
	}

	if (action_ == @selector(toggleOnlineMode:)) {
		NSString		*title_;
		NSImage			*image_;
		
		title_ = [CMRPref isOnlineMode]
					? [self localizedString : kOnlineItemKey]
					: [self localizedString : kOfflineItemKey];

		image_ = [CMRPref isOnlineMode]
					? [NSImage imageAppNamed : kOnlineItemImageName]
					: [NSImage imageAppNamed : kOfflineItemImageName];
		
		[theItem setImage : image_];
		[theItem setLabel : title_];
		return YES;
	}

	return YES;
}

- (BOOL) validateMenuItem : (NSMenuItem *) theItem
{
	SEL action_ = [theItem action];

	if (action_ == @selector(launchCMLF:)) {
		NSString	*name_ = [CMRPref helperAppDisplayName];

		if (nil == name_) {
			[theItem setTitle : [self localizedString : APP_MAINMENU_HELPER_NOTFOUND]];
			return NO;
		} else {
			[theItem setTitle : name_];
			return YES;
		}
	} else if (action_ == @selector(closeAll:)) {
		return ([NSApp makeWindowsPerform : @selector(isVisible) inOrder : YES] != nil);
	} else if (action_ == @selector(miniaturizeAll:)) {
		return ([NSApp makeWindowsPerform : @selector(isNotMiniaturizedButCanMinimize) inOrder : YES] != nil);
	} else if (action_ == @selector(togglePreviewPanel:)) {
		id tmp_ = [CMRPref sharedImagePreviewer];
		return [tmp_ respondsToSelector : @selector(togglePreviewPanel:)];
	}
	return YES;
}

#pragma mark AppleEvent Support
// Available in BathyScaphe 1.2 and later.
- (void) handleGetURLEvent : (NSAppleEventDescriptor *) event withReplyEvent : (NSAppleEventDescriptor *) replyEvent
{
    NSString	*urlStr_;
    NSURL		*url_;

    urlStr_ = [[event paramDescriptorForKeyword : keyDirectObject] stringValue];
	url_ = [NSURL URLWithString : urlStr_];

	// scheme ̈Ⴂibathyscaphe: or http:j CMROpenURLManager z
    [[CMROpenURLManager defaultManager] openLocation : url_];
}

#pragma mark NSApplication Delegates
- (void) applicationWillFinishLaunching : (NSNotification *) aNotification
// available in BathyScaphe 1.2 and later.
{
	NSAppleEventManager	*aeMgr = [NSAppleEventManager sharedAppleEventManager];
	
	[aeMgr setEventHandler : self
			   andSelector : @selector(handleGetURLEvent:withReplyEvent:)
			 forEventClass : 'GURL'
				andEventID : 'GURL']; // 'GURL' is different from 'gurl'
}

- (void) applicationDidFinishLaunching : (NSNotification *) aNotification
{
	CMRMainMenuManager *tmp = [CMRMainMenuManager defaultManager];
    /* Service menu */
    [NSApp setServicesProvider : [CMROpenURLManager defaultManager]];

	/* Remove 'Open Recent' menu */
	int openURLMenuItemIndex = [[tmp fileMenu] indexOfItemWithTarget : self andAction : @selector(openURLPanel:)];

    if (openURLMenuItemIndex >= 0 && [[[tmp fileMenu] itemAtIndex : openURLMenuItemIndex+1] hasSubmenu])
    {
            [[tmp fileMenu] removeItemAtIndex : openURLMenuItemIndex+1];
    }
	
	/* BoardWarrior Task */
	if ([CMRPref isOnlineMode] && [CMRPref autoSyncBoardList]) {
		NSDate *lastDate = [CMRPref lastSyncDate];
		if (!lastDate || [[NSDate date] timeIntervalSinceDate: lastDate] > [CMRPref timeIntervalForAutoSyncPrefs]) {
			[self runBoardWarrior: nil];
		}
	}
}

- (BOOL) applicationShouldHandleReopen: (NSApplication *) theApplication hasVisibleWindows: (BOOL) flag
{
	if (NO == flag) {
		m_shouldCascadeBrowserWindow = NO;
	}
	return YES;
}
@end


@implementation CMRAppDelegate(CMRLocalizableStringsOwner)
+ (NSString *) localizableStringsTableName
{
    return APP_MAINMENU_LOCALIZABLE_FILE_NAME;
}
@end

#pragma mark -

@implementation NSWindow(BSAddition)
- (BOOL) isNotMiniaturizedButCanMinimize
{
	// ŏĂȂAAŏ\łEChEłꍇ YES ԂB
	// ŏs\ȃEChEł͏ NO ԂB
	if (NO == ([self styleMask] & NSMiniaturizableWindowMask)) return NO;
	return (NO == [self isMiniaturized]);
}
@end

#pragma mark -

#define kRGBColorSpace	@"NSCalibratedRGBColorSpace"
@implementation NSApplication(ScriptingSupport)
- (BOOL) isOnlineMode
{
	return [CMRPref isOnlineMode];
}
- (void) setIsOnlineMode : (BOOL) flag
{
	[CMRPref setIsOnlineMode : flag];
}

- (NSArray *) browserTableViewColor
{
	float red,green,blue;
	
	NSColor *color_ = [CMRPref browserSTableBackgroundColor];
		
	[[color_ colorUsingColorSpaceName : kRGBColorSpace] getRed: &red green: &green blue: &blue alpha: NULL];

	return [NSArray arrayWithObjects : [NSNumber numberWithFloat:red], [NSNumber numberWithFloat:green], [NSNumber numberWithFloat:blue], nil];
}

- (void) setBrowserTableViewColor : (NSArray *) colorValue;
{
	// colorValue z̗vf 0 ̂Ƃ́AftHg̃J[ɖ߂B
	// ܂Az̗vf 0,3 ȊÔƂ͉ȂB
	if ([colorValue count] == 0) {
		[CMRPref setBrowserSTableDrawsBackground : NO];
	} else if ([colorValue count] == 3) {
		float red,green,blue;
		red		= [[colorValue objectAtIndex : 0] floatValue];
		green	= [[colorValue objectAtIndex : 1] floatValue];
		blue	= [[colorValue objectAtIndex : 2] floatValue];
	
		if (red == 0 && green == 0 && blue == 0) {
			[CMRPref setBrowserSTableDrawsBackground : NO];
		} else {
			[CMRPref setBrowserSTableBackgroundColor : [NSColor colorWithCalibratedRed:red green:green blue:blue alpha:1.0]];
		}
	}
}
- (NSArray *) boardListColor
{
	float red,green,blue;
	
	NSColor *color_ = [CMRPref boardListBackgroundColor];		
	[[color_ colorUsingColorSpaceName : kRGBColorSpace] getRed: &red green: &green blue: &blue alpha: NULL];

	return [NSArray arrayWithObjects : [NSNumber numberWithFloat:red], [NSNumber numberWithFloat:green], [NSNumber numberWithFloat:blue], nil];
}

- (void) setBoardListColor : (NSArray *) colorValue;
{
	// colorValue z̗vf 0 ̂Ƃ́AftHg̃J[ɖ߂B
	// ܂Az̗vf 0,3 ȊÔƂ͉ȂB
	if ([colorValue count] == 0) {
		[CMRPref setBoardListBackgroundColor : nil];
	} else if ([colorValue count] == 3) {
		float red,green,blue;
		red		= [[colorValue objectAtIndex : 0] floatValue];
		green	= [[colorValue objectAtIndex : 1] floatValue];
		blue	= [[colorValue objectAtIndex : 2] floatValue];

		[CMRPref setBoardListBackgroundColor : [NSColor colorWithCalibratedRed:red green:green blue:blue alpha:1.0]];
	}
}

- (void) handleOpenURLCommand : (NSScriptCommand *) command
{
	NSURL		*url_;
	NSString	*urlstr_ = [command directParameter];
	
	if(!urlstr_ || [urlstr_ isEqualToString : @""])
		return;
	
	url_ = [NSURL URLWithString : urlstr_];	
	[[CMROpenURLManager defaultManager] openLocation : url_];
}
@end
