//
//  SGHTMLView.h
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 10/03/28.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import <Cocoa/Cocoa.h>



@interface SGHTMLView:NSTextView
{
	@private
    // 自身がポップアップウインドウ上にあるときの、mouseExited 判定用
    NSTrackingArea *bs_visibleArea;
}

- (BOOL)mouseClicked:(NSEvent *)theEvent atIndex:(NSUInteger)charIndex;
@end


@interface NSObject(SGHTMLViewDelegate)
- (NSArray *)HTMLViewFilteringLinkSchemes:(SGHTMLView *)aView;

- (void)HTMLView:(SGHTMLView *)aView mouseEnteredInLink:(id)aLink inTrackingRect:(NSRect)aRect withEvent:(NSEvent *)anEvent;
- (void)HTMLView:(SGHTMLView *)aView mouseExitedFromLink:(id)aLink inTrackingRect:(NSRect)aRect withEvent:(NSEvent *)anEvent;

- (BOOL)HTMLView:(SGHTMLView *)aView mouseClicked:(NSEvent *)theEvent atIndex:(NSUInteger)charIndex;

// continuous mouseDown
- (BOOL)HTMLView:(SGHTMLView *)aView shouldHandleContinuousMouseDown:(NSEvent *)theEvent;
- (BOOL)HTMLView:(SGHTMLView *)aView continuousMouseDown:(NSEvent *)theEvent;
@end

// Notification
extern NSString *const SGHTMLViewMouseEnteredNotification;
extern NSString *const SGHTMLViewMouseExitedNotification;
