//
//  CMRFavoritesManager.m
//  BathyScaphe
//
//  Updated by Tsutomu Sawada on 07/12/09.
//  Copyright 2005-2009 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "CMRFavoritesManager.h"
#import "CocoMonar_Prefix.h"

#import "CMRThreadAttributes.h"
#import "CMRThreadSignature.h"
#import "CMRDocumentFileManager.h"
#import "BSDBThreadList.h"
#import "DatabaseManager.h"
#import "BSThreadListItem.h"

NSString *const CMRFavoritesManagerDidLinkFavoritesNotification = @"CMRFavoritesManagerDidLinkFavoritesNotification";
NSString *const CMRFavoritesManagerDidRemoveFavoritesNotification = @"CMRFavoritesManagerDidRemoveFavoritesNotification";

@implementation CMRFavoritesManager
APP_SINGLETON_FACTORY_METHOD_IMPLEMENTATION(defaultManager);

+ (int)version
{
	return 1;
}

- (CMRFavoritesOperation)availableOperationWithPath:(NSString *)filepath
{
	NSDictionary	*attr_;
	
	if (!filepath) {
        return CMRFavoritesOperationNone;
    }
    if (![[NSFileManager defaultManager] fileExistsAtPath:filepath]) {
        return CMRFavoritesOperationNone;
	}

	attr_ = [BSDBThreadList attributesForThreadsListWithContentsOfFile:filepath];
	// [Bug 10077] 回避のための強引な処理
	if (!attr_) {
		BOOL result_;
		result_ = [[DatabaseManager defaultManager] registerThreadFromFilePath:filepath];
		if (!result_) {
			return CMRFavoritesOperationNone;
		} else {
			return CMRFavoritesOperationLink;
		}
	}

    NSString *path = [attr_ objectForKey:CMRThreadLogFilepathKey];
	return [self availableOperationWithSignature:[CMRThreadSignature threadSignatureFromFilepath:path]];
}

- (CMRFavoritesOperation)availableOperationWithSignature:(CMRThreadSignature *)signature registered:(BOOL *)boolPtr
{
	id identifier;
	id boardName;
	id boardIDs;
    
    if (!signature) {
        return CMRFavoritesOperationNone;
    }

    identifier = [signature identifier];
    boardName = [signature boardName];

	boardIDs = [[DatabaseManager defaultManager] boardIDsForName:boardName];

	if (!identifier || !boardIDs) {
        return CMRFavoritesOperationNone;
    }
	/* TODO 複数存在する場合の処理 */
	unsigned boardID;
	boardID = [[boardIDs objectAtIndex:0] unsignedIntValue];
	
	BOOL isFavorite;
	isFavorite = [[DatabaseManager defaultManager] isFavoriteThreadIdentifier:identifier onBoardID:boardID];

	if (boolPtr != NULL) *boolPtr = [[DatabaseManager defaultManager] isThreadIdentifierRegistered:identifier onBoardID:boardID numberOfAll:NULL];
	
	if (isFavorite) {
        return CMRFavoritesOperationRemove;
    } else {
        return [[NSFileManager defaultManager] fileExistsAtPath:[signature threadDocumentPath]] ? CMRFavoritesOperationLink : CMRFavoritesOperationNone;
    }
}

- (CMRFavoritesOperation)availableOperationWithSignature:(CMRThreadSignature *)signature
{
	return [self availableOperationWithSignature:signature registered:NULL];
}

- (BOOL)canCreateFavoriteLinkFromPath:(NSString *)filepath
{
	return (CMRFavoritesOperationLink == [self availableOperationWithPath:filepath]);
}

- (BOOL)favoriteItemExistsOfThreadPath:(NSString *)filepath
{
	UTILAssertNotNil(filepath);
	return (CMRFavoritesOperationRemove == [self availableOperationWithPath:filepath]);
}

- (BOOL)favoriteItemExistsOfThreadSignature:(CMRThreadSignature *)signature registeredToDatabase:(BOOL *)boolPtr
{
	UTILAssertNotNil(signature);
	return (CMRFavoritesOperationRemove == [self availableOperationWithSignature:signature registered:boolPtr]);
}

- (BOOL)favoriteItemExistsOfThreadSignature:(CMRThreadSignature *)signature
{
	UTILAssertNotNil(signature);
	return (CMRFavoritesOperationRemove == [self availableOperationWithSignature:signature]);
}

#pragma mark Add
- (BOOL)addFavoriteWithThread:(id)threadIdentifier ofBoard:(NSString *)boardName
{
	id boardIDs; // TODO 複数存在する場合の処理
	BOOL isSuccess = NO;
    unsigned boardID;
	
	boardIDs = [[DatabaseManager defaultManager] boardIDsForName:boardName];
	if (!boardIDs) {
        return NO;
	}

    boardID = [[boardIDs objectAtIndex:0] unsignedIntValue];
	isSuccess = [[DatabaseManager defaultManager] appendFavoriteThreadIdentifier:threadIdentifier onBoardID:boardID];
	
	if (isSuccess) {
		UTILNotifyName(CMRFavoritesManagerDidLinkFavoritesNotification);
	}
	return isSuccess;
}

- (BOOL)addFavoriteWithSignature:(CMRThreadSignature *)signature
{
	if (!signature) {
        return NO;
    }
	return [self addFavoriteWithThread:[signature identifier] ofBoard:[signature boardName]];
}

- (BOOL)addFavoriteWithFilePath:(NSString *)filepath
{
	if (!filepath) {
        return NO;
    }
    return [self addFavoriteWithSignature:[CMRThreadSignature threadSignatureFromFilepath:filepath]];
}

#pragma mark Remove
- (BOOL)removeFavoriteWithThread:(id)threadIdentifier ofBoard:(NSString *)boardName
{
	id boardIDs; // TODO 複数存在する場合の処理
    unsigned boardID;
	BOOL isSuccess = NO;

	boardIDs = [[DatabaseManager defaultManager] boardIDsForName:boardName];
	if (!boardIDs) {
        return NO;
	}

    boardID = [[boardIDs objectAtIndex:0] unsignedIntValue];
	isSuccess = [[DatabaseManager defaultManager] removeFavoriteThreadIdentifier:threadIdentifier onBoardID:boardID];
	
	if (isSuccess) {
		UTILNotifyName(CMRFavoritesManagerDidRemoveFavoritesNotification);
	}
	return isSuccess;
}

- (BOOL)removeFromFavoritesWithSignature:(CMRThreadSignature *)signature
{	
	if (!signature) {
        return NO;
    }
	return [self removeFavoriteWithThread:[signature identifier] ofBoard:[signature boardName]];
}

- (BOOL)removeFromFavoritesWithFilePath:(NSString *)filepath
{
	if (!filepath) {
        return NO;
    }
	return [self removeFromFavoritesWithSignature:[CMRThreadSignature threadSignatureFromFilepath:filepath]];
}
@end
