//: CMRTask.h
/**
  * $Id: CMRTask.h,v 1.2 2007-09-04 07:45:43 tsawada2 Exp $
  * 
  * Copyright (c) 2001-2003, Takanori Ishikawa.  All rights reserved.
  * See the file LICENSE for copying permission.
  */

#import <Foundation/Foundation.h>
#import <AppKit/NSNibDeclarations.h>


@protocol CMRTask<NSObject>
/*!
 * @method      identifier
 * @abstract    ʎq
 * @discussion  
 *
 * TaskManagerXʂ邽߂̈ӂȃIuWFNg
 * nilԂƃ}l[Wɓo^ȂB
 * ʏ͕ԂB
 *
 * @result      ʎqƂȂIuWFNg
 */
- (id) identifier;

- (NSString *) title;
- (NSString *) message;
- (BOOL) isInProgress;

// from 0.0 to 100.0 (or -1: Indeterminate)
- (double) amount;
- (IBAction) cancel : (id) sender;
@end

@interface NSObject(CMRTaskInformalProtocol)
- (void)setTitle:(NSString *)title;
- (void)setMessage:(NSString *)msg;
- (void)setIsInProgress:(BOOL)isInProgress;
- (void)setAmount:(double)doubleValue;
@end

// Notification Name.
extern NSString *const CMRTaskWillStartNotification;
extern NSString *const CMRTaskDidFinishNotification;


extern NSString *const CMRTaskWillProgressNotification;