//
//  BSPullDownImageButtonCell.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 05/01/09.
//  Copyright 2005-2010 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSPullDownImageButtonCell.h"
#import <SGAppKit/NSCell-SGExtensions.h>

@implementation BSPullDownImageButtonCell
- (id)initWithBase:(id)cell image:(NSImage *)image pressedImage:(NSImage *)pressedImage
{
	if (self = [super initTextCell:@"" pullsDown:YES]) {
		m_btnImg = [image retain];
        m_btnImgPressed = [pressedImage retain];
        if (cell) {
            [self setAttributesFromCell:cell];
        }
        [self setArrowPosition:NSPopUpNoArrow];
	}
	return self;
}

- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
    NSPoint iconPoint;
    NSImage *image = [self isHighlighted] ? m_btnImgPressed : m_btnImg;
	
    iconPoint.x = cellFrame.origin.x;
    iconPoint.y = cellFrame.origin.y;

    if (image) {
        [image setFlipped:[controlView isFlipped]];
        // fromRect: "If you pass in NSZeroRect, the entire image is drawn."
        [image drawInRect:cellFrame fromRect:NSZeroRect operation:NSCompositeSourceOver fraction:1.0];
    }
}

- (void)setControlSize:(NSControlSize)size
{
    [super setControlSize:size];
    if (size == NSSmallControlSize) {
        [self setFont:[NSFont systemFontOfSize:[NSFont systemFontSizeForControlSize:NSSmallControlSize]]];
    }
}

- (void)dealloc
{
	[m_btnImg release];
    m_btnImg = nil;
	[m_btnImgPressed release];
    m_btnImgPressed = nil;
	[super dealloc];
}
@end
