//
//  BSTagValueTransformer.m
//  BathyScaphe
//
//  Created by Tsutomu Sawada on 06/08/03.
//  Copyright 2006 BathyScaphe Project. All rights reserved.
//  encoding="UTF-8"
//

#import "BSTagValueTransformer.h"


@implementation BSTagValueTransformer
+ (Class) transformedValueClass
{
    return [NSNumber class];
}
 
+ (BOOL) allowsReverseTransformation
{
    return YES;
}
 
- (id) transformedValue: (id) beforeObject
{
	NSInteger tmp = 0;
	if (beforeObject != nil) {
		if ([beforeObject respondsToSelector: @selector(integerValue)]) {
			tmp = [beforeObject integerValue];
		} else {
				[NSException raise: NSInternalInconsistencyException
							format: @"Value (%@) does not respond to -intValue.",
				[beforeObject class]];
		}

		if (tmp == NSNotFound) tmp = -1;
	}

	return [NSNumber numberWithInteger:tmp];
}

- (id) reverseTransformedValue: (id) value;
{
	NSInteger returnValue = 0;
    if (value != nil) {
		if ([value respondsToSelector: @selector(integerValue)]) {
			returnValue = [value integerValue];
		} else {
			[NSException raise: NSInternalInconsistencyException
						format: @"Value (%@) does not respond to -intValue.",
			[value class]];
		}

		if (returnValue == -1) returnValue = NSNotFound;
	}

    return [NSNumber numberWithInteger:returnValue];
}
@end

@implementation BSTagToBoolTransformer
+ (Class) transformedValueClass
{
    return [NSNumber class];
}
 
+ (BOOL) allowsReverseTransformation
{
    return NO;
}
 
- (id) transformedValue: (id) beforeObject
{
	BOOL	tmp = NO;
	if (beforeObject != nil) {
		if ([beforeObject respondsToSelector: @selector(integerValue)]) {
			tmp = ([beforeObject integerValue] != 3) ? YES : NO;
		} else {
			[NSException raise: NSInternalInconsistencyException
						format: @"Value (%@) does not respond to -intValue.", [beforeObject class]];
		}
	}

	return [NSNumber numberWithBool: tmp];
}
@end
