/**
  * $Id: CMRBrowser-Action.m,v 1.65 2007-11-13 02:00:27 tsawada2 Exp $
  * 
  * CMRBrowser-Action.m
  *
  * Copyright (c) 2003, Takanori Ishikawa.
  * See the file LICENSE for copying permission.
  */
#import "CMRBrowser_p.h"
#import "CMRMainMenuManager.h"
#import "CMRHistoryManager.h"
#import "CMRThreadsList_p.h"
#import "FolderBoardListItem.h"
#import "CMRReplyDocumentFileManager.h"
extern BOOL isOptionKeyDown(void); // described in CMRBrowser-Delegate.m

@class IndexField;

@implementation CMRBrowser(Action)
static int expandAndSelectItem(BoardListItem *selected, NSArray *anArray, NSOutlineView *bLT)
{
	NSEnumerator *iter_ = [anArray objectEnumerator];
	id	eachItem;
	int index = -1;
	while (eachItem = [iter_ nextObject]) {
		// uĂJeSvɋ
		if (NO == [SmartBoardList isCategory: eachItem] || NO == [(FolderBoardListItem *)eachItem hasChildren]) continue;

		if (NO == [bLT isItemExpanded: eachItem]) [bLT expandItem: eachItem];

		index = [bLT rowForItem: selected];
		if (-1 != index) { // I
			return index;
		} else { // JeS̃TuJeSJČ
			index = expandAndSelectItem(selected, [(FolderBoardListItem *)eachItem items], bLT);
			if (-1 == index) // ̃JeŜǂ̃TuJeSɂȂ
				[bLT collapseItem: eachItem]; // ̃JeS͕
		}
	}
	return index;
}

- (int) searchRowForItemInDeep: (BoardListItem *) boardItem fromSource: (id) source forView: (NSOutlineView *) olView
{
	int	index = [olView rowForItem: boardItem];
	
	if (index == -1) {
		index = expandAndSelectItem(boardItem, source, olView);
	}
	
	return index;
}

#pragma mark -
- (IBAction) focus : (id) sender
{
    [[self window] makeFirstResponder : [[self threadsListTable] enclosingScrollView]];
}

- (void) selectRowWhoseNameIs : (NSString *) brdname_
{
	NSOutlineView	*bLT = [self boardListTable];
    SmartBoardList       *source;
	BoardListItem	*selected;
    int				index;

    source = (SmartBoardList *)[bLT dataSource];
    
    selected = [source itemForName : brdname_];

    if (nil == selected) { // fIɒǉ
		SmartBoardList	*defaultList_ = [[BoardManager defaultManager] defaultList];
		BoardListItem *willAdd_ = [defaultList_ itemForName: brdname_];
		if(nil == willAdd_) {
			NSLog(@"No BoardListItem for board %@ found.", brdname_);
			return;
		} else {
			[source addItem : willAdd_ afterObject : nil];
			selected = [source itemForName : brdname_];
		}
	}

	index = [self searchRowForItemInDeep: selected fromSource: [source boardItems] forView: bLT];	
	if (index == -1) return;
	if ([bLT isRowSelected: index]) { // łɑIsIĂ
		UTILNotifyName(CMRBrowserThListUpdateDelegateTaskDidFinishNotification);
	} else {
		[bLT selectRowIndexes: [NSIndexSet indexSetWithIndex: index] byExtendingSelection: NO];
	}
	[bLT scrollRowToVisible : index];
}

- (IBAction) reloadThreadsList : (id) sender
{
	[[self document] reloadThreadsList];
	
	int row_ = [[self threadsListTable] selectedRow];
	int mask_ = [CMRPref threadsListAutoscrollMask];
	
	if ((mask_ & CMRAutoscrollWhenTLUpdate) > 0 && row_ != -1){
		// XgőIĂ鍀ڂ܂ŃXN[
		[[self threadsListTable] scrollRowToVisible : row_];
	}else{
		// Xg̐擪܂ŃXN[
		[[self threadsListTable] scrollRowToVisible : 0];
	}
}

- (void) openThreadsInThreadWindow : (NSArray *) threads
{
	NSEnumerator		*Iter_;
	NSDictionary		*thread_;
	
	Iter_ = [threads objectEnumerator];
	while ((thread_ = [Iter_ nextObject])) {
		NSString				*path_;
		
		path_ = [CMRThreadAttributes pathFromDictionary : thread_];
		if ([self shouldShowContents] && [path_ isEqualToString: [self path]]) {
			continue;
		}
		[CMRThreadDocument showDocumentWithContentOfFile : path_
											 contentInfo : thread_];
	}
}
- (NSArray *) targetThreadsForAction : (SEL) action
{
	// currentlly no use action.
	NSEvent *event = [NSApp currentEvent];
	NSPoint mouse = [event locationInWindow];
	NSView *targetView = [[[self window] contentView] hitTest : mouse];
	NSArray *result = nil;
	//NSLog(@"%@", NSStringFromClass([targetView class]));
	if ([targetView isKindOfClass : [m_threadsListTable class]] /*|| nil == targetView*/) {	// XbhXg
		result = [self selectedThreadsReallySelected];
		if (0 == [result count]) {
			if (nil == [self threadURL]) {
				result = [NSArray empty];
			}
			result = [self selectedThreads];
		}
	} else if (nil == targetView) {
		// j[o[̓L[Cxg
		// 邢̓c[o[{^
		// XbhXgɃtH[JXĂ邩ǂőΏۂXCb`B
		NSView *focusedView_ = (NSView *)[[self window] firstResponder];
		if (focusedView_ == [self textView] || [self isIndexFieldFirstResponder]) {
			// tH[JXXbh{̈ɂ
			id selected = [self selectedThread];
			if (nil == selected) {
				result = [NSArray empty];
			} else {
				result = [NSArray arrayWithObject : selected];
			}
		} else { // tH[JXȊÖ̗ɂFXbhXg̑IڂD
			result = [self selectedThreadsReallySelected];
			if (0 == [result count]) {
				if (nil == [self threadURL]) {
					result = [NSArray empty];
				}
				result = [self selectedThreads];
			}
		}	
	} else { //@Xbh{̈悩B
		id selected = [self selectedThread];
		if (nil == selected) {
			result = [NSArray empty];
		} else {
			result = [NSArray arrayWithObject : selected];
		}
	}
	return result;
}

- (IBAction) openBBSInBrowser : (id) sender
{
	NSURL		*url_;
	
	url_ = [[self document] boardURL];
	if (url_ != nil) {
		[[NSWorkspace sharedWorkspace] openURL : url_ inBackGround : [CMRPref openInBg]];
	} else {
		[super openBBSInBrowser : sender];
	}
}
/*
- (IBAction) openLogfile : (id) sender
{
	[self openThreadsLogFiles :  [self targetThreadsForAction : _cmd]];
}
- (IBAction) openInBrowser : (id) sender
{
	[self openThreadsInBrowser : [self targetThreadsForAction : _cmd]];
}
*/
- (IBAction) openSelectedThreads : (id) sender
{
	[self openThreadsInThreadWindow : [self targetThreadsForAction : _cmd]];
}
- (IBAction) selectThread : (id) sender
{
	// ̃fBt@CAEL[ĂƂ
	// NbNōڂIĂXbhǂݍ܂Ȃ
	if (isOptionKeyDown())
		return;
	
	if (NO == [self shouldShowContents])
		return;
	
	[self showSelectedThread : self];
}
- (BOOL) shouldLoadThreadAtPath : (NSString *) filepath
{
	if (NO == [self shouldShowContents]) return NO;
	
	return (NO == [filepath isSameAsString : [self path]] || NO == [[NSFileManager defaultManager] fileExistsAtPath : filepath]);
}
- (void) showThreadAtRow : (int) rowIndex
{
	NSTableView				*tbView_ = [self threadsListTable];
	NSDictionary			*thread_;
	NSString				*path_;
	
	NSAssert2(
		(rowIndex >= 0 && rowIndex < [tbView_ numberOfRows]),
		@"  rowIndex was over. size = %d but was %d",
		[tbView_ numberOfRows],
		rowIndex);
	
	thread_ = [[self currentThreadsList] 
				threadAttributesAtRowIndex:rowIndex inTableView:tbView_];
	path_ = [CMRThreadAttributes  pathFromDictionary : thread_];
	
	if ([self shouldLoadThreadAtPath : path_]) {
		[self setThreadContentWithFilePath : path_
								 boardInfo : thread_];
		// tH[JX
		//if ([CMRPref moveFocusToViewerWhenShowThreadAtRow]) {
			[[self window] makeFirstResponder : [self textView]];
		//}
		[self synchronizeWindowTitleWithDocumentName];
	}
}

- (IBAction) showSelectedThread : (id) sender
{
	if (-1 == [[self threadsListTable] selectedRow]) return;
	if ([[self threadsListTable] numberOfSelectedRows] != 1) return;
	
	[self showThreadAtRow : [[self threadsListTable] selectedRow]];
}


/*
	2005-06-06 tsawada2 <ben-sawa@td5.so-net.ne.jp>
	Key Binding ̕֋X}邽߂̃\bhB
	return L[ɑΉANVɂw肵ĂƁA2yĈƂA3yĈƂ
	ꂼɉĎIɓK؂ȓiʑŊJAɕ\jĂяoƂd|B
*/
- (IBAction) showOrOpenSelectedThread : (id) sender
{
	if ([self shouldShowContents]) {
		[self showSelectedThread : sender];
	} else {
		[self openSelectedThreads : sender];
	}
}

- (IBAction)selectThreadOnly:(id)sender
{
	// do nothing.
}
/*
#pragma mark MeteorSweeper Key Binding Action Additions
- (IBAction) scrollPageDownThViewOrThListProperly: (id) sender
{
	if ([CMRPref moveFocusToViewerWhenShowThreadAtRow] || ![self shouldShowContents]) {
		[[[self threadsListTable] enclosingScrollView] pageDown: sender];
	} else {
		[[self textView] scrollPageDown: sender];
	}
}

- (IBAction) scrollPageUpThViewOrThListProperly: (id) sender
{
	if ([CMRPref moveFocusToViewerWhenShowThreadAtRow] || ![self shouldShowContents]) {
		[[[self threadsListTable] enclosingScrollView] pageUp: sender];
	} else {
		[[self textView] scrollPageUp: sender];
	}
}

- (IBAction) scrollPageDownThreadViewWithoutFocus: (id) sender
{
	if(![self shouldShowContents]) {
		NSBeep();
		return;
	}
	
	[[self textView] scrollPageDown: sender];
}

- (IBAction) scrollPageUpThreadViewWithoutFocus: (id) sender
{
	if(![self shouldShowContents]) {
		NSBeep();
		return;
	}
	
	[[self textView] scrollPageUp: sender];
}
*/
#pragma mark History Menu
- (IBAction) showThreadWithMenuItem : (id) sender
{
	// ̔̃XbhɈړ邱ƂlAXꗗł̑IԂĂ
	if ([self shouldShowContents]) {
		[[self threadsListTable] deselectAll: nil];
		[super showThreadWithMenuItem : sender];
	} else {
		id historyItem = nil;

		if ([sender respondsToSelector : @selector(representedObject)]) {
			id o = [sender representedObject];
			historyItem = o;
		}
		
		[CMRThreadDocument showDocumentWithHistoryItem: historyItem];	
	}
}

#pragma mark Deletion
- (BOOL) forceDeleteThreads: (NSArray *) threads
{
	NSMutableArray	*array_ = [NSMutableArray arrayWithCapacity: [threads count]];
	NSArray			*arrayWithReplyFiles_;
	NSEnumerator	*iter_ = [threads objectEnumerator];
	NSFileManager	*fm = [NSFileManager defaultManager];
	id				eachItem_;
	NSString		*path_;

	while (eachItem_ = [iter_ nextObject]) {
		path_ = [CMRThreadAttributes pathFromDictionary: eachItem_];
		if ([fm fileExistsAtPath: path_]) {
			[array_ addObject: path_];
		} else {
			NSLog(@"File does not exist (although we're going to remove it!)\n%@", path_);
		}
	}

	arrayWithReplyFiles_ = [[CMRReplyDocumentFileManager defaultManager] replyDocumentFilesArrayWithLogsArray: array_];
	return [[CMRTrashbox trash] performWithFiles: arrayWithReplyFiles_ fetchAfterDeletion: NO];
}

- (void) _showDeletionAlertSheet : (id) sender
						  ofType : (BSThreadDeletionType) aType
					  allowRetry : (BOOL) allowRetry
				   targetThreads : (NSArray *) threadsArray
{
	NSAlert		*alert_;
	NSString	*title_;
	NSString	*message_;

	alert_ = [[[NSAlert alloc] init] autorelease];

	switch(aType) {
	case BSThreadAtViewerDeletionType:
	{
		NSString *tmp_ = [self localizedString : kDeleteThreadTitleKey];
		NSString *threadTitle_ = [CMRThreadAttributes threadTitleFromDictionary : [threadsArray lastObject]];
		title_ = [NSString stringWithFormat : tmp_, threadTitle_];
		message_ = [self localizedString : kDeleteThreadMessageKey];
	}
		break;
	case BSThreadAtBrowserDeletionType:
		title_ = [self localizedString : kBrowserDelThTitleKey];
		message_ = [self localizedString : kBrowserDelThMsgKey];
		break;
	case BSThreadAtFavoritesDeletionType:
		title_ = [self localizedString : kDeleteFavTitleKey];
		message_ = [self localizedString : kDeleteFavMsgKey];
		break;
	default : 
		title_ = @"Implementaion Error";
		message_ = @"Please report that You see this message. Oh, you should press Cancel button. Sorry.";
		break;
	}
	
	[alert_ setMessageText : title_];
	[alert_ setInformativeText : message_];
	[alert_ addButtonWithTitle : [self localizedString : kDeleteOKBtnKey]];
	[alert_ addButtonWithTitle : [self localizedString : kDeleteCancelBtnKey]];
	if (allowRetry) {
		NSButton	*deleteAndReloadBtn_;
		deleteAndReloadBtn_ = [alert_ addButtonWithTitle : [self localizedString : kDeleteAndReloadBtnKey]];
		[deleteAndReloadBtn_ setKeyEquivalent : @"r"];
	}

	//NSBeep();
	[alert_ beginSheetModalForWindow : [self window]
					   modalDelegate : self
					  didEndSelector : @selector(_threadDeletionSheetDidEnd:returnCode:contextInfo:)
					     contextInfo : [threadsArray retain]];
}

- (IBAction) deleteThread : (id) sender
{
	NSArray			*targets_ = [self targetThreadsForAction : _cmd];
	int				numOfSelected_ = [targets_ count];
	
	if (numOfSelected_ == 0) return;
	
	if (numOfSelected_ == 1) {
		NSString *path_ = [CMRThreadAttributes pathFromDictionary : [targets_ lastObject]];
		if ([CMRPref quietDeletion]) {
			if (NO == [self forceDeleteThreadAtPath : path_ alsoReplyFile : YES]) {
				NSBeep();
				NSLog(@"Deletion failed : %@", path_);
			}
		} else {
			[self _showDeletionAlertSheet : sender
								   ofType : BSThreadAtViewerDeletionType
							   allowRetry : ([CMRPref isOnlineMode] && [self shouldShowContents] && [[self path] isEqualToString : path_])
							targetThreads : targets_];
		}
	} else {
		if ([CMRPref quietDeletion]) {
			if (NO == [self forceDeleteThreads: targets_]) {
				NSBeep();
				NSLog(@"CMRTrashbox returns some error.");
			}			
		} else {
			[self _showDeletionAlertSheet : sender
								   ofType : ([[self currentThreadsList] isFavorites] ? BSThreadAtFavoritesDeletionType
																					 : BSThreadAtBrowserDeletionType)
							   allowRetry : NO
							targetThreads : targets_];
		}
	}
}

- (void) _threadDeletionSheetDidEnd : (NSAlert *) alert
						 returnCode : (int      ) returnCode
						contextInfo : (void	   *) contextInfo
{
	if (returnCode == NSAlertFirstButtonReturn) {
		if (NO == [self forceDeleteThreads: (NSArray *)contextInfo]) {
			NSBeep();
			NSLog(@"CMRTrashbox returns some error.");
		}
	} else if (returnCode == NSAlertThirdButtonReturn) {
		id item_ = [(NSArray *)contextInfo lastObject];
		NSString *path_ = [CMRThreadAttributes pathFromDictionary: item_];
		if (NO == [self forceDeleteThreadAtPath: path_ alsoReplyFile: NO]) {
			NSBeep();
			NSLog(@"Deletion failed : %@, so reloading opreation has been canceled.", path_);
		}
	}
}

#pragma mark Filter, Search
- (IBAction) selectFilteringMask : (id) sender
{
	NSNumber	*represent_;
	int			mask_;
	
	if (NO == [sender respondsToSelector : @selector(representedObject)]) {
		UTILDebugWrite(@"Sender must respondsToSelector : -representedObject");
		return;
	}
	
	represent_ = [sender representedObject];
	UTILAssertKindOfClass(represent_, NSNumber);

	mask_ = [represent_ unsignedIntValue];
	[self changeThreadsFilteringMask : mask_];

//	[[CMRMainMenuManager defaultManager] synchronizeStatusFilteringMenuItemState];
}

- (void) synchronizeWithSearchField
{
	[[self document] searchThreadsInListWithCurrentSearchString];
	[self synchronizeWindowTitleWithDocumentName];

	[[self threadsListTable] reloadData];
}

- (IBAction) searchThread : (id) sender
{
	[self synchronizeWithSearchField];
}

- (IBAction)collapseOrExpandThreadViewer:(id)sender
{
	[self splitView:[self splitView] didDoubleClickInDivider:0];
}

- (unsigned int)isToolbarContainsSearchField
{
	NSToolbar	*toolbar = [[self window] toolbar];
	UTILAssertNotNil(toolbar);

	if (![toolbar isVisible]) {
		[toolbar setVisible:YES];
	}

	NSEnumerator *iter = [[toolbar visibleItems] objectEnumerator];
	id	item;
	while (item = [iter nextObject]) {
		if ([[item itemIdentifier] isEqualToString:kToolbarSearchFieldItemKey]) {
			return [toolbar displayMode] == NSToolbarDisplayModeLabelOnly ? 1 : 0;
		}
	}

	return 2;
}

- (IBAction)showSearchThreadPanel:(id)sender
{
	unsigned int toolbarState = [self isToolbarContainsSearchField];

	switch (toolbarState) {
	case 0:
		[[self searchField] selectText:sender];
		break;
	case 1:
		[[[self window] toolbar] setDisplayMode:NSToolbarDisplayModeIconAndLabel];
		[[self searchField] selectText:sender];
		break;
	default:
		NSBeep();
		break;
	}
}

#pragma mark View Menu
- (IBAction) collapseOrExpandBoardList : (id) sender
{
	RBSplitSubview	*tmp_;
	
	tmp_ = [self boardListSubView];
	if ([tmp_ isCollapsed]) {
		[tmp_ expand];
	} else {
		[tmp_ collapse];
	}
	// Leopard b΍
	[[tmp_ splitView] adjustSubviews];
}

#pragma mark -

/*
NSTableView action, doubleAction ̓J̃NbNł
̂ŁAȉ̃\bhŃtbNB
*/
- (IBAction) tableViewActionDispatch : (id        ) sender
						   actionKey : (NSString *) aKey
					   defaultAction : (SEL       ) defaultAction
{
	SEL				action_;
	
	// J̃NbN
	if (-1 == [[self threadsListTable] clickedRow])
		return;

	// ݒ肳ꂽANVɃfBXpb`
	action_ = SGTemplateSelector(aKey);
	if (NULL == action_ || _cmd == action_)
		action_ = defaultAction;
	
	[NSApp sendAction:action_ to:self from:sender];
}
- (IBAction) listViewAction : (id) sender
{
	[self tableViewActionDispatch : sender
						actionKey : kThreadsListTableActionKey
					defaultAction : @selector(selectThread:)];
}
- (IBAction) listViewDoubleAction : (id) sender
{
	[self tableViewActionDispatch : sender
						actionKey : kThreadsListTableDoubleActionKey
					defaultAction : @selector(openSelectedThreads:)];
}
- (IBAction) boardListViewDoubleAction : (id) sender
{
	UTILAssertKindOfClass(sender, NSOutlineView);

	int	rowNum = [sender clickedRow];
	if (-1 == rowNum) return;
	
	id item_ = [sender itemAtRow : rowNum];

	if ([sender isExpandable : item_]) {
		if ([sender isItemExpanded : item_]) [sender collapseItem : item_];
		else [sender expandItem : item_];
	}
}	
@end
